/*!
 * 图片预览
 */
var imageView = window.imageView || {};

imageView.Previewbox=(function(){
    return {
        init:function(target){
            imageView.Previewbox.images = [];
            this.appendUl(target.getAttribute('imageIndex'));
            imageView.Previewbox.images.push(target.getAttribute('imageIndex'));
        },
        appendUl:function(imageIndex){
            $('body').append('<ul style="display: none" id='+imageIndex+'>');
            $('body').append('</ul>');
        },
        register:function(){
            $(document).on('click', function (ev) {
                var imageIndex = ev.target.getAttribute("imageIndex");
                if (imageIndex) {
                    ev.preventDefault();
                    if($.inArray(imageIndex, imageView.Previewbox.images)==-1){
                        imageView.Previewbox.init(ev.target);
                            var $ul = $('#'+imageIndex);
                            $.each($('a'),function(index,item){
                                if(item.getAttribute("imageIndex")==imageIndex){
                                    $ul.append('<li><img src='+item.href+' alt='+(item.getAttribute("imageName")||'')+'></li>');
                                }
                            });
                            $ul.viewer();
                        imageView.Previewbox.liTrigger(ev.target);
                    }else{
                        imageView.Previewbox.liTrigger(ev.target);
                    }
                }
            });

        },
        liTrigger:function(target){
            $.each($('#'+target.getAttribute("imageIndex")+' li img'),function(index,item){
                if(item.src==target.href){
                    $(item).trigger('click');
                }
            });
        }
    };
})();
$(document).ready(function () {
    imageView.Previewbox.register();
});
