package hls.support.core.wechat.utils;

/**
 * Created with IntelliJ IDEA.
 * User: Jeffery
 * Date: 2017/12/22
 * Time: 13:26
 * To change this template use File | Settings | File Templates.
 */
public class WechatSendMsgFmtDataUtil {

    /**
     * text消息
     *
     * @param touser  UserID列表（消息接收者，多个接收者用‘|’分隔）。特殊情况：指定为@all，则向关注该企业应用的全部成员发送————"touser": "UserID1|UserID2|UserID3"
     * @param toparty PartyID列表，多个接受者用‘|’分隔。当touser为@all时忽略本参数————"toparty": " PartyID1 | PartyID2 "
     * @param totag   TagID列表，多个接受者用‘|’分隔。当touser为@all时忽略本参数————"totag": " TagID1 | TagID2 "
     * @param agentid 企业应用的id，整型。可在应用的设置页面查看
     * @param content 消息内容
     */
    public static String STextMsg(String touser, String toparty, String totag, String msgtype, int agentid, String content) {
        String postJson = "{\"agentid\":%s,\"touser\": \"%s\",\"toparty\": \"%s\",\"totag\": \"%s\",\"msgtype\":\"%s\",\"text\": {\"content\": \"%s\"},\"safe\":0}";
        return String.format(postJson, agentid, touser, toparty, totag, msgtype, content);
    }

    /**
     * news消息
     *
     * @param touser       UserID列表（消息接收者，多个接收者用‘|’分隔）。特殊情况：指定为@all，则向关注该企业应用的全部成员发送————"touser": "UserID1|UserID2|UserID3"
     * @param toparty      PartyID列表，多个接受者用‘|’分隔。当touser为@all时忽略本参数————"toparty": " PartyID1 | PartyID2 "
     * @param totag        TagID列表，多个接受者用‘|’分隔。当touser为@all时忽略本参数————"totag": " TagID1 | TagID2 "
     * @param agentid      企业应用的id，整型。可在应用的设置页面查看
     * @param articlesList 图文集合
     */
    public static String SNewsMsg(String touser, String toparty, String totag, int agentid, String articlesList) {
        String postJson = "{\"touser\": \"%s\",\"toparty\": \"%s\",\"totag\": \"%s\",\"msgtype\": \"news\",\"agentid\": %s,\"news\": {\"articles\":%s}}";
        return String.format(postJson, touser, toparty, totag, agentid, articlesList);
    }


    /**
     * image消息
     *
     * @param touser   UserID列表（消息接收者，多个接收者用‘|’分隔）。特殊情况：指定为@all，则向关注该企业应用的全部成员发送————"touser": "UserID1|UserID2|UserID3"
     * @param toparty  PartyID列表，多个接受者用‘|’分隔。当touser为@all时忽略本参数————"toparty": " PartyID1 | PartyID2 "
     * @param agentid  企业应用的id，整型。可在应用的设置页面查看
     * @param media_id 媒体资源文件ID
     */
    public static String SImageMsg(String touser, String toparty, int agentid, String media_id) {
        String PostData = "{\"touser\": \"%s\",\"toparty\": \"%s\",\"msgtype\": \"image\",\"agentid\":  %s,\"image\": {\"media_id\":\"%s\"},\"safe\":\"0\"}";
        return String.format(PostData, touser, toparty, agentid, media_id);
    }

    /**
     * voice消息
     *
     * @param touser   UserID列表（消息接收者，多个接收者用‘|’分隔）。特殊情况：指定为@all，则向关注该企业应用的全部成员发送————"touser": "UserID1|UserID2|UserID3"
     * @param toparty  PartyID列表，多个接受者用‘|’分隔。当touser为@all时忽略本参数————"toparty": " PartyID1 | PartyID2 "
     * @param totag    TagID列表，多个接受者用‘|’分隔。当touser为@all时忽略本参数————"totag": " TagID1 | TagID2 "
     * @param agentid  企业应用的id，整型。可在应用的设置页面查看
     * @param media_id 媒体资源文件ID
     */
    public static String SVoiceMsg(String touser, String toparty, String totag, int agentid, String media_id) {
        String PostData = "{\"touser\": \"%s\",\"toparty\":  \"%s\",\"totag\":  \"%s\",\"msgtype\": \"voice\",\"agentid\":  %s,\"voice\": {\"media_id\":%s},\"safe\":\"0\"}";
        return String.format(PostData, touser, toparty, totag, agentid, media_id);
    }

    /**
     * video消息
     *
     * @param touser      UserID列表（消息接收者，多个接收者用‘|’分隔）。特殊情况：指定为@all，则向关注该企业应用的全部成员发送————"touser": "UserID1|UserID2|UserID3"
     * @param toparty     PartyID列表，多个接受者用‘|’分隔。当touser为@all时忽略本参数————"toparty": " PartyID1 | PartyID2 "
     * @param totag       TagID列表，多个接受者用‘|’分隔。当touser为@all时忽略本参数————"totag": " TagID1 | TagID2 "
     * @param agentid     企业应用的id，整型。可在应用的设置页面查看
     * @param media_id    媒体资源文件ID
     * @param title       视频消息的标题
     * @param description 视频消息的描述
     */
    public static String SVideoMsg(String touser, String toparty, String totag, int agentid, String media_id, String title, String description) {
        String PostData = "{\"touser\": \"%s\",\"toparty\": \"%s\",\"totag\": \"%s\",\"msgtype\": \"video\",\"agentid\": %s,\" video\": {\"media_id\":%s,\"title\": \"%s\",\"description\": \"%s\"},\"safe\":\"0\"}";
        return String.format(PostData, touser, toparty, totag, agentid, media_id, title, description);
    }

    /**
     * file消息
     *
     * @param touser   UserID列表（消息接收者，多个接收者用‘|’分隔）。特殊情况：指定为@all，则向关注该企业应用的全部成员发送————"touser": "UserID1|UserID2|UserID3"
     * @param toparty  PartyID列表，多个接受者用‘|’分隔。当touser为@all时忽略本参数————"toparty": " PartyID1 | PartyID2 "
     * @param totag    TagID列表，多个接受者用‘|’分隔。当touser为@all时忽略本参数————"totag": " TagID1 | TagID2 "
     * @param agentid  企业应用的id，整型。可在应用的设置页面查看
     * @param media_id 媒体资源文件ID
     */
    public static String SFileMsg(String touser, String toparty, String totag, int agentid, String media_id) {
        String PostData = "{\"touser\": \"%s\",\"toparty\": \"%s\",\"totag\": \"%s\",\"msgtype\": \"file\",\"agentid\": %s,\"file\": {\"media_id\":\"%s\"},\"safe\":\"0\"}";
        return String.format(PostData, touser, toparty, totag, agentid, media_id);
    }

    /**
     * mpnews消息
     *
     * @param touser       UserID列表（消息接收者，多个接收者用‘|’分隔）。特殊情况：指定为@all，则向关注该企业应用的全部成员发送————"touser": "UserID1|UserID2|UserID3"
     * @param toparty      PartyID列表，多个接受者用‘|’分隔。当touser为@all时忽略本参数————"toparty": " PartyID1 | PartyID2 "
     * @param totag        TagID列表，多个接受者用‘|’分隔。当touser为@all时忽略本参数————"totag": " TagID1 | TagID2 "
     * @param agentid      企业应用的id，整型。可在应用的设置页面查看
     * @param articlesList mpnews集合
     */
    public static String SMpNewsMsg(String touser, String toparty, String totag, int agentid, String articlesList) {
        String postData = "{\"touser\": \"%s\",\"toparty\": \"%s\",\"totag\": \"%s\",\"msgtype\": \"mpnews\",\"agentid\": %s,\"mpnews\": {\"articles\":\"%s\"}\"safe\":\"0\"}";
        return String.format(postData, touser, toparty, totag, agentid, articlesList);
    }
}
