package hls.support.core.wechat.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
//import org.apache.http.HttpEntity;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
//import org.apache.http.entity.ContentType;
//import org.apache.http.entity.StringEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
//import org.apache.http.util.EntityUtils;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: yang
 * Date: 2017-12-04
 * Time: 15:37
 */
public class WechatHttpUtils {
    public static final int CODE_REQUEST_FAILED = -12;
    private static Logger logger = LoggerFactory.getLogger(WechatHttpUtils.class);

    public static JSONObject postForJson(String url, Map<String, Object> params) {
        JSONObject jsonObject = new JSONObject();
        CloseableHttpResponse execute = null;
        try {
            HttpPost post = new HttpPost(url);
           HttpEntity param = new StringEntity(JSON.toJSONString(params), ContentType.APPLICATION_JSON);
            post.setEntity(param);
            CloseableHttpClient client = HttpClients.createDefault();
            execute = client.execute(post);
        } catch (IOException e) {
            jsonObject.put("errcode", CODE_REQUEST_FAILED);
            jsonObject.put("errmsg", e.getMessage());
            logger.error("client execute failed: ", e);
        }
        if (execute != null) {
            HttpEntity entity = execute.getEntity();
            try {
                String s = EntityUtils.toString(entity, "utf-8");
                jsonObject = JSON.parseObject(s);
            } catch (IOException e) {
                logger.error("entity parse failed: ", e);
            }
        }
        return jsonObject;
    }

    public static JSONObject getForJson(String url) {
        JSONObject jsonObject = new JSONObject();
        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectTimeout(5000)   //设置连接超时时间
                .setConnectionRequestTimeout(5000) // 设置请求超时时间
                .setSocketTimeout(5000)
                .setRedirectsEnabled(true)//默认允许自动重定向
                .build();
        CloseableHttpResponse execute = null;
        try {
            HttpGet get = new HttpGet(url);
            get.setConfig(requestConfig);
            CloseableHttpClient client = HttpClients.createDefault();
            execute = client.execute(get);
        } catch (IOException e) {
            jsonObject.put("errcode", CODE_REQUEST_FAILED);
            jsonObject.put("errmsg", e.getMessage());
            logger.error("client execute failed: ", e);
        }
        if (execute != null) {
            HttpEntity entity = execute.getEntity();
            try {
                String s = EntityUtils.toString(entity, "utf-8");
                jsonObject = JSON.parseObject(s);
            } catch (IOException e) {
                logger.error("entity parse failed: ", e);
            }
        }
        return jsonObject;
    }
}
