package hls.support.core.wechat.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import hls.support.core.wechat.dto.WechatAccount;
import hls.support.core.wechat.mapper.WechatAccountMapper;
import hls.support.core.wechat.mapper.WechatEnterpriseAppMapper;
import hls.support.core.wechat.service.IWechatEnterpriseAppService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import hls.support.core.wechat.dto.WechatEnterpriseApp;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

@Service
@Transactional(rollbackFor = Exception.class)
public class WechatEnterpriseAppServiceImpl extends BaseServiceImpl<WechatEnterpriseApp> implements IWechatEnterpriseAppService {
    @Autowired
    private WechatEnterpriseAppMapper wechatEnterpriseAppMapper;

    @Autowired
    private WechatAccountMapper wechatAccountMapper;

    @Override
    public List<WechatEnterpriseApp> selectApps(IRequest iRequest, WechatEnterpriseApp dto, int page, int pageSize) {
        PageHelper.startPage(page, pageSize);
        return wechatEnterpriseAppMapper.queryAccount(dto);
    }

    @Override
    public ResponseData queryAccount(IRequest requestCtx, WechatEnterpriseApp dto) {
        ResponseData responseData = new ResponseData(false);
        if (dto.getId()==null){
            responseData.setMessage("app id can not be null");
            return responseData;
        }
        WechatEnterpriseApp app = wechatEnterpriseAppMapper.selectByPrimaryKey(dto);
        if (app == null){
            responseData.setMessage("target app can not be found.");
            return responseData;
        }
        WechatAccount account = wechatAccountMapper.selectByPrimaryKey(app.getAccountId());
        List<WechatAccount> accounts = new ArrayList<>();
        accounts.add(account);
        responseData.setRows(accounts);
        return responseData;
    }
}