package hls.support.core.wechat.service.impl;


import com.github.pagehelper.PageHelper;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import hls.support.core.wechat.dto.WechatAccount;
import hls.support.core.wechat.mapper.WechatAccountMapper;
import hls.support.core.wechat.mapper.WechatDepartmentMapper;

import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.cp.api.impl.WxCpServiceImpl;
import me.chanjar.weixin.cp.bean.WxCpDepart;
import me.chanjar.weixin.cp.config.WxCpInMemoryConfigStorage;
import org.apache.commons.collections4.CollectionUtils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import hls.support.core.wechat.dto.WechatDepartment;
import hls.support.core.wechat.service.IWechatDepartmentService;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

@Service
@Transactional(rollbackFor = Exception.class)
public class WechatDepartmentServiceImpl extends BaseServiceImpl<WechatDepartment> implements IWechatDepartmentService {


    private static Logger logger = LoggerFactory.getLogger(WechatDepartmentServiceImpl.class);
    @Autowired
    private WechatAccountMapper wechatAccountMapper;
    @Autowired
    private WechatDepartmentMapper wechatDepartmentMapper;

    @Override
    public ResponseData refresh(IRequest reusetContext, Long accountId) {
        ResponseData responseData = new ResponseData(false);
        if (accountId == null) {
            responseData.setMessage("invalid params");
            return responseData;
        }
        WechatAccount account = wechatAccountMapper.selectByPrimaryKey(accountId);
        if (account == null) {
            responseData.setMessage("could not found target wechat account");
            return responseData;
        }
        String corpId = account.getAppId();
        String secret = account.getSecret();
        WxCpInMemoryConfigStorage config = new WxCpInMemoryConfigStorage();
        config.setCorpId(corpId);
        config.setCorpSecret(secret);
        WxCpServiceImpl wxCpService = new WxCpServiceImpl();
        wxCpService.setWxCpConfigStorage(config);
        List<WxCpDepart> departList;
        try {
            departList = wxCpService.getDepartmentService().listAll();
        } catch (WxErrorException e) {
            logger.error("refresh departments data failed:", e);
            responseData.setMessage("refresh departments data failed.");
            return responseData;
        }
        WechatDepartment wechatDepartment = new WechatDepartment();

        /*删除已经没有的数据*/
        WechatDepartment w = new WechatDepartment();
        w.setAccountId(accountId);
        List<WechatDepartment> wechatDepartments = wechatDepartmentMapper.queryDepartment(w);
        List<Integer> departmentIds = new ArrayList<Integer>();
        /*建立已有部门id数组*/
        for (WxCpDepart depart : departList) {
            departmentIds.add(depart.getId());
        }
        /*如果数组中的id与查询到的通讯录不存在则删除*/
        for (WechatDepartment we : wechatDepartments
                ) {
            if (departmentIds.indexOf(we.getDepartmentId()) == -1) {
                self().deleteByPrimaryKey(we);
            }
        }


        /*更新或插入数据*/
        for (WxCpDepart depart : departList
                ) {
            wechatDepartment.setDepartmentId(depart.getId());
            wechatDepartment.setDepartmentName(depart.getName());
            wechatDepartment.setParentId(depart.getParentId());
            wechatDepartment.setDepartmentOrder(depart.getOrder());
            wechatDepartment.setAccountId(accountId);
            /*判断是否表内是否已存在该条记录*/
            if (CollectionUtils.isNotEmpty(wechatDepartmentMapper.queryDepartment(wechatDepartment))) {
                wechatDepartment.setId(wechatDepartmentMapper.queryDepartment(wechatDepartment).get(0).getId());
                wechatDepartmentMapper.updateByPrimaryKeySelective(wechatDepartment);
            } else {
                wechatDepartmentMapper.insertSelective(wechatDepartment);
            }
            responseData.setSuccess(true);
        }
        return responseData;
    }

    /**
     * 查询部门
     */
    @Override
    public List<WechatDepartment> queryDepartment(IRequest iRequest, WechatDepartment wechatDepartment, int page, int pageSize) {
        PageHelper.startPage(page, pageSize);
        return wechatDepartmentMapper.queryDepartment(wechatDepartment);
    }

    @Override
    public List<WechatDepartment> treeListDeapartmentQuery(IRequest iRequest, WechatDepartment wechatDepartment) {
        return wechatDepartmentMapper.treeListDeapartmentQuery(wechatDepartment);
    }

    /**
     * 新建部门
     */
    @Override
    public ResponseData addDepartment(IRequest iRequest, WechatDepartment wechatDepartment) {
        ResponseData responseData = new ResponseData(false);
        if (wechatDepartment.getAccountId() == null) {
            responseData.setMessage("invalid params");
            return responseData;
        }
        WechatAccount account = wechatAccountMapper.selectByPrimaryKey(wechatDepartment.getAccountId());
        if (account == null) {
            responseData.setMessage("target wechat account could not found");
            return responseData;
        }
        String corpId = account.getAppId();
        String secret = account.getSecret();
        WxCpInMemoryConfigStorage config = new WxCpInMemoryConfigStorage();
        config.setCorpId(corpId);
        config.setCorpSecret(secret);
        WxCpServiceImpl wxCpService = new WxCpServiceImpl();
        wxCpService.setWxCpConfigStorage(config);
        WxCpDepart depart = new WxCpDepart();
        depart.setParentId(wechatDepartment.getParentId());
        depart.setOrder(wechatDepartment.getDepartmentOrder());
        depart.setName(wechatDepartment.getDepartmentName());
        /*微信后台创建*/
        Integer departId;
        try {
            departId = wxCpService.getDepartmentService().create(depart);
        } catch (WxErrorException e) {
            logger.error("create department failed：", e);
            responseData.setMessage("create department failed.");
            return responseData;
        }
        /*数据库插入*/
        wechatDepartment.setDepartmentId(departId);
        wechatDepartmentMapper.insertSelective(wechatDepartment);

        return responseData;
    }

    /**
     * 更新部门
     */
    @Override
    public ResponseData updateDepartment(IRequest iRequest, WechatDepartment wechatDepartment) {
        ResponseData responseData = new ResponseData(false);
        if (wechatDepartment.getAccountId() == null) {
            responseData.setMessage("invalid params");
            return responseData;
        }
        WechatAccount account = wechatAccountMapper.selectByPrimaryKey(wechatDepartment.getAccountId());
        if (account == null) {
            responseData.setMessage("target wechat account could not found");
            return responseData;
        }

        String corpId = account.getAppId();
        String secret = account.getSecret();
        WxCpInMemoryConfigStorage config = new WxCpInMemoryConfigStorage();
        config.setCorpId(corpId);
        config.setCorpSecret(secret);
        WxCpServiceImpl wxCpService = new WxCpServiceImpl();
        wxCpService.setWxCpConfigStorage(config);
        WxCpDepart depart = new WxCpDepart();
        depart.setId(wechatDepartment.getDepartmentId());
        depart.setParentId(wechatDepartment.getParentId());
        depart.setOrder(wechatDepartment.getDepartmentOrder());
        depart.setName(wechatDepartment.getDepartmentName());
        /*微信服务器更新*/
        try {
            wxCpService.getDepartmentService().update(depart);
        } catch (WxErrorException e) {
            logger.error("update department failed：", e);
            responseData.setMessage("update department failed.");
        }
        /*数据库更新*/
        wechatDepartmentMapper.updateByPrimaryKeySelective(wechatDepartment);
        return responseData;
    }

    /**
     * 删除部门
     */
    @Override
    public ResponseData deleteDepartment(IRequest iRequest, WechatDepartment wechatDepartment) {
        ResponseData responseData = new ResponseData(false);
        if (wechatDepartment.getAccountId() == null) {
            responseData.setMessage("invalid params");
            return responseData;
        }
        WechatAccount account = wechatAccountMapper.selectByPrimaryKey(wechatDepartment.getAccountId());
        if (account == null) {
            responseData.setMessage("could not found target wechat account");
            return responseData;
        }

        String corpId = account.getAppId();
        String secret = account.getSecret();
        WxCpInMemoryConfigStorage config = new WxCpInMemoryConfigStorage();
        config.setCorpId(corpId);
        config.setCorpSecret(secret);
        WxCpServiceImpl wxCpService = new WxCpServiceImpl();
        wxCpService.setWxCpConfigStorage(config);
        /*微信服务器删除部门*/
        try {
            wxCpService.getDepartmentService().delete(wechatDepartment.getDepartmentId());
        } catch (WxErrorException e) {
            logger.error("delete department failed：", e);
            responseData.setMessage("delete department failed.");
        }
        /*数据库删除部门*/
        wechatDepartmentMapper.deleteByPrimaryKey(wechatDepartment);
        return responseData;
    }

    /**
     * 批量操作部门
     */
    @Override
    public ResponseData batchUpdateDepartment(IRequest iRequest, List<WechatDepartment> wechatDepartments) {
        ResponseData responseData = new ResponseData(false);
        int count = 0;
        for (WechatDepartment wechatDepartment : wechatDepartments
                ) {
            switch (wechatDepartment.get__status()) {
                case "add":
                    responseData = self().addDepartment(iRequest, wechatDepartment);
                    if (!responseData.isSuccess()) {
                        count++;
                    }
                    break;
                case "update":
                    responseData = self().updateDepartment(iRequest, wechatDepartment);
                    if (!responseData.isSuccess()) {
                        count++;
                    }
                    break;
                case "delete":
                    responseData = self().deleteDepartment(iRequest, wechatDepartment);
                    if (!responseData.isSuccess()) {
                        count++;
                    }
                    break;
                default:
                    logger.warn("_status is not set when batch update wechat department.");
                    break;
            }
        }
        if (count == 0) {
            responseData.setSuccess(true);
        }
        return responseData;
    }

    private void unitQueryDepartment(List<WechatDepartment> wechatDepartments, WechatDepartment wechatDepartment, List<Integer> departmentIds) {
        List<WechatDepartment> wechatDepartmentList = wechatDepartmentMapper.queryDepartment(wechatDepartment);
        if (wechatDepartmentList.size() > 0) {

            for (WechatDepartment wechatDepartment1 : wechatDepartmentList
                    ) {
                Integer parentid = wechatDepartment1.getDepartmentId();
                Long accountId = wechatDepartment1.getAccountId();
                WechatDepartment department = new WechatDepartment();
                department.setAccountId(accountId);
                department.setParentId(parentid);
                /*判断是否与已查询的部门重复*/
                if (departmentIds.indexOf(parentid) == -1) {
                    departmentIds.add(parentid);
                    wechatDepartments.addAll(wechatDepartmentMapper.queryDepartment(department));
                    unitQueryDepartment(wechatDepartments, department, departmentIds);
                }
            }
        }
    }
}