package hls.support.core.wechat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import hls.support.core.wechat.dto.WechatEnterpriseApp;
import hls.support.core.wechat.mapper.SubButtonMapper;
import hls.support.core.wechat.mapper.WechatEnterpriseAppMapper;
import hls.support.core.wechat.utils.WechatHttpUtils;
import hls.support.core.wechat.utils.WechatTokenUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import hls.support.core.wechat.dto.SubButton;
import hls.support.core.wechat.service.ISubButtonService;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

@Service
@Transactional(rollbackFor = Exception.class)
public class SubButtonServiceImpl extends BaseServiceImpl<SubButton> implements ISubButtonService {

    @Autowired
    private SubButtonMapper subButtonMapper;
    @Autowired
    private WechatEnterpriseAppMapper wechatEnterpriseAppMapper;
    private String qyMenuApi = "https://qyapi.weixin.qq.com/cgi-bin/menu/create?access_token={ACCESS_TOKEN}&agentid={AGENTID}";

    @Override
    public List<SubButton> queryAll(IRequest iRequest, SubButton subButton) {
        List<SubButton> subButtons = subButtonMapper.queryAll(subButton);
        for (SubButton sub : subButtons) {
            Long buttonId = sub.getButtonId();
            SubButton subB = new SubButton();
            subB.setParentId(buttonId);
            sub.setSub_button(subButtonMapper.queryAll(subB));
        }
        return subButtons;
    }

    @Override
    public List<SubButton> updateMenu(IRequest iRequest, List<SubButton> subButtons) {
        uniUpdateMenu(iRequest, subButtons);
        return subButtons;
    }

    @Override
    public void deleteMenu(IRequest iRequest, SubButton subButton) {
        subButtonMapper.deleteMenu(subButton);
    }

    @Override
    public ResponseData pushMenu(Long wechatId) {
        ResponseData responseData = new ResponseData(false);
        if (wechatId == null) {
            responseData.setMessage("invalid params");
            return responseData;
        }
        WechatEnterpriseApp wechatEnterpriseApp = wechatEnterpriseAppMapper.selectByPrimaryKey(wechatId);
        if (wechatEnterpriseApp == null) {
            responseData.setMessage("could not found target wechat account");
            return responseData;
        }
        String corpId = wechatEnterpriseApp.getCorpId();
        String secret = wechatEnterpriseApp.getSecret();
        String agentId = wechatEnterpriseApp.getAgentId();

        SubButton subButton = new SubButton();
        subButton.setWechatId(wechatId);
        Map<String, Object> menus = getMap(subButton);
        JSONObject token = WechatTokenUtils.getToken(corpId, secret, WechatTokenUtils.Type_CORP_ID);
        if (!token.containsKey("access_token")) {
            responseData.setMessage("could not get access token");
            return responseData;
        }
        String accessToken = token.getString("access_token");
        String url = StringUtils.replace(StringUtils.replace(qyMenuApi, "{ACCESS_TOKEN}", accessToken), "{AGENTID}", agentId);

        JSONObject jsonObject = WechatHttpUtils.postForJson(url, menus);
        if (Objects.equals(0L, jsonObject.get("errcode"))) {
            responseData.setSuccess(true);
        }
        return responseData;
    }

    private Map<String, Object> getMap(SubButton subButton) {
        List<SubButton> subButtons = queryAll(null, subButton);
        Map<String, Object> params = new HashMap<String, Object>();
        List<Map<String, Object>> button = new ArrayList<Map<String, Object>>();
        for (SubButton subB : subButtons
                ) {
            Map<String, Object> buttonMap = new HashMap<String, Object>();

            buttonMap.put("name", subB.getName());
            List<Map<String, Object>> subButtonList = new ArrayList<Map<String, Object>>();
            if (subB.getSub_button().size() > 0) {
                for (SubButton sub : subB.getSub_button()
                        ) {
                    Map<String, Object> subButtonMap = new HashMap<String, Object>();
                    subButtonMap.put("name", sub.getName());
                    subButtonMap.put("type", sub.getButtonType());
                    if ("click".equals(sub.getButtonType())) {
                        subButtonMap.put("key", sub.getUrl());
                    } else if ("view".equals(sub.getButtonType())) {
                        subButtonMap.put("url", sub.getUrl());
                    }
                    subButtonMap.put("sub_button", new ArrayList<Map<String, Object>>());
                    subButtonList.add(subButtonMap);
                }

            } else {
                buttonMap.put("type", subB.getButtonType());
                if ("click".equals(subB.getButtonType())) {
                    buttonMap.put("key", subB.getUrl());
                } else if ("view".equals(subB.getButtonType())) {
                    buttonMap.put("url", subB.getUrl());
                }
            }
            buttonMap.put("sub_button", subButtonList);
            button.add(buttonMap);
        }
        params.put("button", button);
        return params;
    }

    private void uniUpdateMenu(IRequest iRequest, List<SubButton> subButtons) {
        for (SubButton subButton : subButtons
                ) {
            if (subButton.getDeleteId() != null && subButton.getDeleteId().length > 0) {
                subButtonMapper.deleteMenu(subButton);
            }
            if (subButton.getButtonId() != null) {
                self().updateByPrimaryKeySelective(iRequest, subButton);
            } else {
                self().insertSelective(iRequest, subButton);
            }
            if (subButton.getSub_button() != null && subButton.getSub_button().size() > 0 && subButton.getParentId() == null && (subButton.getButtonType() == null || subButton.getButtonType() == "") && subButton.getUrl() == null || subButton.getUrl() == "") {
                List<SubButton> subButtonList = subButton.getSub_button();
                for (SubButton subB : subButtonList
                        ) {
                    subB.setParentId(subButton.getButtonId());
                }
                uniUpdateMenu(iRequest, subButtonList);
            }
        }
    }

}