package hls.support.core.wechat.service.impl;

import com.alibaba.fastjson.JSON;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import com.hand.hap.mybatis.entity.Example;
import com.hand.hap.mybatis.util.StringUtil;
import hls.support.core.wechat.dto.WechatAccount;
import hls.support.core.wechat.dto.WechatEnterpriseApp;
import hls.support.core.wechat.formbean.AttachmentInfo;
import hls.support.core.wechat.mapper.WechatAccountMapper;
import hls.support.core.wechat.mapper.WechatEnterpriseAppMapper;
import hls.support.core.wechat.service.IMediaService;
import hls.support.core.wechat.utils.WeChatUtils;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.mp.api.WxMpService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.CharsetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.*;

/**
 * Created with IntelliJ IDEA.
 * User: yang
 * Date: 2018/1/16
 * Time: 17:52
 */
@Service
public class MediaServiceImpl implements IMediaService {
    private static final String ERROR_ACCOUNT_NOT_FOUND = "ERROR_ACCOUNT_NOT_FOUND";
    private static final String ERROR_CONTRACT_CODE_EMPTY = "ERROR_CONTRACT_CODE_EMPTY";
    private static final String ERROR_ACCOUNT_NOT_SPECIFIED = "ERROR_ACCOUNT_NOT_SPECIFIED";
    public static final String STATUS_OK = "OK";
    private static final String ERROR_MEDIA_DOWNLOAD_FAILED = "ERROR_MEDIA_DOWNLOAD_FAILED";
    private static final String ERROR_ACCOUNT_TYPE = "ERROR_ACCOUNT_TYPE";
    private static final String ERROR_MEDIA_NOT_DOWNLOAD = "ERROR_MEDIA_NOT_DOWNLOAD";
    private static final String ERROR_MEDIA_NOT_UPLOAD = "ERROR_MEDIA_NOT_UPLOAD";
    private static final String ERROR_QUERY_TIME_EMPTY = "ERROR_QUERY_TIME_EMPTY";
    private static final String RESULT_ERROR = "-1";

    @Autowired
    private WechatEnterpriseAppMapper appMapper;
    @Autowired
    private WechatAccountMapper accountMapper;

    private Logger logger = LoggerFactory.getLogger(getClass());

    @Value("#{configProperties['http.proxy.port']}")
    private Integer proxyPort;

    @Value("#{configProperties['http.proxy.host']}")
    private String proxyHost;

    private CloseableHttpClient httpClient;
    @Autowired
    IHapInterfaceHeaderService headerService;

    public MediaServiceImpl() {
        // ensure e-sign SDK will be init only once
        RequestConfig config = RequestConfig.custom().setConnectTimeout(60 * 1000).setSocketTimeout(15000).build();
        httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    @Override
    public AttachmentInfo saveMedia2Business(AttachmentInfo attchInfo) {
        logger.debug("wechatCode:{}, mediaId:{}, sourceType:{}, pkValue:{}, fileName:{}, userId:{},uploadApiName:{},uploadSysName:{}",
                attchInfo.getWechatCode(), attchInfo.getMediaId(),
                attchInfo.getSourceType(), attchInfo.getPkValue(),
                attchInfo.getFileName(), attchInfo.getUserId(), attchInfo.getUploadApiName(), attchInfo.getUploadSysName());
        if (StringUtil.isNotEmpty(attchInfo.getWechatCode())) {
            Example example = new Example(WechatEnterpriseApp.class);
            Example.Criteria criteria = example.createCriteria();
            logger.debug("**********WechatCode:[" + attchInfo.getWechatCode() + "]**********");
            criteria.andEqualTo("wxCode", attchInfo.getWechatCode());
            List<WechatEnterpriseApp> wechatEnterpriseApps = appMapper.selectByExample(example);
            if (CollectionUtils.isEmpty(wechatEnterpriseApps)) {
                attchInfo.setSuccess("false");
                attchInfo.setMessage(ERROR_ACCOUNT_NOT_FOUND);
            } else if (wechatEnterpriseApps.size() > 1) {
                attchInfo.setSuccess("false");
                attchInfo.setMessage(ERROR_ACCOUNT_NOT_SPECIFIED);
            }
            WechatEnterpriseApp app = wechatEnterpriseApps.get(0);
            WechatAccount account = accountMapper.selectByPrimaryKey(app.getAccountId());
            if (account == null) {
                attchInfo.setSuccess("false");
                attchInfo.setMessage(ERROR_ACCOUNT_NOT_FOUND);
            }
            File download;
            String attchmentId = "";
            if (account.getAccountType().equals(WechatAccount.CORP)) {
                WxCpService wxCpService = WeChatUtils.initWxCpService(app.getCorpId(), app.getSecret(), Integer.valueOf(app.getAgentId()), proxyHost, proxyPort);
                try {
                    download = wxCpService.getMediaService().download(attchInfo.getMediaId());
                    attchmentId = uploadFile(download, attchInfo);
                    if (StringUtil.isNotEmpty(attchmentId)) {
                        attchInfo.setAttachmentId(attchmentId);
                        attchInfo.setSuccess("true");
                        attchInfo.setMessage("文件上传成功");
                    }
                } catch (WxErrorException e) {
                    attchInfo.setSuccess("false");
                    attchInfo.setMessage(ERROR_MEDIA_NOT_DOWNLOAD);
                }
            } else if (account.getAccountType().equals(WechatAccount.SERV) || account.getAccountType().equals(WechatAccount.SUBS)) {
                WxMpService wxMpService = WeChatUtils.initWxMpService(account.getAppId(), account.getSecret(), proxyHost, proxyPort);
                try {
                    download = wxMpService.getMaterialService().mediaDownload(attchInfo.getMediaId());
                    attchmentId = uploadFile(download, attchInfo);
                    if (StringUtil.isNotEmpty(attchmentId)) {
                        attchInfo.setAttachmentId(attchmentId);
                        attchInfo.setSuccess("true");
                        attchInfo.setMessage("文件上传成功");
                    }
                } catch (WxErrorException e) {
                    attchInfo.setSuccess("false");
                    attchInfo.setMessage(ERROR_MEDIA_NOT_DOWNLOAD);
                }
            }else{
                attchInfo.setSuccess("false");
                attchInfo.setMessage(ERROR_ACCOUNT_TYPE);
            }

        }
        return attchInfo;
    }

    private String uploadFile(File file, AttachmentInfo info) {
        //todo upload file
        String apiName = info.getUploadApiName();
        String sysName = info.getUploadSysName();
        HapInterfaceHeader headerAndLineDTO = headerService.getHeaderAndLine(sysName, apiName);
        if (headerAndLineDTO == null) {
            logger.debug("headerAndLineDTO is null， apiName:{}, sysName:{}", apiName, sysName);
            return null;
        }
        String url = headerAndLineDTO.getDomainUrl() + headerAndLineDTO.getIftUrl();
        logger.debug("upload url: {}", url);
        HttpPost httpPost = new HttpPost(url);

        //prepare params
        StringBody pkValue = new StringBody(info.getPkValue(), ContentType.MULTIPART_FORM_DATA);
        StringBody userId = new StringBody(info.getUserId(), ContentType.MULTIPART_FORM_DATA);
        StringBody sourceType = new StringBody(info.getSourceType(), ContentType.MULTIPART_FORM_DATA);
        ContentType imgType = ContentType.create("image/jpeg", Consts.UTF_8);
        try {
            HttpEntity entity = MultipartEntityBuilder.create()
                    .setMode(HttpMultipartMode.BROWSER_COMPATIBLE)
                    .addPart("pkvalue", pkValue)
                    .addPart("user_id", userId)
                    .addPart("source_type", sourceType)
                    .addBinaryBody("file", file, imgType, info.getFileName())
                    .setCharset(CharsetUtils.get("utf-8"))
                    .build();
            httpPost.setEntity(entity);
            CloseableHttpResponse response = httpClient.execute(httpPost);
            InputStream content = response.getEntity().getContent();
            String result = IOUtils.toString(content);
            if (StringUtils.equals(RESULT_ERROR, result)) {
                return null;
            }
            return result;
        } catch (IOException e) {
            logger.error("upload attachment failed, attachmentInfo:{}", JSON.toJSONString(info), e);
        }
        return null;
    }
}
