package hls.support.core.wechat.service.impl;

import com.hand.hap.mybatis.entity.Example;
import hls.support.core.wechat.dto.WechatAccount;
import hls.support.core.wechat.dto.WechatEnterpriseApp;
import hls.support.core.wechat.mapper.WechatAccountMapper;
import hls.support.core.wechat.mapper.WechatEnterpriseAppMapper;
import hls.support.core.wechat.service.IJSSDKService;
import hls.support.core.wechat.utils.HttpRequestUtil;
import hls.support.core.wechat.utils.WeChatUtils;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.mp.api.WxMpService;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * Created by weck on 18/01/2018 3:39 PM
 */
@Service
public class JSSDKServiceImpl implements IJSSDKService {

    private static Logger logger = LoggerFactory.getLogger(JSSDKServiceImpl.class);
    @Autowired
    private WechatEnterpriseAppMapper appMapper;
    @Autowired
    private WechatAccountMapper accountMapper;
    private String ENCRYPT_TYPE = "utf-8";

    @Value("#{configProperties['http.proxy.port']}")
    private Integer proxyPort;

    @Value("#{configProperties['http.proxy.host']}")
    private String proxyHost;

    @Override
    public Map<String, Object> getWxConfig(String wxCode, String clientUrl, HttpServletRequest request) {
        Map<String, Object> map = new HashMap<>();
        map.put("success", false);
        if (StringUtils.isEmpty(wxCode)) {
            map.put("errMsg", "wxCode can not be empty.");
            return map;
        }
        Example example = new Example(WechatEnterpriseApp.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("wxCode", wxCode);
        List<WechatEnterpriseApp> wechatEnterpriseApps = appMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(wechatEnterpriseApps)) {
            //not found target account by code
            map.put("errMsg", "account can not be found.");
            return map;
        } else if (wechatEnterpriseApps.size() > 1) {
            map.put("errMsg", "account is not specified.");
            return map;
        }
        try {
            clientUrl = URLDecoder.decode(clientUrl, ENCRYPT_TYPE);
        } catch (UnsupportedEncodingException e) {
            logger.error("url decoded failed.", e);
            map.put("errMsg", "url decoded failed," + e.getMessage());
        }
        WechatEnterpriseApp app = wechatEnterpriseApps.get(0);
        WechatAccount account = accountMapper.selectByPrimaryKey(app.getAccountId());
        if (account == null) {
            map.put("errMsg", "internal data error.");
            return map;
        }
//        String requestUrl = StringUtils.split(request.getRemoteHost(),"#")[0];
        String timestamp = Long.toString(System.currentTimeMillis() / 1000);
        String nonceStr = UUID.randomUUID().toString();
//        String accessToken = "";
        String appId = account.getAppId();
        Integer type = account.getAccountType();
        String ticket;
        if (type.equals(WechatAccount.CORP)) {
            WxCpService wxCpService = WeChatUtils.initWxCpService(appId, app.getSecret(), Integer.valueOf(app.getAgentId()), proxyHost, proxyPort);
            try {
//                accessToken = wxCpService.getAccessToken();
                ticket = wxCpService.getJsapiTicket();
            } catch (WxErrorException e) {
                logger.error("get ticket failed.", e);
                map.put("errMsg", "get ticket failed." + e.getMessage());
                return map;
            }
        } else if (type.equals(WechatAccount.SERV) || type.equals(WechatAccount.SUBS)) {
            WxMpService wxMpService = WeChatUtils.initWxMpService(appId, account.getSecret(), proxyHost, proxyPort);
            try {
                ticket = wxMpService.getJsapiTicket();
            } catch (WxErrorException e) {
                logger.error("get ticket failed.", e);
                map.put("errMsg", "get ticket failed," + e.getMessage());
                return map;
            }
        } else {
            map.put("errMsg", "internal data error");
            return map;
        }
//        String getTicketUrl = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?type=jsapi&access_token=";
//        JSONObject res = HttpRequestUtil.httpRequest(getTicketUrl +accessToken,"GET",null);
//        if (res == null){
//            map.put("errMsg","get ticket failed.");
//            return map;
//        }
//        String ticket = res.getString("ticket");
        String signature = "";
        String string1 = "jsapi_ticket=" + ticket +
                "&noncestr=" + nonceStr +
                "&timestamp=" + timestamp +
                "&url=" + clientUrl;

        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(string1.getBytes("UTF-8"));
            signature = WeChatUtils.byteToHex(crypt.digest());
        } catch (NoSuchAlgorithmException | UnsupportedEncodingException e) {
            logger.error("sign a signature failed.", e);
            map.put("errMsg", "sign a signature failed.");
        }
        map.put("success", true);
        map.put("appId", appId);
        map.put("timestamp", timestamp);
        map.put("jsapi_ticket", ticket);
        map.put("nonceStr", nonceStr);
        map.put("signature", signature);
        map.put("clientUrl", clientUrl);
        return map;
    }
}
