package hls.support.core.wechat.service.impl;

import com.hand.hap.core.IRequest;
import hls.support.core.responseMessage.service.IResponseMessageService;
import hls.support.core.wechat.components.DemoInterceptor;
import hls.support.core.wechat.components.MessageHandler;
import hls.support.core.wechat.components.MessageMatcher;
import hls.support.core.wechat.dto.AutoRecover;
import hls.support.core.wechat.dto.WechatAccount;
import hls.support.core.wechat.dto.WechatEnterpriseApp;
import hls.support.core.wechat.mapper.AutoRecoverMapper;
import hls.support.core.wechat.mapper.WechatAccountMapper;
import hls.support.core.wechat.mapper.WechatEnterpriseAppMapper;
import hls.support.core.wechat.service.IAcceptWechatService;
import hls.support.core.wechat.utils.WeChatUtils;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpMessageRouter;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.kefu.WxMpKefuMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.regex.Pattern;


/**
 * Created by weck on 05/02/2018 11:24 AM
 */
@Service
public class AcceptWechatServiceImpl implements IAcceptWechatService {

    private static Logger logger = LoggerFactory.getLogger(AcceptWechatServiceImpl.class);

    @Autowired
    private WechatEnterpriseAppMapper appMapper;

    @Autowired
    private AutoRecoverMapper mapper;

    @Autowired
    private WechatAccountMapper accountMapper;

    @Autowired
    private IResponseMessageService responseMessageService;

    @Value("#{configProperties['http.proxy.port']}")
    private Integer proxyPort;

    @Value("#{configProperties['http.proxy.host']}")
    private String proxyHost;

    private String targetStr = "";

    private static int THE_FIRST_PICK = 0;

    @Override
    public void filterSubscribe(HttpServletRequest request, HttpServletResponse response, IRequest iRequest) {
        WxMpXmlMessage inMessage;
        try {
            inMessage = WxMpXmlMessage.fromXml(request.getInputStream());
        } catch (Throwable t) {
            logger.error("get xml message failed.", t);
            return;
        }

        // 返回消息给微信服务器
        PrintWriter out = null;
        try {
            out = response.getWriter();
        } catch (IOException e) {
            e.printStackTrace();
        }
        String encrypt_type = request.getParameter("encrypt_type");
        logger.debug("********************************encrypt_type:"+encrypt_type+"************************************");
        String toUserName = inMessage.getToUser();
        String fromUserName = inMessage.getFromUser();
        String msgType = inMessage.getMsgType();
        String event = inMessage.getEvent();

        logger.debug("received message. toUserName is {}, fromUserName is {}, msgType is, event is {}", toUserName, fromUserName, msgType, event);
        //开始订阅事件
        if (msgType.equals("event") && event.equals("subscribe")) {
            WechatEnterpriseApp wea = new WechatEnterpriseApp();
            wea.setWechatId(toUserName);
            List<WechatEnterpriseApp> apps = appMapper.select(wea);
            if (apps == null || apps.size() != 1) {
                logger.error("query data for wechatId error.");
                return;
            }
            WechatEnterpriseApp targetApp = apps.get(0);
            String content = responseMessageService.messageContent(iRequest, targetApp.getId());
            if (StringUtils.isEmpty(content)) {
                logger.error("the result of query response content is null.");
                return;
            }
            WechatAccount targetAccount = accountMapper.selectByPrimaryKey(targetApp.getAccountId());
            if (targetAccount == null) {
                logger.error("query data for accountId error.");
                return;
            }
            WxMpService wxMpService = WeChatUtils.initWxMpService(targetAccount.getAppId(), targetAccount.getSecret(), proxyHost, proxyPort);

            WxMpKefuMessage m = WxMpKefuMessage
                    .TEXT()
                    .content(content)
                    .toUser(fromUserName)
                    .build();
            try {
                wxMpService.getKefuService().sendKefuMessage(m);

            } catch (WxErrorException e) {
                logger.error("send message custom failed.", e);
            }
        }
        if (encrypt_type != null && "aes".equals(encrypt_type)) {
            WechatEnterpriseApp wea = new WechatEnterpriseApp();
            wea.setWechatId(toUserName);
            List<WechatEnterpriseApp> apps = appMapper.select(wea);
            WechatEnterpriseApp targetApp = apps.get(0);
            WechatAccount targetAccount = accountMapper.selectByPrimaryKey(targetApp.getAccountId());
            try {
                WxMpService wxMpService = WeChatUtils.initWxMpService(targetAccount.getAppId(), targetAccount.getSecret(), proxyHost, proxyPort);
                //定义规则
                WxMpMessageRouter wxMpMessageRouter = new WxMpMessageRouter(wxMpService);
                wxMpMessageRouter.rule()
                        .matcher(new MessageMatcher())
                        .interceptor(new DemoInterceptor())
                        .handler(new MessageHandler())
                        .end();
                // 把消息传递给路由器进行处理
                WxMpXmlOutMessage xmlOutMsg = wxMpMessageRouter.route(inMessage);
                if (xmlOutMsg != null) {
                    out.print(xmlOutMsg.toXml());
                }
                List<AutoRecover> messages = mapper.queryAll();
                for (AutoRecover message : messages) {
                    if (Pattern.matches(".*" + message.getContent() + ".*", inMessage.getContent())) {
                        targetStr = message.getContent();
                        break;
                    }
                }
                kf(fromUserName,wxMpService);
            } finally {
                out.close();
            }
        } else {
            WechatEnterpriseApp wea = new WechatEnterpriseApp();
            wea.setWechatId(toUserName);
            List<WechatEnterpriseApp> apps = appMapper.select(wea);
            WechatEnterpriseApp targetApp = apps.get(0);
            WechatAccount targetAccount = accountMapper.selectByPrimaryKey(targetApp.getAccountId());
            try {
                WxMpService wxMpService = WeChatUtils.initWxMpService(targetAccount.getAppId(), targetAccount.getSecret(), proxyHost, proxyPort);
                out.print(WxMpXmlOutMessage.TRANSFER_CUSTOMER_SERVICE().fromUser(toUserName).toUser(fromUserName).build().toXml());
                //定义规则
                /*WxMpMessageRouter wxMpMessageRouter = new WxMpMessageRouter(wxMpService);
                wxMpMessageRouter.rule()
                        .matcher(new MessageMatcher())
                        .interceptor(new DemoInterceptor())
                        .handler(new MessageHandler())
                        .end();
                // 把消息传递给路由器进行处理
                WxMpXmlOutMessage xmlOutMsg = wxMpMessageRouter.route(inMessage);
                if (xmlOutMsg != null) {
                    out.print(xmlOutMsg.toXml());
                }*/
                //匹配关键字回复
                /*List<AutoRecover> messages = mapper.queryAll();
                targetStr = "";
                for (AutoRecover message : messages) {
                    if (Pattern.matches(".*" + message.getContent() + ".*", inMessage.getContent())) {
                        targetStr = message.getContent();
                        break;
                    }
                }
                if(targetStr.equals("客服")){
                    //转发到客服
                    kf(fromUserName,wxMpService);
                    out.print(WxMpXmlOutMessage.TRANSFER_CUSTOMER_SERVICE().fromUser(toUserName).toUser(fromUserName).build().toXml());
                }
                else if(!targetStr.equals("")){
                    //发送指定消息
                    kf(fromUserName,wxMpService);
                }
                else{
                    //发送输入客服获取更多帮助
                    targetStr = "人工";
                    kf(fromUserName,wxMpService);
                }*/
            } finally {
                out.close();
            }
        }
    }
    public void kf(String fromUserName,WxMpService wxMpService){
        wxMpService.getWxMpConfigStorage();
        AutoRecover autoRecover = new AutoRecover();
        autoRecover.setContent(targetStr);
        String reContent = mapper.selectSeq(autoRecover).get(THE_FIRST_PICK).getReContent();
        if (StringUtils.isEmpty(mapper.selectSeq(autoRecover).get(THE_FIRST_PICK).getPicUrl())) {
            WxMpKefuMessage m = WxMpKefuMessage
                    .TEXT()
                    .content(reContent)
                    .toUser(fromUserName)
                    .build();
            try {
                wxMpService.getKefuService().sendKefuMessage(m);
            } catch (WxErrorException e) {
                logger.error("send message custom failed.", e);
            }
        } else {
            WxMpKefuMessage.WxArticle article = new WxMpKefuMessage.WxArticle();
            article.setUrl("URL");
            article.setPicUrl(mapper.selectSeq(autoRecover).get(THE_FIRST_PICK).getPicUrl());
            article.setDescription(mapper.selectSeq(autoRecover).get(THE_FIRST_PICK).getDescription());
            article.setTitle(mapper.selectSeq(autoRecover).get(THE_FIRST_PICK).getTitle());

            WxMpKefuMessage m = WxMpKefuMessage
                    .NEWS()
                    .addArticle(article)
                    .toUser(fromUserName)
                    .build();
            try {
                wxMpService.getKefuService().sendKefuMessage(m);
            } catch (WxErrorException e) {
                logger.error("send message custom failed.", e);
            }
        }
    }
}
