package hls.support.core.wechat.controllers;

import hls.support.core.wechat.dto.WechatMember;
import org.springframework.stereotype.Controller;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.wechat.dto.WechatTag;
import hls.support.core.wechat.service.IWechatTagService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

import org.springframework.validation.BindingResult;

import java.util.List;

@Controller
public class WechatTagController extends BaseController {

    @Autowired
    private IWechatTagService service;


    @RequestMapping(value = "/wechat/tag/query")
    @ResponseBody
    public ResponseData query(WechatTag dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                              @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(service.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value = "/wechat/tag/refresh")
    @ResponseBody
    public ResponseData refresh(HttpServletRequest request, Long accountId) {
        IRequest reusetContext = createRequestContext(request);
        return service.refreshTag(reusetContext, accountId);
    }

    @RequestMapping(value = "/wechat/tag/submit")
    @ResponseBody
    public ResponseData update(@RequestBody List<WechatTag> dto, BindingResult result, HttpServletRequest request) {
        getValidator().validate(dto, result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(getErrorMessage(result, request));
            return responseData;
        }
        IRequest requestCtx = createRequestContext(request);
        return new ResponseData(service.batchUpdateTag(requestCtx, dto));
    }

    @RequestMapping(value = "/wechat/tag/remove")
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<WechatTag> dto) {
        service.batchDelete(dto);
        return new ResponseData();
    }

    /**
     * 查询标签列表
     */
    @RequestMapping(value = "/wechat/tag/queryTag")
    @ResponseBody
    public ResponseData queryTag(HttpServletRequest request, WechatTag dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                                 @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(service.queryTag(requestContext, dto, page, pageSize));
    }

    /**
     * 添加用户到标签
     */
    @RequestMapping(value = "/wechat/tag/addUsers")
    @ResponseBody
    public ResponseData addTagUser(WechatTag tag, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(service.addTagUsers(requestContext, tag));
    }

    /**
     * 从标签中移除用户
     */
    @RequestMapping(value = "/wechat/tag/removeUsers")
    @ResponseBody
    public ResponseData removeTagUsers(WechatTag tag, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(service.removeTagUsers(requestContext, tag));
    }

}