package hls.support.core.wechat.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.wechat.dto.WechatEnterpriseApp;
import hls.support.core.wechat.service.ISystemFileService;
import hls.support.core.wechat.service.IWechatEnterpriseAppService;
import hls.support.core.wechat.utils.WechatSendMsgUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: Jeffery
 * Date: 2017/12/21
 * Time: 20:27
 * To change this template use File | Settings | File Templates.
 */
@Controller
@RequestMapping("/send/wechat")
public class WechatSendNoticeController extends BaseController {

    @Autowired
    private IWechatEnterpriseAppService wechatEnterpriseAppService;
    @Autowired
    private ISystemFileService systemFileService;

    @RequestMapping("/msg/notice")
    public ResponseData queryAccountsDelete(final WechatEnterpriseApp pageDto, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        WechatEnterpriseApp queryDto = wechatEnterpriseAppService.selectByPrimaryKey(requestContext, pageDto);
        Map<String, String> map = null;
        if (pageDto.getMediaId() != null) {
            map = systemFileService.queryFilePath(pageDto.getMediaId());
        }
        if (map != null && map.size() > 0 && map.get("FILE_PATH") != null) {
            pageDto.setMediaUrl(map.get("FILE_PATH"));
        }
        return new ResponseData(WechatSendMsgUtil.Send_msg("Jeffery", "", "1", queryDto, pageDto));
    }

}
