package hls.support.core.wechat.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.wechat.formbean.WxMessageBean;
import hls.support.core.wechat.formbean.TemplateMessage;
import hls.support.core.wechat.service.IWechatMessageService;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.util.List;
import java.util.Map;

/**
 * Created by weck on 06/01/2018 10:16 AM
 */

@Controller
@RequestMapping(value = {"/r/api", "/"})
public class WechatMessageController extends BaseController {

    @Autowired
    IWechatMessageService service;

    @Value("#{configProperties['file.upload.dir']}")
    private String uploadDir;

    private static Logger logger = LoggerFactory.getLogger(WechatMessageController.class);

    /**
     * 发送客服消息
     *
     * @param messageBean 消息实体
     * @param request     请求体
     * @return responsedata
     */
    @RequestMapping("/wechat/kefuMessage/send")
    @ResponseBody
    public ResponseData sendKefuMessage(@RequestBody WxMessageBean messageBean, HttpServletRequest request) {
        IRequest requestCtx = createRequestContext(request);
        return service.sendKefuMessage(requestCtx, messageBean);
    }

    @RequestMapping("/wechat/templateMsg/getAllTemplate")
    @ResponseBody
    public ResponseData getAllTemplate(@RequestBody TemplateMessage templateMessage, HttpServletRequest request) {
        IRequest requestCtx = createRequestContext(request);
        return service.getAllTemplate(requestCtx, templateMessage);
    }

    @RequestMapping("/wechat/templateMsg/delTemplate")
    @ResponseBody
    public ResponseData deleteTemplate(@RequestBody TemplateMessage templateMessage, HttpServletRequest request) {
        IRequest requestCtx = createRequestContext(request);
        return service.delTemplate(requestCtx, templateMessage);
    }

    @RequestMapping("/wechat/templateMsg/getIndustry")
    @ResponseBody
    public ResponseData getIndustry(@RequestBody TemplateMessage templateMessage, HttpServletRequest request) {
        IRequest requestCtx = createRequestContext(request);
        return service.getIndustry(requestCtx, templateMessage);
    }


    @RequestMapping("/wechat/templateMsg/setIndustry")
    @ResponseBody
    public ResponseData setIndustry(@RequestBody TemplateMessage templateMessage, HttpServletRequest request) {
        IRequest requestCtx = createRequestContext(request);
        return service.setIndustry(requestCtx, templateMessage);
    }

    @RequestMapping("/wechat/templateMsg/addTemplate")
    @ResponseBody
    public ResponseData addTemplate(@RequestBody TemplateMessage templateMessage, HttpServletRequest request) {
        IRequest requestCtx = createRequestContext(request);
        return service.addTemplate(requestCtx, templateMessage);
    }

    @RequestMapping("/wechat/templateMsg/send")
    @ResponseBody
    public ResponseData sendTemplateMsg(@RequestBody TemplateMessage templateMessage,@RequestParam("accountId") String accountId,HttpServletRequest request) {
        IRequest requestCtx = createRequestContext(request);
        templateMessage.setAccountId(Long.parseLong(accountId));
        return service.sendTemplateMsg(requestCtx, templateMessage);
    }

    /**
     * 发送图文消息
     */
    @RequestMapping("/wechat/message/send/MPNews")
    @ResponseBody
    public ResponseData sendMPNews(@RequestBody WxMessageBean messageBean, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return service.sendMPNews(requestContext, messageBean);
    }

    /**
     * 发送文本消息
     */
    @RequestMapping("/wechat/message/send/text")
    @ResponseBody
    public ResponseData sendText(@RequestBody WxMessageBean messageBean, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return service.sendText(requestContext, messageBean);
    }

    /**
     * 发送图片消息
     */
    @RequestMapping("/wechat/message/send/image")
    @ResponseBody
    public ResponseData sendImage(@RequestBody WxMessageBean messageBean, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return service.sendImage(requestContext, messageBean);
    }

    /**
     * 上传非企业号图文缩略图
     */
    @RequestMapping("/wechat/message/upload/thumbPicture")
    @ResponseBody
    public JSONObject uploadThumbPicture(@RequestParam("file") MultipartFile image,
                                         @RequestParam("accountId") Long accountId,
                                         HttpServletRequest request) {
        if (image.isEmpty()) {
            return null;
        }
        IRequest requestCtx = createRequestContext(request);
        return service.uploadThumbPicture(requestCtx, image, accountId);
    }

    /**
     * 上传图片
     */
    @RequestMapping("/wechat/message/upload/picture")
    @ResponseBody
    public String uploadPicture(@RequestParam("file") MultipartFile image, HttpServletRequest request) {
        if (image.isEmpty()) {
            return null;
        }
        IRequest requestCtx = createRequestContext(request);
        return service.uploadPicture(requestCtx, image);
    }

    /**
     * 文件下载、图片预览
     */
    @RequestMapping("/wechat/message/download")
    public void downloadFile(String fileName, HttpServletResponse response) {
        if (StringUtils.isNotEmpty(fileName)) {
            String realPath = uploadDir + fileName;
            File file = new File(realPath);
            if (file.exists()) {
                response.setContentType("application/octet-stream");
                response.addHeader("Content-Disposition",
                        "attachment;fileName=" + fileName);// 设置文件名
                response.setContentLength((int)(FileUtils.sizeOf(file)));
                FileInputStream is = null;
                OutputStream os = null;
                try {
                    is = new FileInputStream(file);
                    os = response.getOutputStream();
                    IOUtils.copy(is,os);
                } catch (Exception e) {
                    logger.error("io transformation failed when download file.",e);
                } finally {
                    IOUtils.closeQuietly(is);
                    IOUtils.closeQuietly(os);
                }
            }
            else {
                response.setStatus(HttpStatus.SC_NO_CONTENT);
            }
        }else {
            response.setStatus(HttpStatus.SC_NO_CONTENT);
        }
    }

    /*
     * 多公众号发送消息
     * */

    @RequestMapping("/r/api/wechat/message/sendMass")
    @ResponseBody
    public ResponseData sendMass(HttpServletRequest request,
                                 @RequestBody Map<String, Object> map) {
        String content = (String) map.get("content");
        IRequest iRequest = createRequestContext(request);
        if (!map.containsKey("receivers")) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage("未包含参数receivers.");
            return responseData;
        }
        List<Map<String, String>> list = (List<Map<String, String>>) map.get("receivers");
        for (Map<String, String> map1 : list) {
            WxMessageBean messageBean = new WxMessageBean();
            messageBean.setWxCode(map1.get("wxCode"));
            messageBean.setTagId(map1.get("tagId"));
            messageBean.setTagIds(map1.get("corpTagIds"));
            messageBean.setUserIds(map1.get("userIds"));
            messageBean.setOpenIds(map1.get("openIds"));
            messageBean.setText(content);
            ResponseData responseData = service.sendText(iRequest, messageBean);
            if (!responseData.isSuccess()) {
                return responseData;
            }
        }
        return new ResponseData();
    }
}
