package hls.support.core.wechat.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.wechat.dto.WechatMenu;
import hls.support.core.wechat.service.IWechatMenuService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@RestController
@RequestMapping("/wechat/menu")
public class WechatMenuController extends BaseController {
    @Autowired
    private IWechatMenuService service;

    /**
     * 菜单增删改
     */
    @RequestMapping("/submit")
    @ResponseBody
    public ResponseData update(@RequestBody List<WechatMenu> dto, BindingResult result, HttpServletRequest request) {
        getValidator().validate(dto, result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(getErrorMessage(result, request));
            return responseData;
        }
        IRequest requestCtx = createRequestContext(request);
        return new ResponseData(service.batchUpdate(requestCtx, dto));
    }

    /**
     * 新建菜单
     */
    @RequestMapping("/add")
    @ResponseBody
    public ResponseData addMenu(@RequestBody WechatMenu dto, HttpServletRequest request) {
        IRequest requestCtx = createRequestContext(request);
        return service.addMenu(requestCtx, dto);
    }

    @RequestMapping("/update")
    @ResponseBody
    public ResponseData updateMenu(@RequestBody List<WechatMenu> wechatMenus, HttpServletRequest request) {
        IRequest requestCtx = createRequestContext(request);
        return service.updateMenu(requestCtx, wechatMenus);
    }

    @RequestMapping("/delete")
    @ResponseBody
    public ResponseData deleteMenu(@RequestBody WechatMenu dto, HttpServletRequest request) {
        IRequest requestCtx = createRequestContext(request);
        if (dto.getId() == null) {
            return new ResponseData(false);
        }
        return service.deleteMenu(requestCtx, dto);
    }

    @RequestMapping("/query")
    @ResponseBody
    public ResponseData queryMenu(WechatMenu dto, HttpServletRequest request) {
        IRequest requestCtx = createRequestContext(request);
        return service.queryMenu(requestCtx, dto);
    }

    @RequestMapping("/synchronize")
    @ResponseBody
    public ResponseData synchronizeMenu(WechatMenu dto, HttpServletRequest request) {
        IRequest requestCtx = createRequestContext(request);
        return service.synchronizeMenu(requestCtx, dto);
    }

    @RequestMapping("/publish")
    @ResponseBody
    public ResponseData publishMenu(WechatMenu dto, HttpServletRequest request) {
        IRequest requestCtx = createRequestContext(request);
        return service.publishMenu(requestCtx, dto);
    }

    @RequestMapping("/push")
    public ResponseData pushMenus(Long accountId) {
        return service.pushMenus(accountId);
    }
}
