package hls.support.core.wechat.controllers;

import hls.support.core.wechat.dto.WechatAccount;
import hls.support.core.wechat.service.IWechatEnterpriseAppService;
import org.springframework.stereotype.Controller;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.wechat.dto.WechatEnterpriseApp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

import org.springframework.validation.BindingResult;

import java.util.ArrayList;
import java.util.List;

@Controller
public class WechatEnterpriseAppController extends BaseController {

    @Autowired
    private IWechatEnterpriseAppService service;


    @RequestMapping(value = "/wechat/enterprise/app/query")
    @ResponseBody
    public ResponseData query(WechatEnterpriseApp dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                              @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(service.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value = "/wechat/enterprise/app/queryAccount")
    @ResponseBody
    public ResponseData queryAccount(WechatEnterpriseApp dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                                     @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {
        IRequest iRequest = createRequestContext(request);
        ResponseData responseData = new ResponseData();
        responseData.setRows(service.selectApps(iRequest, dto, page, pageSize));
        return responseData;
    }

    @RequestMapping(value = "/wechat/enterprise/app/submit")
    @ResponseBody
    public ResponseData update(@RequestBody List<WechatEnterpriseApp> dto, BindingResult result, HttpServletRequest request) {
        getValidator().validate(dto, result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(getErrorMessage(result, request));
            return responseData;
        }
        IRequest requestCtx = createRequestContext(request);
        return new ResponseData(service.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value = "/wechat/enterprise/app/remove")
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<WechatEnterpriseApp> dto) {
        service.batchDelete(dto);
        return new ResponseData();
    }

    @RequestMapping(value = "/wechat/app/queryAccount")
    @ResponseBody
    public ResponseData queryAccount(WechatEnterpriseApp dto, HttpServletRequest request){
        IRequest requestCtx = createRequestContext(request);
        return service.queryAccount(requestCtx,dto);
    }
}