package hls.support.core.wechat.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import hls.support.core.wechat.service.WechatAcceptAutoRecoverService;
import hls.support.core.wechat.utils.WechatCheckUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;

@Controller
public class WechatAcceptAutoRecoverController extends BaseController {

    private static Logger log = Logger.getLogger(WechatAcceptAutoRecoverController.class);
    @Autowired
    private WechatAcceptAutoRecoverService service;
    @Value("#{configProperties['wx.token']}")
    private String token;
    @RequestMapping(value = "/accept/wechat/auto/app")
    @ResponseBody
    public void wechatService(PrintWriter out, HttpServletResponse response,
                              HttpServletRequest request,
                              @RequestParam(value = "signature", required = false) String signature,
                              @RequestParam String timestamp,
                              @RequestParam String nonce,
                              @RequestParam(required = false) String echostr) {
        IRequest iRequest = createRequestContext(request);
        log.info("signature：" + signature + "\ntimestamp：" + timestamp + "\nnonce：" + nonce + "\nechostr：" + echostr);
        if (StringUtils.isNotEmpty(echostr)) {
            if (WechatCheckUtil.checkSignature(token, signature, timestamp, nonce)) {
                log.info(echostr);
                out.print(echostr);
            }
        } else {
            service.filterSubscribe(request, response, iRequest);
        }
    }


}
