package hls.support.core.wechat.controllers;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.wechat.dto.NotificationTemplate;
import hls.support.core.wechat.service.INotificationTemplateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

import org.springframework.validation.BindingResult;

import java.util.List;
import java.util.Map;

@Controller
public class NotificationTemplateController extends BaseController {

    @Autowired
    private INotificationTemplateService service;


    @RequestMapping(value = "/wechat/notification/template/query")
    @ResponseBody
    public ResponseData query(NotificationTemplate dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                              @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(service.query(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value = "/wechat/notification/template/submit")
    @ResponseBody
    public ResponseData update(@RequestBody List<NotificationTemplate> dto, BindingResult result, HttpServletRequest request) {
        getValidator().validate(dto, result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(getErrorMessage(result, request));
            return responseData;
        }
        IRequest requestCtx = createRequestContext(request);
        return new ResponseData(service.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value = "/wechat/notification/template/remove")
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<NotificationTemplate> dto) {
        service.batchDelete(dto);
        return new ResponseData();
    }

    @RequestMapping(value = "/r/api/wechat/notification/template/sendNotication")
    @ResponseBody
    public ResponseData sendNotication(HttpServletRequest request, @RequestBody Map map) {
        IRequest iRequest = createRequestContext(request);
        if (!map.containsKey("messages")) {
            ResponseData noMessagesData = new ResponseData(false);
            noMessagesData.setMessage("未传messages参数");
            return noMessagesData;
        }
        List<Map> list = (List) map.get("messages");
        if (list.size() > 0) {
            Boolean success = true;
            String message = "";
            for (int i = 0; i < list.size(); i++) {
                ResponseData responseData = service.sendNotication(iRequest, list.get(i));
                if (!responseData.isSuccess()) {
                    success = false;
                    message += "第" + (i + 1) + "条模板信息：" + responseData.getMessage() + ";";
                }
            }
            ResponseData responseMessage = new ResponseData(success);
            if (StringUtils.isNotEmpty(message)) {
                responseMessage.setMessage(message);
            }
            return responseMessage;
        } else {
            ResponseData responseDatas = new ResponseData(false);
            responseDatas.setMessage("Your param is wrong");
            return responseDatas;
        }
    }
}