package hls.support.core.wechat.controllers;

import hls.support.core.wechat.service.IJSSDKService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * Created by weck on 18/01/2018 3:33 PM
 */
@Controller
@RequestMapping(value = {"/r/api","/"})
public class JSSDKController {

    @Autowired
    private IJSSDKService service;

    @RequestMapping("/js/sdk/getWxConfig")
    @ResponseBody
    public Map<String,Object> getWxConfig(@RequestParam("wxCode") String wxCode,
                                          @RequestParam("clientUrl")String clientUrl,
                                          HttpServletRequest request){
        return service.getWxConfig(wxCode,clientUrl,request);
    }
}
