package hls.support.core.wechat.controllers;

import hls.support.core.wechat.dto.WechatDepartment;
import org.springframework.stereotype.Controller;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.wechat.dto.EnterpriseAppDepartment;
import hls.support.core.wechat.service.IAppDepartmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

import org.springframework.validation.BindingResult;

import java.util.List;

@Controller
public class AppDepartmentController extends BaseController {

    @Autowired
    private IAppDepartmentService service;


    @RequestMapping(value = "/enterprise/app/department/query")
    @ResponseBody
    public ResponseData query(EnterpriseAppDepartment dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                              @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(service.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value = "/enterprise/app/department/submit")
    @ResponseBody
    public ResponseData update(@RequestBody List<EnterpriseAppDepartment> dto, BindingResult result, HttpServletRequest request) {
        getValidator().validate(dto, result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(getErrorMessage(result, request));
            return responseData;
        }
        IRequest requestCtx = createRequestContext(request);
        return new ResponseData(service.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value = "/enterprise/app/department/remove")
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<EnterpriseAppDepartment> dto) {
        service.batchDelete(dto);
        return new ResponseData();
    }

    /**
     * 查询企业应用的可见部门列表
     */
    @RequestMapping(value = "/department/queryByApp")
    @ResponseBody
    public ResponseData queryByApp(HttpServletRequest request, WechatDepartment wechatDepartment, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                                   @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(service.queryByApp(requestContext, wechatDepartment, page, pageSize));
    }

}