package hls.support.core.sys.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.sys.dto.SysChannelManage;
import hls.support.core.sys.dto.SysChannelPassManage;
import hls.support.core.sys.service.ISysChannelPassManageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: Jeffery
 * Date: 2018/3/21
 * Time: 10:21
 * To change this template use File | Settings | File Templates.
 */
@Controller
public class SysChannelPassManageController extends BaseController {
    @Autowired
    private ISysChannelPassManageService sysChannelPassManageService;
    /*
    * @Author Jerffery
    * 渠道管理查询全部的信息
    *
    * */
    @RequestMapping(value = "/sys/channel/pass/manage/query")
    @ResponseBody
    public ResponseData query(SysChannelPassManage dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                              @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(sysChannelPassManageService.select(requestContext, dto, page, pageSize));
    }

    /*
    * @Author Jerffery
    * 添加渠道管理
    *
    * */
    @RequestMapping(value = "/sys/channel/pass/manage/update")
    @ResponseBody
    public ResponseData save(@RequestBody List<SysChannelPassManage> dto, BindingResult result, HttpServletRequest request) {
        getValidator().validate(dto, result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(getErrorMessage(result, request));
            return responseData;
        }
        IRequest requestCtx = createRequestContext(request);
        return new ResponseData(sysChannelPassManageService.batchUpdate(requestCtx, dto));
    }

    /*
    * @Author Jerffery
    * 删除渠道管理
    *
    * */
    @RequestMapping(value = "/sys/channel/pass/manage/delete")
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<SysChannelPassManage> dto) {
        sysChannelPassManageService.batchDelete(dto);
        return new ResponseData();
    }
}
