package hls.support.core.responseMessage.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import hls.support.core.responseMessage.mapper.ResponseMessageMapper;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import hls.support.core.responseMessage.dto.ResponseMessage;
import hls.support.core.responseMessage.service.IResponseMessageService;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
@Transactional(rollbackFor = Exception.class)
public class ResponseMessageServiceImpl extends BaseServiceImpl<ResponseMessage> implements IResponseMessageService {

    @Autowired
    ResponseMessageMapper mapper;

    @Override
    public String messageContent(IRequest iRequest, Long wechatAppId) {
        ResponseMessage responseMessage = new ResponseMessage();
        responseMessage.setWechatAppId(wechatAppId);
        List<ResponseMessage> responseMessageList = mapper.select(responseMessage);
        if (CollectionUtils.isEmpty(responseMessageList)) {
            return null;
        }
        String result = null;
        ResponseMessage message = responseMessageList.get(0);
        switch (message.getMsgType()) {
            case "text":
                result = message.getContent();
            case "news":
                break;
            case "image":
                break;
        }
        return result;
    }

    @Override
    public ResponseData updateContent(IRequest iRequest, ResponseMessage responseMessage) {
        ResponseMessage dto = self().selectByPrimaryKey(iRequest, responseMessage);
        if (dto != null) {
            self().updateByPrimaryKeySelective(iRequest, responseMessage);
        } else {
            self().insertSelective(iRequest, responseMessage);
        }
        return new ResponseData();
    }


}