package hls.support.core.responseMessage.controllers;

import org.springframework.stereotype.Controller;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import hls.support.core.responseMessage.dto.ResponseMessage;
import hls.support.core.responseMessage.service.IResponseMessageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

import org.springframework.validation.BindingResult;

import java.util.List;

@Controller
public class ResponseMessageController extends BaseController {

    @Autowired
    private IResponseMessageService service;


    @RequestMapping(value = "/response/message/query")
    @ResponseBody
    public ResponseData query(ResponseMessage dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                              @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(service.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value = "/response/message/submit")
    @ResponseBody
    public ResponseData update(@RequestBody List<ResponseMessage> dto, BindingResult result, HttpServletRequest request) {
        getValidator().validate(dto, result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(getErrorMessage(result, request));
            return responseData;
        }
        IRequest requestCtx = createRequestContext(request);
        return new ResponseData(service.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value = "/response/message/remove")
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<ResponseMessage> dto) {
        service.batchDelete(dto);
        return new ResponseData();
    }

    @RequestMapping(value = "/response/message/updateContent")
    @ResponseBody
    public ResponseData updateContent(HttpServletRequest request, @RequestBody ResponseMessage responseMessage) {
        IRequest iRequest = createRequestContext(request);
        return service.updateContent(iRequest, responseMessage);
    }
}