//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.hand.hap.intergration.service.impl;

import com.alibaba.fastjson.JSON;
import com.hand.hap.intergration.beans.HapInvokeInfo;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.exception.HapApiException;
import com.hand.hap.intergration.service.IHapApiService;
import com.hand.hap.intergration.service.IHapAuthenticationService;
import com.hand.hap.intergration.util.JSONAndMap;
import com.hand.hap.mybatis.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HapSoapApiServiceImpl implements IHapApiService {
    private static final Logger logger = LoggerFactory.getLogger(HapSoapApiServiceImpl.class);
    @Autowired
    private IHapAuthenticationService authenticationService;

    public HapSoapApiServiceImpl() {
    }

    public Map soapSend(HapInterfaceHeader headerAndLineDTO, String xml) throws Exception {
        StringBuffer data = new StringBuffer();

        InputStream map;
        try {
            map = this.getSoapInputStream(xml, headerAndLineDTO);
            BufferedReader e = new BufferedReader(new InputStreamReader(map, "UTF-8"));
            String line = null;

            while(true) {
                if((line = e.readLine()) == null) {
                    e.close();
                    map.close();
                    break;
                }

                data.append(line);
            }
        } catch (Exception var8) {
            throw var8;
        }

        map = null;

        try {
            Map map1 = JSONAndMap.xml2map(data.toString());
            HapInvokeInfo.OUTBOUND_RESPONSE_DATA.set(data.toString());
            return map1;
        } catch (Exception var7) {
            throw new HapApiException("error.format_xmlToMap", "ERROR XML 2 MAP");
        }
    }

    public InputStream getSoapInputStream(String xml, HapInterfaceHeader headerAndLineDTO) throws Exception {
        try {
            String e = headerAndLineDTO.getDomainUrl() + headerAndLineDTO.getIftUrl();
            URL count1 = new URL(e);
            URLConnection conn = count1.openConnection();
            conn.setUseCaches(false);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Length", Integer.toString(xml.length()));
            conn.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
            if(!StringUtil.isEmpty(headerAndLineDTO.getSoapAction())) {
                conn.setRequestProperty("SOAPAction", headerAndLineDTO.getSoapAction());
            }

            if("Y".equalsIgnoreCase(headerAndLineDTO.getAuthFlag())) {
                String os;
                if("BASIC_AUTH".equalsIgnoreCase(headerAndLineDTO.getAuthType())) {
                    os = headerAndLineDTO.getAuthUsername() + ":" + headerAndLineDTO.getAuthPassword();
                    String basicBase64 = new String(Base64.encodeBase64(os.getBytes()));
                    conn.setRequestProperty("Authorization", "Basic " + basicBase64);
                } else {
                    os = this.authenticationService.getToken(headerAndLineDTO);
                    if(StringUtil.isEmpty(os)) {
                        logger.error("get access_token failure,check your config");
                        throw new RuntimeException("get access_token failure,check your config");
                    }

                    conn.setRequestProperty("Authorization", "Bearer " + os);
                }
            }

            conn.connect();
            OutputStream os1 = conn.getOutputStream();
            Throwable var8 = null;

            InputStream var12;
            try {
                OutputStreamWriter osw = new OutputStreamWriter(os1, "utf-8");
                Throwable var10 = null;

                try {
                    osw.write(xml);
                    osw.flush();
                    InputStream is = conn.getInputStream();
                    var12 = is;
                } catch (Throwable var37) {
                    var10 = var37;
                    throw var37;
                } finally {
                    if(osw != null) {
                        if(var10 != null) {
                            try {
                                osw.close();
                            } catch (Throwable var36) {
                                var10.addSuppressed(var36);
                            }
                        } else {
                            osw.close();
                        }
                    }

                }
            } catch (Throwable var39) {
                var8 = var39;
                throw var39;
            } finally {
                if(os1 != null) {
                    if(var8 != null) {
                        try {
                            os1.close();
                        } catch (Throwable var35) {
                            var8.addSuppressed(var35);
                        }
                    } else {
                        os1.close();
                    }
                }

            }

            return var12;
        } catch (IOException var41) {
            if("Y".equalsIgnoreCase(headerAndLineDTO.getAuthFlag()) && "OAUTH2".equalsIgnoreCase(headerAndLineDTO.getAuthType()) && var41.getMessage().contains("response code: 401")) {
                logger.warn(var41.getMessage());
                this.authenticationService.updateToken(headerAndLineDTO);
                Integer count = (Integer)HapInvokeInfo.TOKEN_TASK_COUNT.get();
                if(count != null && count.intValue() > 0) {
                    logger.info("try get access_token times:" + count);
                    HapInvokeInfo.TOKEN_TASK_COUNT.set(Integer.valueOf(count.intValue() - 1));
                    return this.getSoapInputStream(xml, headerAndLineDTO);
                }
            }

            logger.error(var41.getMessage(), var41);
            throw var41;
        }
    }

    public JSONObject invoke(HapInterfaceHeader headerAndLineDTO, JSONObject inbound) throws Exception {
        logger.info("inbound:{}", inbound);
        String xml = "";

        try {
            if(inbound != null) {
                xml = JSONAndMap.jsonToXml(inbound.toString(), headerAndLineDTO.getNamespace());
            }
        } catch (Exception var6) {
            logger.info("jsonToMap error:{}", var6);
            throw new HapApiException("error.format_jsonToMap", "jsonToMap error");
        }

        xml = headerAndLineDTO.getBodyHeader() + xml + headerAndLineDTO.getBodyTail();
        HapInvokeInfo.OUTBOUND_REQUEST_PARAMETER.set(xml);
        Map result = this.soapSend(headerAndLineDTO, xml);
        JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(result));
        return jsonObject;
    }
}
