//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.hand.hap.intergration.service.impl;

import com.hand.hap.intergration.beans.HapJDBCSqlSessionFactory;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.service.IHapApiService;
import com.hand.hap.intergration.util.JSONHelper;
import java.io.IOException;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.stereotype.Service;

@Service
public class HapPLSQLApiServiceImpl implements IHapApiService {
    @Autowired
    private HapJDBCSqlSessionFactory hapSqlSessionFactory;
    private Logger logger = LoggerFactory.getLogger(HapPLSQLApiServiceImpl.class);

    public HapPLSQLApiServiceImpl() {
    }

    public JSONObject invoke(HapInterfaceHeader headerAndLineDTO, JSONObject inbound) {
        int index = headerAndLineDTO.getIftUrl().lastIndexOf(".");
        String url = headerAndLineDTO.getIftUrl();
        String packageName = url.substring(0, index);
        String functionName = url.substring(index + 1);

        JSONObject jsonResp = new JSONObject();
        try {
            JSONObject e = (JSONObject)inbound.get("params");
            this.logger.info("packageName:{}  functionName:{} ", packageName, functionName);
            this.logger.info("inbound params is:" + e.toString());
            String executeSql = "";
            String respStr;
            if(e == null) {
                executeSql = "{?=call " + url + "}";
            } else {
                executeSql = "{?=call " + url + "(";

                /*for(Iterator resp = e.keys(); resp.hasNext(); executeSql = executeSql + respStr + "=>\'" + e.get(respStr) + "\',") {
                    respStr = (String)resp.next();
                }*/
                for (Map.Entry<String, Object> entry : e.entrySet()) {
                    String key = entry.getKey();
                    executeSql += key + "=>\'" + entry.getValue() + "\',";
                    //System.out.println(entry.getKey() + ":" + entry.getValue());
                }
                executeSql = executeSql.substring(0, executeSql.length() - 1);
                executeSql = executeSql + ")}";
            }

            this.logger.info("executeSql:{} ", executeSql);
            Object resp1 = this.hapSqlSessionFactory.getJdbcTemplateObject().execute(executeSql, new CallableStatementCallback() {
                public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
                    cs.registerOutParameter(1, 2005);
                    cs.execute();
                    return this.clobToString(cs.getClob(1));
                }

                private String clobToString(Clob clob) {
                    if(clob == null) {
                        return null;
                    } else {
                        try {
                            Reader es = clob.getCharacterStream();
                            char[] tempDoc = new char[(int)clob.length()];
                            es.read(tempDoc);
                            es.close();
                            return new String(tempDoc);
                        } catch (IOException var4) {
                            var4.printStackTrace();
                        } catch (SQLException var5) {
                            var5.printStackTrace();
                        }

                        return null;
                    }
                }
            });
            respStr = resp1.toString().replaceAll("null", "\"\"");
            jsonResp = JSONObject.parseObject(respStr);
        } catch (Exception var12) {
            var12.printStackTrace();
            this.logger.error(var12.getMessage());

            jsonResp.put("errorMsg","");
            //jsonResp = JSONHelper.getErrorJSONObject("");
        }

        return jsonResp;
    }
}
