package com.hand.hap.core.web.view.ui;

import com.hand.hap.core.web.view.ScreenBuilder;
import com.hand.hap.core.web.view.UITag;
import com.hand.hap.core.web.view.ViewContext;
import com.hand.hap.core.web.view.XMap;

import java.util.List;


/**
 * 
 * 
 * 
 * @author yang.gao01@hand-china.com
 * 
 */
@UITag
public class HlsPannelBars extends Component {

	public static final String PROPERTITY_HLSPANNELBARS = "hlsPannelBars";
	public static final String PROPERTITY_HLSPANNELCONTENT = "hlsPannelContent";
	public static final String PROPERTITY_HLSCLASSNAME = "hlsClassName";


	public void setHlsClassName(String HlsClassName) {
		setPropertity(PROPERTITY_HLSCLASSNAME, HlsClassName);
	}

	public String getHlsClassName() {
		return getPrototype().getString(PROPERTITY_HLSCLASSNAME);
	}

	public String getPannelContent(ViewContext context) throws Exception {
		StringBuffer sb = new StringBuffer();
		List<XMap> list = getPrototype().getChildren();
		for (XMap map : list) {
			sb.append(ScreenBuilder.build(map, context));
		}
		return sb.toString();
	}

	public static HlsPannelBars createInstance() {
		XMap view = new XMap(DEFAULT_TAG_PREFIX, DEFAULT_NAME_SPACE,
				PROPERTITY_HLSPANNELBARS);
		HlsPannelBars HlsPannelBars = new HlsPannelBars();
		HlsPannelBars.initPrototype(view);
		return HlsPannelBars;
	}

	public void init(XMap view, ViewContext context) throws Exception {
		super.init(view, context);
		context.put(PROPERTITY_HLSCLASSNAME, getHlsClassName());
		context.put(PROPERTITY_HLSPANNELCONTENT, getPannelContent(context));
	}

}
