package com.hand.hap.core.web.view.ui;

import com.hand.hap.core.web.view.ScreenBuilder;
import com.hand.hap.core.web.view.UITag;
import com.hand.hap.core.web.view.ViewContext;
import com.hand.hap.core.web.view.XMap;
import org.springframework.security.web.csrf.CsrfToken;

import java.util.List;

/**
 * @author yang.gao01@hand-china.com
 */
@UITag
public class HlsGridBox extends Component {
    public static final String PROPERTITY_HLSGRIDBOX = "hlsGridBox";
    public static final String PROPERTITY_TITLE = "title";
    public static final String PROPERTITY_WIDTH = "width";
    public static final String PROPERTITY_HEIGHT = "height";
    public static final String PROPERTITY_HLSGRIDBOXBODY = "hlsgridboxbody";
    public static final String PROPERTITY_HLSCLASSNAME = "hlsClassName";
    public static final String PROPERTITY_HLSGRIDID = "hlsGridId";
    public static final String PROPERTITY_CONTEXTPATH = "contextPath";
    public static final String PROPERTITY_HLSBTNTYPE = "hlsBtnType";
    public static final String PROPERTITY_QUERYID = "queryId";
    public static final String PROPERTITY_QUERYPLACEHOLDER = "queryPlaceholder";
    public static final String PROPERTITY_CONTROLLERNAME = "controllerName";
    public static final String PROPERTITY_VIEWMODELNAME = "viewModelName";
    public static final String PROPERTITY_DATASOURCEID = "dataSourceId";
    public static final String PROPERTITY_FILENAME = "fileName";
    public static final String PROPERTITY_CUSTOM1IMAGE = "custom1Image";
    public static final String PROPERTITY_CUSTOM2IMAGE = "custom2Image";
    public static final String PROPERTITY_CUSTOM3IMAGE = "custom3Image";
    public static final String PROPERTITY_CUSTOM4IMAGE = "custom4Image";
    public static final String PROPERTITY_CUSTOM1Title = "custom1Title";
    public static final String PROPERTITY_CUSTOM2Title = "custom2Title";
    public static final String PROPERTITY_CUSTOM3Title = "custom3Title";
    public static final String PROPERTITY_CUSTOM4Title = "custom4Title";
    public static final String PROPERTITY_REQUIRED = "required";
    public static final String PROPERTITY_PRMOPTIMAGE = "promptImage";

    public String getRequired() {
        return getPrototype().getString(PROPERTITY_REQUIRED);
    }

    public String getCustom1Image() {
        return getPrototype().getString(PROPERTITY_CUSTOM1IMAGE);
    }

    public String getCustom2Image() {
        return getPrototype().getString(PROPERTITY_CUSTOM2IMAGE);
    }

    public String getCustom3Image() {
        return getPrototype().getString(PROPERTITY_CUSTOM3IMAGE);
    }

    public String getCustom4Image() {
        return getPrototype().getString(PROPERTITY_CUSTOM4IMAGE);
    }

    public String getCustom1Title() {
        return getPrototype().getString(PROPERTITY_CUSTOM1Title);
    }

    public String getCustom2Title() {
        return getPrototype().getString(PROPERTITY_CUSTOM2Title);
    }

    public String getCustom3Title() {
        return getPrototype().getString(PROPERTITY_CUSTOM3Title);
    }

    public String getCustom4Title() {
        return getPrototype().getString(PROPERTITY_CUSTOM4Title);
    }

    public void setRequired(String required) {
        setPropertity(PROPERTITY_REQUIRED, required);
    }

    public void setCustom1Image(String custom1Image) {
        setPropertity(PROPERTITY_CUSTOM1IMAGE, custom1Image);
    }

    public void setCustom2Image(String custom2Image) {
        setPropertity(PROPERTITY_CUSTOM2IMAGE, custom2Image);
    }

    public void setCustom3Image(String custom3Image) {
        setPropertity(PROPERTITY_CUSTOM3IMAGE, custom3Image);
    }

    public void setCustom4Image(String custom4Image) {
        setPropertity(PROPERTITY_CUSTOM4IMAGE, custom4Image);
    }

    public void setCustom1Title(String custom1Title) {
        setPropertity(PROPERTITY_CUSTOM1Title, custom1Title);
    }

    public void setCustom2Title(String custom2Title) {
        setPropertity(PROPERTITY_CUSTOM2Title, custom2Title);
    }

    public void setCustom3Title(String custom3Title) {
        setPropertity(PROPERTITY_CUSTOM3Title, custom3Title);
    }

    public void setCustom4Title(String custom4Title) {
        setPropertity(PROPERTITY_CUSTOM4Title, custom4Title);
    }

    public void setHeight(String height) {
        setPropertity(PROPERTITY_TITLE, height);
    }

    public void setWidth(String width) {
        setPropertity(PROPERTITY_WIDTH, width);
    }

    public void setTitle(String title) {
        setPropertity(PROPERTITY_HEIGHT, title);
    }

    public void setHlsClassName(String hlsClassName) {
        setPropertity(PROPERTITY_HLSCLASSNAME, hlsClassName);
    }

    public void setHlsGridId(String hlsGridId) {
        setPropertity(PROPERTITY_HLSGRIDID, hlsGridId);
    }

    public void setHlsBtnType(String hlsBtnType) {
        setPropertity(PROPERTITY_HLSBTNTYPE, hlsBtnType);
    }

    public void setHlsQueryId(String queryId) {
        setPropertity(PROPERTITY_QUERYID, queryId);
    }

    public void setQueryPlaceholder(String queryPlaceholder) {
        setPropertity(PROPERTITY_QUERYPLACEHOLDER, queryPlaceholder);
    }

    public void setControllerName(String controllerName) {
        setPropertity(PROPERTITY_CONTROLLERNAME, controllerName);
    }

    public void setViewModelName(String viewModelName) {
        setPropertity(PROPERTITY_VIEWMODELNAME, viewModelName);
    }

    public void setFileName(String fileName) {
        setPropertity(PROPERTITY_FILENAME, fileName);
    }

    public void setDataSourceId(String dataSourceId) {
        setPropertity(PROPERTITY_DATASOURCEID, dataSourceId);
    }

    public String getHeight() {
        return getPrototype().getString(PROPERTITY_HEIGHT);
    }

    public String getWidth() {
        String width = getPrototype().getString(PROPERTITY_WIDTH);
        if (width == null) {
            width = "100%";
        }
        return width;
    }

    public String getTitle() {
        return getPrototype().getString(PROPERTITY_TITLE);
    }

    public String getHlsClassName() {
        return getPrototype().getString(PROPERTITY_HLSCLASSNAME);
    }

    public String getHlsGridId() {
        return getPrototype().getString(PROPERTITY_HLSGRIDID);
    }

    public String getHlsBtnType() {
        return getPrototype().getString(PROPERTITY_HLSBTNTYPE);
    }

    public String getHlsQueryId() {
        return getPrototype().getString(PROPERTITY_QUERYID);
    }

    public String getQueryPlaceholder() {
        return getPrototype().getString(PROPERTITY_QUERYPLACEHOLDER);
    }

    public String getControllerName() {
        return getPrototype().getString(PROPERTITY_CONTROLLERNAME);
    }

    public String getViewModelName() {
        return getPrototype().getString(PROPERTITY_VIEWMODELNAME);
    }

    public String getFileName() {
        return getPrototype().getString(PROPERTITY_FILENAME);
    }

    public String getDatasourceid() {
        return getPrototype().getString(PROPERTITY_DATASOURCEID);
    }

    public String getGrixBoxBody(ViewContext context) throws Exception {
        StringBuffer sb = new StringBuffer();
        List<XMap> list = getPrototype().getChildren();
        for (XMap map : list) {
            sb.append(ScreenBuilder.build(map, context));
        }
        return sb.toString();
    }

    public static HlsGridBox createInstance() {
        XMap view = new XMap(DEFAULT_TAG_PREFIX, DEFAULT_NAME_SPACE, PROPERTITY_HLSGRIDBOX);
        HlsGridBox HlsGridBox = new HlsGridBox();
        HlsGridBox.initPrototype(view);
        return HlsGridBox;
    }

    public void setHlsBtn(ViewContext context) {
        if (getHlsBtnType() != null) {
            String[] datas = getHlsBtnType().split(",");
            for (int i = 0; i < datas.length; i++) {
                String btnType = datas[i].trim().toUpperCase();
                context.put("BTN" + btnType, "Y");
            }
        }
    }

    public void setViewModel(ViewContext context) {
        if (getViewModelName() != null) {
            String[] datas = getViewModelName().split("\\.");
            for (int i = 0; i < datas.length; i++) {
                if (i == 0) {
                    context.put("viewModel", datas[i]);
                } else {
                    context.put("viewModelData", datas[i]);
                }
            }
        }
    }

    public String getPromptImage() {
        String required = this.getPrototype().getString("required");
        String promptImage = null;
        if ("true".equals(required)) {
            promptImage = "*";
        }

        return promptImage;
    }

    public void init(XMap view, ViewContext context) throws Exception {
        super.init(view, context);
        context.put(PROPERTITY_TITLE, getTitle());
        context.put(PROPERTITY_HEIGHT, getHeight());
        context.put(PROPERTITY_WIDTH, getWidth());
        context.put(PROPERTITY_HLSCLASSNAME, getHlsClassName());
        context.put(PROPERTITY_HLSGRIDID, getHlsGridId());
        context.put(PROPERTITY_HLSGRIDBOXBODY, getGrixBoxBody(context));
        context.put(PROPERTITY_CONTEXTPATH, context.getContextPath());
        context.put(PROPERTITY_QUERYID, getHlsQueryId());
        context.put(PROPERTITY_QUERYPLACEHOLDER, getQueryPlaceholder());
        context.put(PROPERTITY_CONTROLLERNAME, getControllerName());
        context.put(PROPERTITY_DATASOURCEID, getDatasourceid());
        context.put(PROPERTITY_FILENAME, getFileName());
        context.put(PROPERTITY_CUSTOM1IMAGE, getCustom1Image());
        context.put(PROPERTITY_CUSTOM2IMAGE, getCustom2Image());
        context.put(PROPERTITY_CUSTOM3IMAGE, getCustom3Image());
        context.put(PROPERTITY_CUSTOM4IMAGE, getCustom4Image());
        context.put(PROPERTITY_CUSTOM1Title, getCustom1Title());
        context.put(PROPERTITY_CUSTOM2Title, getCustom2Title());
        context.put(PROPERTITY_CUSTOM3Title, getCustom3Title());
        context.put(PROPERTITY_CUSTOM4Title, getCustom4Title());
        context.put(PROPERTITY_REQUIRED, getRequired());
        context.put("promptImage",getPromptImage());
        CsrfToken token = (CsrfToken) context.getRequest().getSession().getAttribute("org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository.CSRF_TOKEN");
        context.put("_csrf_token", token.getToken());
        setViewModel(context);
        setHlsBtn(context);
    }
}
