package com.hand.app.file.controllers;


import com.codahale.metrics.annotation.Timed;
import com.github.pagehelper.StringUtil;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.service.IHapAuthenticationService;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import com.hand.hap.system.controllers.BaseController;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import javax.imageio.stream.ImageOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

import javax.imageio.ImageIO;

@Controller
@RequestMapping(value = {"/r/api","/"})
public class FileDownloadController extends BaseController {
    private Logger logger = LoggerFactory.getLogger(FileDownloadController.class);

    private static int CONNECT_SUCCESS = 200;
    @Autowired
    IHapInterfaceHeaderService headerService;
    @Autowired
    IHapAuthenticationService hapAuthenticationService;
    @Value("${markImgPath}")              //拉取该版本代码后必须在config.properties里面添加markImgPath，即使为空也行，否则会启动报错
    private String markImgPath;
    /**
     * hap的文件下载
     *
     * @param request
     * @param response
     * @param fileId
     * @param token
     */
    @RequestMapping(value = "/app/fileDownload")
    @ResponseBody
    public void fileDownload(HttpServletRequest request, HttpServletResponse response, @RequestParam("fileId") String fileId, @RequestParam("token") String token) {

        String sysName = request.getParameter("sysName");
        String apiName = request.getParameter("apiName");
        String charset = "UTF-8";
        HapInterfaceHeader hapInterfaceHeader = this.headerService.getHeaderAndLine(sysName, apiName);
        String url = hapInterfaceHeader.getDomainUrl() + hapInterfaceHeader.getIftUrl();
        try {
            JSONObject json = new JSONObject();
            json.put("fileId", fileId);
            json.put("token", token);
            String params = json.toString();

            URL myURL = new URL(url);
            HttpURLConnection connection = (HttpURLConnection) myURL.openConnection();
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestMethod("POST");
            if (!params.isEmpty()) {
                connection.setDoOutput(true);
            }
            if(hapInterfaceHeader.getAuthFlag().equals("Y")){
                this.processAuthAuthorization(hapInterfaceHeader, connection);
            }
            connection.connect();
            if (!params.isEmpty()) {
                OutputStream responseCode = connection.getOutputStream();
                responseCode.write(params.getBytes("UTF-8"));
                responseCode.flush();
                responseCode.close();
            }
            if (connection.getResponseCode() != CONNECT_SUCCESS) {
                throw new RuntimeException("HTTP GET Request Failed with Error code : " + connection.getResponseCode());
            }
            InputStream in = connection.getInputStream();
            ServletOutputStream out = response.getOutputStream();
            String cacheControl = connection.getHeaderField("cache-control");
            String contentType = connection.getHeaderField("Content-Type");
            String contentLength = connection.getHeaderField("Content-Length");
            String disposition = connection.getHeaderField("Content-disposition");
            response.setContentType(contentType);
            response.setContentLength(Integer.valueOf(contentLength));
            response.setHeader("cache-control", cacheControl);
            response.setHeader("pragma", "public");
            response.setHeader("Content-Disposition", disposition);
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            connection.disconnect();
        } catch (Exception e) {
            e.printStackTrace();
            logger.info("IOException", e.getMessage());
        }

    }

    /**
     * HAP文件上传
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/app/hap/fileUpload", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject fileUpload(HttpServletRequest request) {
        JSONObject json = new JSONObject();
        String sysName = request.getParameter("sysName");
        String apiName = request.getParameter("apiName");
        HapInterfaceHeader hapInterfaceHeader = this.headerService.getHeaderAndLine(sysName, apiName);
        try {
            boolean isMultipart = ServletFileUpload.isMultipartContent(request);
            if (!isMultipart) {
                json.put("error", "不支持的文件类型");
            }
            if (request instanceof MultipartHttpServletRequest) {
                MultipartHttpServletRequest req = (MultipartHttpServletRequest) request;
                Map<String, MultipartFile> fileMap = req.getFileMap();
                Map<String, String> textMap = new HashMap<String, String>();
                if (fileMap != null) {
                    Iterator<Map.Entry<String, MultipartFile>> iterator = fileMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, MultipartFile> next = iterator.next();
                        String fileKey = next.getKey();
                        MultipartFile filePart = next.getValue();
                        String fileName = ((CommonsMultipartFile) filePart).getFileItem().getName();
                        InputStream inputStream = filePart.getInputStream();
                        Map<String, String[]> parameterMap = request.getParameterMap();
                        if (parameterMap != null) {
                            Set<Map.Entry<String, String[]>> entries = parameterMap.entrySet();
                            for (Map.Entry<String, String[]> entry : entries) {
                                String key = entry.getKey();
                                String[] value = entry.getValue();
                                if (value != null && value.length > 0) {
                                    textMap.put(key, value[0]);
                                }
                            }
                        }
                        String result = this.formUpload(hapInterfaceHeader, textMap, fileName, inputStream,"files");
                        if (result != "-1") {
                            json.put("result", "S");
                            textMap.put("attachments", result);
                            json.put("response", textMap);
                        } else {
                            json.put("result", "E");
                        }
                    }
                }
            }

        } catch (Exception e) {
            json.put("result", "E");
            json.put("error", e.getMessage());
        }
        return json;
    }

    /**
     * 获取accessToken
     *
     * @param headerAndLineDTO
     * @return
     */
    private void processAuthAuthorization(HapInterfaceHeader headerAndLineDTO, HttpURLConnection connection) {
        String accessToken;
        if("BASIC_AUTH".equalsIgnoreCase(headerAndLineDTO.getAuthType())) {
            String e = headerAndLineDTO.getAuthUsername() + ":" + headerAndLineDTO.getAuthPassword();
            accessToken = new String(Base64.encodeBase64(e.getBytes()));
            connection.setRequestProperty("Authorization", "Basic " + accessToken);
        } else {
            accessToken = this.hapAuthenticationService.getToken(headerAndLineDTO);
            if(StringUtil.isEmpty(accessToken)) {
                this.logger.error("get access_token failure,check your config");
                throw new RuntimeException("get access_token failure,check your config");
            }
            connection.setRequestProperty("Authorization", "Bearer " + accessToken);
        }

    }

    /**
     * 调用租赁系统共有svc进行文件上传系统
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/app/fileUploadSvc", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject fileUploadRequest(HttpServletRequest request) {
        InputStream inputStream = null;
        JSONObject json = new JSONObject();
        String sysName = request.getParameter("sysName");
        String apiName = request.getParameter("apiName");
        String markFlag = request.getParameter("markFlag");
        HapInterfaceHeader hapInterfaceHeader = this.headerService.getHeaderAndLine(sysName, apiName);
        try {
            boolean isMultipart = ServletFileUpload.isMultipartContent(request);
            if (!isMultipart) {
                json.put("error", "不支持的文件类型");
            }
            if (request instanceof MultipartHttpServletRequest) {
                MultipartHttpServletRequest req = (MultipartHttpServletRequest) request;
                Map<String, MultipartFile> fileMap = req.getFileMap();
                Map<String, String> textMap = new HashMap<String, String>();
                if (fileMap != null) {
                    Iterator<Map.Entry<String, MultipartFile>> iterator = fileMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, MultipartFile> next = iterator.next();
                        String fileKey = next.getKey();
                        MultipartFile filePart = next.getValue();
                        String fileName = ((CommonsMultipartFile) filePart).getFileItem().getName();
                        inputStream = filePart.getInputStream();
                        Map<String, String[]> parameterMap = request.getParameterMap();
                        if (parameterMap != null) {
                            Set<Map.Entry<String, String[]>> entries = parameterMap.entrySet();
                            for (Map.Entry<String, String[]> entry : entries) {
                                String key = entry.getKey();
                                String[] value = entry.getValue();
                                if (value != null && value.length > 0) {
                                    textMap.put(key, value[0]);
                                }
                            }
                        }
                        String result = this.formUpload(hapInterfaceHeader, textMap, fileName, inputStream,"file");
                        if (result != "-1") {
                            json.put("result", "S");
                            textMap.put("attachment_id", result);
                            json.put("response", textMap);
                        } else {
                            json.put("result", "E");
                        }
                    }
                }
            }
        } catch (Exception e) {
            json.put("result", "E");
            json.put("error", e.getMessage());
        }
        return json;
    }

    /**
     * svc文件预览
     *
     * @param request
     * @param response
     * @param attId
     */
    @RequestMapping(value = "/app/fileViewSvc")
    @ResponseBody
    @Timed
    public void fileViewSvc(HttpServletRequest request, HttpServletResponse response, @RequestParam("attachment_id") String attId) {
        String charset = "UTF-8";
        String sysName = request.getParameter("sysName");
        String apiName = request.getParameter("apiName");
        HapInterfaceHeader hapInterfaceHeader = this.headerService.getHeaderAndLine(sysName, apiName);
        String url = hapInterfaceHeader.getDomainUrl() + hapInterfaceHeader.getIftUrl();
        try {
            url = url + (url.indexOf("?") > 0 ? "&attachment_id=" : "?attachment_id=") + attId;
            URL myURL = new URL(url);
            HttpURLConnection connection = (HttpURLConnection) myURL.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoInput(true);
            connection.connect();
            if (connection.getResponseCode() != 200) {
                throw new RuntimeException("HTTP GET Request Failed with Error code : " + connection.getResponseCode());
            }
            InputStream in = connection.getInputStream();
            ServletOutputStream out = response.getOutputStream();
            String cacheControl = connection.getHeaderField("cache-control");
            String contentType = connection.getHeaderField("Content-Type");
            String contentLength = connection.getHeaderField("Content-Length");
            String disposition = connection.getHeaderField("Content-disposition");
            response.setContentType(contentType);
            response.setContentLength(Integer.valueOf(contentLength));
            response.setHeader("cache-control", cacheControl);
            response.setHeader("pragma", "public");
            response.setHeader("Content-Disposition", disposition);

            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            connection.disconnect();
        } catch (Exception e) {

        }

    }

    /**
     * 上传图片
     *
     * @param headerAndLineDTO   接口地址
     * @param textMap     表单text信息
     * @param inputStream 文件输入流
     * @param fileName    图片名称
     * @param files
     * @return
     */

    private String formUpload(HapInterfaceHeader headerAndLineDTO, Map<String, String> textMap, String fileName, InputStream inputStream, String files) {
        String res = "";
        HttpURLConnection conn = null;
        String uploadUrl = headerAndLineDTO.getDomainUrl() + headerAndLineDTO.getIftUrl();
        String BOUNDARY = "----******************************"; //boundary就是request头和上传文件内容的分隔符
        try {
            URL url = new URL(uploadUrl);
            conn = (HttpURLConnection) url.openConnection();
            // 允许输入输出流
            conn.setDoInput(true);// 设置是否从httpUrlConnection读入，默认情况下是true
            conn.setDoOutput(true);//设置是否向httpUrlConnection输出，因为这个是post请求，参数要放在http正文内，因此需要设为true, 默认情况下是false
            conn.setUseCaches(false); // Post 请求不能使用缓存,没有进行内部缓冲
            conn.setRequestMethod("POST");//设定请求的方法为"POST"，默认是GET
            if(headerAndLineDTO.getAuthFlag().equals("Y")) {
                this.processAuthAuthorization(headerAndLineDTO, conn);
            }
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);//首先在HTTP请求头设置一个分隔符*****
            OutputStream out = new DataOutputStream(conn.getOutputStream());
            // 为text时
            if (textMap != null) {
                StringBuffer strBuf = new StringBuffer();
                Iterator iter = textMap.entrySet().iterator();
                //循环
                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry) iter.next();
                    String inputName = (String) entry.getKey();
                    String inputValue = (String) entry.getValue();
                    if (inputValue == null) {
                        continue;
                    }
                    //分隔
                    strBuf.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
                    strBuf.append("Content-Disposition: form-data; name=\"" + inputName + "\"\r\n\r\n");
                    strBuf.append(inputValue);
                }
                //写进流中
                out.write(strBuf.toString().getBytes());
            }
            // 为file时
            // if (base64Str!="") {
            if (fileName != "") {
                String filename = fileName;
                StringBuffer strBuf = new StringBuffer();
                //分隔
                strBuf.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
                //拼接数据
                if (files.equals("files")) {
                    strBuf.append("Content-Disposition: form-data; name=\""
                            + "files" + "\"; filename=\"" + filename
                            + "\"\r\n");
                } else {
                    strBuf.append("Content-Disposition: form-data; name=\""
                            + "file" + "\"; filename=\"" + filename
                            + "\"\r\n");
                }
                this.logger.info("filename======>" + filename);
                //设置contentType
                String contentType = this.getContentType(filename);
                strBuf.append("Content-Type:" + contentType + "\r\n\r\n");
                this.logger.info("contentType======>" + contentType);
                //写进流中
                out.write(strBuf.toString().getBytes());
                DataInputStream in = new DataInputStream(inputStream);
                int bytes = 0;
                byte[] bufferOut = new byte[1024];
                while ((bytes = in.read(bufferOut)) != -1) {
                    out.write(bufferOut, 0, bytes);
                }
                in.close();
            }
            byte[] endData = ("\r\n--" + BOUNDARY + "--\r\n").getBytes();
            out.write(endData);
            out.flush();
            out.close();

            //获取返回结果.在getInputStream()函数调用的时候，就会把准备好的http请求 正式发送到服务器了，然后返回一个输入流，用于读取服务器对于此次http请求的返回信息。
            StringBuffer strBuf = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                strBuf.append(line);
            }
            res = strBuf.toString();
            this.logger.info("文件上传返回信息====>" + res);

            reader.close();
            reader = null;
            this.logger.info("文件上传，返回状态码====>" + conn.getResponseCode());

        } catch (Exception e) {
            this.logger.info("文件上传，发送POST请求出错==>" + uploadUrl);
            this.logger.info("文件上传，异常信息==>" + e.getMessage());
            //e.printStackTrace();
            this.logger.info("Exception", e.fillInStackTrace());
            return "-1";
        } finally {
            if (conn != null) {
                conn.disconnect();
                conn = null;
            }
        }
        return res;
    }
    private String getContentType(String filename){
        String type = null;
        Path path = Paths.get(filename);
        try {
            type = Files.probeContentType(path);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return type;
    }

    public static void main(String[] args){
        String fileName= "测试.jpg";
        Path path = Paths.get(fileName);
        String fileType="";
        try {
            fileType  = Files.probeContentType(path);;
        } catch (IOException e) {
            e.printStackTrace();
        }
        System.out.print(fileType);
    }
    // 加文字水印
    public void markFont(BufferedImage bufImg, Image img, String text, Font font, Color color, int x, int y) {
        Graphics2D g = bufImg.createGraphics();
        g.drawImage(img, 0, 0, bufImg.getWidth(), bufImg.getHeight(), null);
        g.setColor(color);
        g.setFont(font);
        g.drawString(text, x, y);
        g.dispose();

    }
    // 加图片水印
    public void markImg(BufferedImage bufImg, Image img, Image markImg, int width, int height, int x, int y) {
        Graphics2D g = bufImg.createGraphics();
        g.drawImage(img, 0, 0, bufImg.getWidth(), bufImg.getHeight(), null);
        g.drawImage(markImg, x, y, width, height, null);
        g.dispose();
    }
    /**
     * 给图片增加文字水印
     *
     * -@param inputStream
     *            -要添加水印的图片流
     * -@param text-文字
     * -@param font
     *            -字体
     * -@param color
     *            -颜色
     * -@param x
     *            -文字位于当前图片的横坐标
     * -@param y
     *            -文字位于当前图片的竖坐标
     */

     public InputStream addFontMark(InputStream inputStream, String text,String fileTypeName, Font font, Color color, int x, int y) {
        InputStream inputStreamMark = null;
        try {
            Image img = null;
            // 读取原图片信息
           /* File imgFile = null;
            Image img = null;
            if (imgPath != null) {
                imgFile = new File(imgPath);
            }*/
            if (inputStream != null) {
                img = ImageIO.read(inputStream);
            }
            int imgWidth = img.getWidth(null);
            int imgHeight = img.getHeight(null);
            // 加水印
            BufferedImage bufImg = new BufferedImage(imgWidth, imgHeight, BufferedImage.TYPE_INT_RGB);
            markFont(bufImg, img, text, font, color, x, y);

            //BufferedImage 转 InputStream
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageOutputStream imageOutput = ImageIO.createImageOutputStream(byteArrayOutputStream);
            ImageIO.write(bufImg, fileTypeName, imageOutput);
            inputStreamMark = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());

           /* // 输出图片
            //FileOutputStream outImgStream = new FileOutputStream(outImgPath);
            ImageIO.write(bufImg, "jpg", outImgStream);
            outImgStream.flush();
            outImgStream.close();*/
        } catch (Exception e) {
            e.printStackTrace();
        }
        return inputStreamMark;
    }
    /**
     * 给图片增加图片水印
     *
     * //@param inputImg
     *            -源图片，要添加水印的图片
     * // @param markImg
     *            - 水印图片
     *  //@param outputImg
     *            -输出图片(可以是源图片)
     *  //@param width
     *            - 水印图片宽度
     * // @param height
     *            -水印图片高度
     *  //@param x
     *            -横坐标，相对于源图片
     *  //@param y
     *            -纵坐标，同上
     */
    public InputStream addImgMark(InputStream inputStream, String markImg,String fileTypeName, int x, int y) {
        InputStream inputStreamMark = null;
        // 读取原图片信息
       // File inputImgFile = null;
        File markImgFile = null;
        Image img = null;
        Image mark = null;
        try {
            if (markImg != null) {
                markImgFile = new File(markImg);
            }
            if (inputStream != null) {

                img = ImageIO.read(inputStream);


            }
            if (markImgFile != null && markImgFile.exists() && markImgFile.isFile() && markImgFile.canRead()) {

                mark = ImageIO.read(markImgFile);

            }
            int imgWidth = img.getWidth(null); //得到原图的宽
            int imgHeight = img.getHeight(null);
            int srcImgMarkWidth = mark.getWidth(null);//获取水印图片的宽
            int srcImgMarkHeight = mark.getHeight(null);//获取水印图片的高
            BufferedImage bufImg = new BufferedImage(imgWidth, imgHeight, BufferedImage.TYPE_INT_RGB);
            markImg(bufImg, img, mark, srcImgMarkWidth, srcImgMarkHeight, x, y);


            //BufferedImage 转 InputStream
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageOutputStream imageOutput = ImageIO.createImageOutputStream(byteArrayOutputStream);
            ImageIO.write(bufImg, fileTypeName, imageOutput);
            inputStreamMark = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());

           /* FileOutputStream outImgStream = new FileOutputStream(outputImg);
            ImageIO.write(bufImg, "jpg", outImgStream);
            outImgStream.flush();
            outImgStream.close();*/
        } catch (IOException e) {
            e.printStackTrace();
        }
        return inputStreamMark;
    }
}
