package com.hand.app.cmb.util;

import com.alibaba.fastjson.JSONObject;
import com.chinapay.secss.LogUtil;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

import javax.net.ssl.*;
import java.io.*;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.*;


public class Utils {

    static {
        disableSslVerification();
    }

    private static void disableSslVerification() {
        try {
            // Create a trust manager that does not validate certificate chains
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager() {
                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }
            };
            // Install the all-trusting trust manager
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new java.security.SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());

            // Create all-trusting host name verifier
            HostnameVerifier allHostsValid = new HostnameVerifier() {
                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };

            // Install the all-trusting host verifier
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (KeyManagementException e) {
            e.printStackTrace();
        }
    }


    public static Map<String, String> postForEntity(String url, String requestBody, Map<String, String> apiHeader) {
        RestTemplate client = getRestTemplate();

        List<HttpMessageConverter<?>> httpMessageConverters = client.getMessageConverters();
        httpMessageConverters.stream().forEach(httpMessageConverter -> {
            if (httpMessageConverter instanceof StringHttpMessageConverter) {
                StringHttpMessageConverter messageConverter = (StringHttpMessageConverter) httpMessageConverter;
                messageConverter.setDefaultCharset(Charset.forName("UTF-8"));
            }
        });
        HttpHeaders headers = getHttpHeaders();

        // 以json的方式提交
        headers.setContentType(MediaType.APPLICATION_JSON);
        List<Charset> acceptCharset = Collections.singletonList(StandardCharsets.UTF_8);
        headers.setAcceptCharset(acceptCharset);
        headers.add("appid", apiHeader.get("appid"));
        headers.add("timestamp", apiHeader.get("timestamp"));
        headers.add("apisign", apiHeader.get("apisign"));

        // 将请求头部和参数合成一个请求
        HttpEntity<String> requestEntity = new HttpEntity<>(requestBody, headers);
        // 执行HTTP请求
        Map<String, String> response = client.postForEntity(url, requestEntity, Map.class).getBody();

        return response;
    }

    /**
     * 向指定URL发送POST方法的请求
     *
     * @param urls   发送请求的URL
     * @param params 请求参数，请求参数应该是 JSON 的形式。
     * @return URL 所代表远程资源的响应结果
     */
    public static Map<String, String> postString(String urls, String params, Map<String, String> headInfo) {
        HttpClient client = HttpClientBuilder.create().build();
        HttpPost post = new HttpPost(urls);
        String result = "";

        try {

            if (Objects.nonNull(headInfo)) {
                for (Map.Entry<String, String> entry : headInfo.entrySet()) {
                    post.setHeader(entry.getKey(), entry.getValue());
                }
            }

            StringEntity s = new StringEntity(params, "utf-8");
            s.setContentEncoding(new BasicHeader("Content-Type", "application/json"));
            post.setHeader("Content-Type", "application/json");
            post.setEntity(s);

            HttpResponse httpResponse = client.execute(post);
            InputStream inStream = httpResponse.getEntity().getContent();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inStream, "utf-8"));
            StringBuilder strber = new StringBuilder();
            String line = null;

            while ((line = reader.readLine()) != null) {
                strber.append(line + "\n");
            }

            inStream.close();
            result = strber.toString();

            //解析返回结果
            JSONObject jsonResult = JSONObject.parseObject(result);


            return JsonToMap(jsonResult);
        } catch (Exception var12) {
            var12.printStackTrace();
            throw new RuntimeException(var12);
        }
    }


    public static RestTemplate getRestTemplate() {
        return new RestTemplate();
    }

    public static HttpHeaders getHttpHeaders() {
        return new HttpHeaders();
    }

    public static Map<String, String> JsonToMap(JSONObject params) {
        Map<String, String> paramMap = new HashMap<>();
        //循环转换
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            paramMap.put(entry.getKey(), entry.getValue().toString());
        }

        return paramMap;
    }

    /**
     * 加载properties配置文件
     * @param propPath
     * @return
     */
    public static Properties loadProp(String propPath) {
        Properties props = new Properties();
        FileInputStream is = null;

        try {
            is = new FileInputStream(propPath);
            props.load(is);
            return props;
        } catch (Exception var13) {
            LogUtil.writeErrorLog("加载配置文件失败", var13);
        } finally {
            if (is != null) {
                try {
                    is.close();
                } catch (IOException var12) {
                    ;
                }
            }

        }
        return null;
    }


}
