package com.hand.app.cmb.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.chinapay.comm.Constants;
import com.chinapay.dto.HlsEbankCcbTransaction;
import com.chinapay.mapper.HlsEbankCcbTransactionMapper;
import com.chinapay.service.IHlsEbankCcbTransactionService;
import com.chinapay.util.StringUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.hand.app.cmb.dto.HlsEbankCmbTransqry;
import com.hand.app.cmb.dto.Ld037;
import com.hand.app.cmb.mapper.HlsEbankCmbTransqryMapper;
import com.hand.app.cmb.mapper.Ld037Mapper;
import com.hand.app.cmb.service.HclcCmbPolyService;
import com.hand.app.cmb.util.MD5Utils;
import com.hand.app.cmb.util.SM2Util;
import com.hand.app.cmb.util.SignatureUtil;
import com.hand.app.cmb.util.Utils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hand.app.esignHclc.utils.SignHclcUtils;
import com.hand.app.zhongDengWang.dto.HlsWsRequests;
import com.hand.app.zhongDengWang.mapper.HlsWsRequestsMapper;
import com.hand.hap.core.IRequest;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import org.apache.poi.hssf.record.DVALRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class HclcCmbPolyServiceImpl implements HclcCmbPolyService {

    private static Properties pro = null;

    static {
        String path = Thread.currentThread().getContextClassLoader().getResource("").getPath().substring(1);
        pro = Utils.loadProp(path + "cmb.properties");
        if (Objects.isNull(pro)) {
            LoggerFactory.getLogger(HclcCmbPolyServiceImpl.class).error("配置文件初始化异常");
        }
    }

    /*接口区分*/
    public static final String getQrCode = "GET_QR_CODE";
    public static final String queryQrState = "QUERY_QR_STATE";
    public static final String closeOrder = "CLOSE_ORDER";

    /*交易订单事务状态*/
    public static final String tranSuccess = "SUCCESS";
    public static final String transNew = "NEW";
    public static final String transDeal = "DEAL";
    public static final String transFail = "FAIL";
    public static final String transClose = "CLOSED";

    /*交易结果状态*/
    public static final String orderSuccess = "S";
    public static final String orderFail = "F";
    public static final String orderDelete = "D";
    public static final String orderCancel = "C";
    public static final String orderPass = "P";
    public static final String orderNo = "N";


    @Autowired
    private HlsEbankCcbTransactionMapper hlsEbankCcbTransactionMapper;
    @Autowired
    private IHlsEbankCcbTransactionService hlsEbankCcbTransactionService;
    @Autowired
    private HlsWsRequestsMapper hlsWsRequestsMapper;
    @Autowired
    private Ld037Mapper ld037Mapper;
    @Autowired
    private HlsEbankCmbTransqryMapper hlsEbankCmbTransqryMapper;
    @Autowired
    IHapInterfaceHeaderService headerService;
    @Autowired
    private DataSourceTransactionManager transactionManager;

    private Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public JSONObject getQrcode(IRequest iRequest, JSONObject params) {
        JSONObject result = new JSONObject();
        String resultType = "-1";
        String errorCd = null;

        if (Objects.isNull(params.get("recamt_id"))) {
            result.put(Constants.RESP_CODE, "E");
            result.put("respMsg", "请求必须参数recamt_id缺失，请检查！");
            return result;
        }

        //根据recamt_id查询ld037数据生成hls_ebank_ccb_transaction批次记录
        Long recamtId = params.getLong("recamt_id");
        Ld037 ld037 = new Ld037();
        ld037.setId(recamtId);
        ld037 = ld037Mapper.selectByPrimaryKey(ld037);

        if (Objects.nonNull(ld037.getReceiptstatus())) {
            result.put(Constants.RESP_CODE, "E");
            result.put("respMsg", "支付订单状态异常，请检查！");
            return result;
        }

        HlsEbankCcbTransaction hlsEbankCcbTransaction = createTransaction(iRequest, ld037);
        ld037.setTransactionId(hlsEbankCcbTransaction.getTransactionId());

        //生成单据编号 日期+id
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        String dateString = formatter.format(new Date());
        hlsEbankCcbTransaction.setTransactionNumber(dateString + String.format("%08d", hlsEbankCcbTransaction.getTransactionId()));

        Map<String, String> response = null;

        try {
            // 组装requestBody并加签
            String signResult = getQrRequestParams(hlsEbankCcbTransaction, ld037);
            if (Objects.isNull(signResult)) {
                throw new Exception("加签发生异常");
            }

            ObjectMapper mapper = new ObjectMapper();
            Map<String, String> signResultMap = mapper.readValue(signResult, Map.class);
            long currentTimeMills = System.currentTimeMillis() / 1000;

            // 组apiSign加密Map
            Map<String, String> apiSign = new TreeMap<>();
            apiSign.put("appid", pro.getProperty("cmb.appId"));
            apiSign.put("secret", pro.getProperty("cmb.appSecret"));
            apiSign.put("sign", signResultMap.get("sign"));
            apiSign.put("timestamp", "" + currentTimeMills);

            // MD5加密
            String MD5Content = SignatureUtil.getSignContent(apiSign);
            String apiSignString = MD5Utils.getMD5Content(MD5Content).toLowerCase();

            // 组request头部Map
            Map<String, String> apiHeader = new HashMap<>();
            apiHeader.put("appid", pro.getProperty("cmb.appId"));
            apiHeader.put("timestamp", "" + currentTimeMills);
            apiHeader.put("apisign", apiSignString);

            //初始化日志
            HlsWsRequests hlsWsRequests = logInterfaceRequest(getQrCode, pro.getProperty("cmb.qrCodeapplyUrl"), mapper.writeValueAsString(apiHeader), hlsEbankCcbTransaction.getTransactionId());
            logger.info("发送收款码申请请求,请求参数: {}", mapper.writeValueAsString(apiHeader));

            try {
                // 发送HTTP post请求
                response = Utils.postForEntity(pro.getProperty("cmb.qrCodeapplyUrl"), signResult, apiHeader);

                //处理接口日志
                logger.info("收款码申请返回结果：" + mapper.writeValueAsString(response));
                hlsWsRequests.setResponseClob(mapper.writeValueAsString(response));
                hlsWsRequests.setReturnStatus("S");
                hlsWsRequests.setResponsedDate(new Date());

                // 返回结果验签,验证数据的正确性（安全性）
                Boolean checkResult1 = checkSign(mapper.writeValueAsString(response));

                //数据验签成功
                if (checkResult1) {
                    //获取返回码,返回码不为SUCCESS表示报文内的字段不符合规范
                    String returnCode = response.get("returnCode");
                    if ("SUCCESS".equalsIgnoreCase(returnCode)) {
                        //响应码
                        String respCode = response.get("respCode");
                        if ("SUCCESS".equalsIgnoreCase(respCode)) {
                            resultType = "1";
                        } else {
                            resultType = "2";
                        }
                    } else {
                        resultType = "3";
                    }

                    if (!"1".equalsIgnoreCase(resultType)) {
                        //更新现金事务表ld037失败处理
                        errorCd = response.get("errCode");
                    }
                }
                //数据验签失败
                else {
                    //更新现金事务表ld037失败处理
                    errorCd = "SIGN_ERROR";

                    //直接返回前端验签失败信息，重发或者直接告诉前端发送失败
                    resultType = "4";
                }
            } catch (Exception e) {
                e.printStackTrace();
                logger.info("发送请求异常: {} ", e.getMessage());

                //更新现金事务表ld037失败处理
                errorCd = "SEND_ERROR";

                //处理接口日志
                hlsWsRequests.setReturnStatus("E");
                hlsWsRequests.setResponsedDate(new Date());

                //请求批次事务表状态更新失败处理
                hlsEbankCcbTransaction.setReturnMsg("发送请求异常,请查看日志");
                result.put(Constants.RESP_MSG, "发送请求异常,请查看日志！");
                resultType = "5";
            }

            hlsWsRequestsMapper.updateByPrimaryKeySelective(hlsWsRequests);
        } catch (Exception e) {
            e.printStackTrace();
            logger.info("组装请求报文信息失败: {} ", e.getMessage());

            //请求批次事务表状态更新失败处理
            hlsEbankCcbTransaction.setReturnMsg("组装请求报文信息失败,请查看日志");
            result.put(Constants.RESP_MSG, "组装请求报文信息失败,请查看日志！");

            errorCd = "MESSAGE_ERROR";
            resultType = "5";
        }

        hlsEbankCcbTransaction = setEbankTransaction(hlsEbankCcbTransaction, response, resultType);
        hlsEbankCcbTransactionMapper.updateByPrimaryKey(hlsEbankCcbTransaction);

        //更新现金事务表ld037失败处理
        if (Objects.nonNull(errorCd)) {
            updateLd037Fail(ld037, errorCd);
        } else {
            ld037Mapper.updateByPrimaryKeySelective(ld037);
        }

        result = putResult(result, response, resultType);
        return result;
    }

    private JSONObject putResult(JSONObject result, Map<String, String> response, String type) {
        //接口请求成功
        if ("1".equalsIgnoreCase(type)) {
            JSONObject bizContent = new JSONObject();
            bizContent = JSONObject.parseObject(response.get("biz_content").toString());
            result.put(Constants.RESP_CODE, response.get("returnCode"));
            result.put(Constants.RESP_MSG, "请求成功");
            //测试环境处理，生产需要还原
            result.put("qrCode", bizContent.getString("qrCode").replace("https://qr.95516.com/", "http://payment-uat.cs.cmburl.cn/"));
            result.put("cmbOrderId", bizContent.getString("cmbOrderId"));
            result.put("txnTime", bizContent.getString("txnTime"));
        }
        //接口返回成功，响应失败
        else if ("2".equalsIgnoreCase(type) || "3".equalsIgnoreCase(type)) {
            result.put(Constants.RESP_CODE, response.get("errCode"));
            result.put(Constants.RESP_MSG, response.get("respMsg"));
        }
        //验签失败
        else if ("4".equalsIgnoreCase(type)) {
            result.put(Constants.RESP_CODE, transFail);
            result.put(Constants.RESP_MSG, "验签失败，请检查！");
        }
        //组装请求报文信息失败
        else if ("5".equalsIgnoreCase(type)) {
            result.put(Constants.RESP_CODE, transFail);
        }
        return result;
    }

    private HlsEbankCcbTransaction setEbankTransaction(HlsEbankCcbTransaction hlsEbankCcbTransaction, Map<String, String> response, String type) {
        //接口请求成功
        if ("1".equalsIgnoreCase(type)) {
            JSONObject bizContent = new JSONObject();
            bizContent = JSONObject.parseObject(response.get("biz_content").toString());
            hlsEbankCcbTransaction.setStatus(transDeal);
            hlsEbankCcbTransaction.setReturnCode(response.get("returnCode"));
            hlsEbankCcbTransaction.setReturnMsg("获取二维码成功");
            hlsEbankCcbTransaction.setQrCode(bizContent.getString("qrCode"));
            hlsEbankCcbTransaction.setCmbOrderId(bizContent.getString("cmbOrderId"));
            hlsEbankCcbTransaction.setTxnTime(bizContent.getString("txnTime"));
            hlsEbankCcbTransaction.setOrderStatus(orderPass);
        }
        //接口返回成功，响应失败
        else if ("2".equalsIgnoreCase(type)) {
            hlsEbankCcbTransaction.setStatus(transFail);
            hlsEbankCcbTransaction.setReturnCode(response.get("errCode"));
            hlsEbankCcbTransaction.setReturnMsg(response.get("respMsg"));
            hlsEbankCcbTransaction.setOrderStatus(orderFail);
        }
        //接口返回失败
        else if ("3".equalsIgnoreCase(type)) {
            hlsEbankCcbTransaction.setStatus(transFail);
            hlsEbankCcbTransaction.setReturnCode(response.get("errCode"));
            hlsEbankCcbTransaction.setReturnMsg(response.get("respMsg"));
            hlsEbankCcbTransaction.setOrderStatus(orderFail);
        }
        //验签失败
        else if ("4".equalsIgnoreCase(type)) {
            hlsEbankCcbTransaction.setStatus(transFail);
            hlsEbankCcbTransaction.setReturnCode("SIGN_ERROR");
            hlsEbankCcbTransaction.setReturnMsg("接口请求验签失败");
            hlsEbankCcbTransaction.setOrderStatus(orderFail);
        }
        //组装请求报文信息失败
        else if ("5".equalsIgnoreCase(type)) {
            hlsEbankCcbTransaction.setStatus(transFail);
            hlsEbankCcbTransaction.setReturnCode("SEND_ERROR");
            hlsEbankCcbTransaction.setOrderStatus(orderFail);
        }
        return hlsEbankCcbTransaction;
    }

    private void updateLd037Fail(Ld037 ld037, String errorCd) {
        ld037.setErrorcd(errorCd);
        ld037Mapper.updateLd037Fail(ld037);
    }

    //生成招行扫码交易业务批次数据
    private HlsEbankCcbTransaction createTransaction(IRequest iRequest, Ld037 ld037) {
        HlsEbankCcbTransaction ccbTransaction = new HlsEbankCcbTransaction();
        ccbTransaction.setMerId(pro.getProperty("cmb.mer.id"));
        ccbTransaction.setVersion(pro.getProperty("cmb.version"));
        ccbTransaction.setUserId(pro.getProperty("cmb.user.id"));
        ccbTransaction.setStatus(transNew);
        ccbTransaction.setBankType("CMB");
        ccbTransaction.setCount(1L);
        ccbTransaction.setAmount(ld037.getAmount());
        ccbTransaction.setNewDate(new Date());
        ccbTransaction.setCreatedBy(1L);
        ccbTransaction.setCreationDate(new Date());
        ccbTransaction.setLastUpdatedBy(1L);
        ccbTransaction.setTranDate(StringUtil.getRelevantDate(new Date()));
        ccbTransaction.setTranTime(StringUtil.getRelevantTime(new Date()));
        ccbTransaction.setTranType("APPLY");

        hlsEbankCcbTransactionMapper.insert(ccbTransaction);

//        //生成单据编号 日期+id
//        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
//        String dateString = formatter.format(new Date());
//        ccbTransaction.setTransactionNumber(dateString + String.format("%08d", ccbTransaction.getTransactionId()));
//        ccbTransaction = hlsEbankCcbTransactionService.updateByPrimaryKeySelective(iRequest, ccbTransaction);

        return hlsEbankCcbTransactionMapper.selectByPrimaryKey(ccbTransaction);
    }

    private String getQrRequestParams(HlsEbankCcbTransaction hlsEbankCcbTransaction, Ld037 ld037) {
        Map<String, String> requestPublicParams = new TreeMap<>();
        String requestStr = null;
        try {
            //公共请求参数
            requestPublicParams.put("version", pro.getProperty("cmb.version"));    //版本号，固定为0.0.1(必传字段)
            requestPublicParams.put("encoding", pro.getProperty("cmb.encoding"));   //编码方式，固定为UTF-8(必传)
            requestPublicParams.put("signMethod", pro.getProperty("cmb.signMethod"));    //签名方法，固定为02，表示签名方式为国密(必传)

            //业务要素
            Map<String, String> requestTransactionParams = new HashMap<>();
            requestTransactionParams.put("merId", hlsEbankCcbTransaction.getMerId());   //商户号(必传)
            requestTransactionParams.put("orderId", hlsEbankCcbTransaction.getTransactionNumber()); //商户订单号(必传)
            requestTransactionParams.put("userId", hlsEbankCcbTransaction.getUserId());   //收银员
            //            requestTransactionParams.put("termId", "00774411");  //终端号
            requestTransactionParams.put("payValidTime", pro.getProperty("cmb.payValidTime")); //支付有效时间,默认15分钟
            requestTransactionParams.put("notifyUrl", pro.getProperty("cmb.notifyUrl"));  //交易通知地址(必传)
            requestTransactionParams.put("mchReserved", "{\"recamt_id\":" + ld037.getId() + "}");  //保留字段

            BigDecimal a1 = new BigDecimal(Double.toString(hlsEbankCcbTransaction.getAmount()));
            BigDecimal b1 = new BigDecimal(Double.toString(100));
            requestTransactionParams.put("txnAmt", a1.multiply(b1).stripTrailingZeros().toPlainString());  //交易金额,单位为分(必传)
            requestTransactionParams.put("currencyCode", pro.getProperty("cmb.currencyCode"));    //交易币种，默认156，目前只支持人民币（156）
            requestTransactionParams.put("body", "聚合支付测试");   //商户号(必传)

            //商户保留域
            JSONObject mchReserved = new JSONObject();
            mchReserved.put("transactionId", hlsEbankCcbTransaction.getTransactionId());
            requestTransactionParams.put("tradeScene", "OFFLINE");   //交易场景

            ObjectMapper mapper = new ObjectMapper();
            requestPublicParams.put("biz_content", mapper.writeValueAsString(requestTransactionParams));

            logger.info("收款码申请加签前的报文内容:" + mapper.writeValueAsString(requestPublicParams));

            //对待加签内容进行排序拼接
            String signContent = SignatureUtil.getSignContent(requestPublicParams);
            //加签
            requestPublicParams.put("sign", SM2Util.sm2Sign(signContent, pro.getProperty("cmb.privateKey")));

            requestStr = mapper.writeValueAsString(requestPublicParams);
            logger.info("收款码申请加签后的报文内容：" + requestStr);
            return requestStr;

        } catch (Exception e) {
            logger.info("收款码申请加签发生异常：" + e.getMessage());
            e.printStackTrace();
            return requestStr;
        }
    }

    @Override
    public JSONObject queryOrderStatus(IRequest iRequest, JSONObject params) {
        //返回结果标志
        String resultType = null;
        JSONObject result = new JSONObject();
        //去ld037中查找对应的记录的receiptcfmstatus，
        if (Objects.isNull(params.get("recamt_id"))) {
            result.put(Constants.RESP_CODE, "E");
            result.put("respMsg", "请求必须参数recamt_id缺失，请检查！");
            return result;
        }

        //根据recamt_id查询ld037数据生成hls_ebank_ccb_transaction批次记录
        Long recamtId = params.getLong("recamt_id");
        Ld037 ld037 = new Ld037();
        ld037.setId(recamtId);
        ld037 = ld037Mapper.selectByPrimaryKey(ld037);

        //与查询二维码有区别，查询二维码时订单并未创建，但查询订单状态时，订单记录已经在数据库中有记录，
        // 所以只需要通过recamt_id在ld037表中查到对应的订单记录，
        // 然后通过ld037表中的transaction_id找到对应的hlsEbankCcbTransaction对象
        HlsEbankCcbTransaction hlsEbankCcbTransaction = new HlsEbankCcbTransaction();
        hlsEbankCcbTransaction.setTransactionId(ld037.getTransactionId());
        hlsEbankCcbTransaction = hlsEbankCcbTransactionMapper.selectByPrimaryKey(hlsEbankCcbTransaction);

        if (Objects.isNull(hlsEbankCcbTransaction) || "CMB".equalsIgnoreCase(hlsEbankCcbTransaction.getBankType())) {
            result.put(Constants.RESP_CODE, "S");
            result.put(Constants.RESP_MSG, "订单不存在");
            //给到前端订单的状态
            result.put("tradeState", orderNo);
            return result;
        }

        if (!transDeal.equalsIgnoreCase(hlsEbankCcbTransaction.getStatus())) {
            result.put(Constants.RESP_CODE, "S");
            result.put(Constants.RESP_MSG, "查询成功");
            //给到前端订单的状态
            result.put("tradeState", hlsEbankCcbTransaction.getOrderStatus());
            return result;
        }

        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        // 事务隔离级别：开启新事务
        def.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
        //对于每次请求都开启一个事物
        TransactionStatus transactionStatus = transactionManager.getTransaction(def);

        //创建订单查询记录
        HlsEbankCmbTransqry hlsEbankCmbTransqry = createTransqry(hlsEbankCcbTransaction.getTransactionId(), "GET");

        //生成单据编号 日期+id
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        String dateString = formatter.format(new Date());
        hlsEbankCmbTransqry.setTransqryNumber(dateString + String.format("%08d", hlsEbankCcbTransaction.getTransactionId()));

        Map<String, String> responseMap = null;
        try {
            String signResult = getOrderQueryParameter(hlsEbankCcbTransaction);
            if (Objects.isNull(signResult)) {
                throw new Exception("加签发生异常");
            }

            ObjectMapper mapper = new ObjectMapper();
            Map<String, String> signResultMap = mapper.readValue(signResult, Map.class);

            // 组apiSign加密Map
            Map<String, String> apiSign = new TreeMap<>();
            apiSign.put("appid", pro.getProperty("cmb.appId"));
            apiSign.put("secret", pro.getProperty("cmb.appSecret"));
            apiSign.put("sign", signResultMap.get("sign"));
            long currentTimeMills = System.currentTimeMillis() / 1000;
            apiSign.put("timestamp", "" + currentTimeMills);

            // MD5加密
            String MD5Content = SignatureUtil.getSignContent(apiSign);
            String apiSignString = MD5Utils.getMD5Content(MD5Content).toLowerCase();

            // 组request头部Map
            Map<String, String> apiHeader = new HashMap<>();
            apiHeader.put("appid", pro.getProperty("cmb.appId"));
            apiHeader.put("timestamp", "" + currentTimeMills);
            apiHeader.put("apisign", apiSignString);

            //初始化日志
            HlsWsRequests hlsWsRequests = logInterfaceRequest(queryQrState, pro.getProperty("cmb.orderQueryUrl"), mapper.writeValueAsString(apiHeader), hlsEbankCcbTransaction.getTransactionId());
            try {
                //发送http请求
                responseMap = Utils.postForEntity(pro.getProperty("cmb.orderQueryUrl"), signResult, apiHeader);
                //处理接口日志
                logger.info("收款码申请返回结果：" + mapper.writeValueAsString(responseMap));
                hlsWsRequests.setResponseClob(mapper.writeValueAsString(responseMap));
                hlsWsRequests.setReturnStatus("S");

                //处理响应报文
                Boolean checkResponse = checkSign(mapper.writeValueAsString(responseMap));

                //数据验签成功
                if (checkResponse) {
                    //获取返回码,返回码不为SUCCESS表示报文内的字段不符合规范
                    String returnCode = responseMap.get("returnCode");
                    if ("SUCCESS".equalsIgnoreCase(returnCode)) {
                        //响应码
                        String respCode = responseMap.get("respCode");
                        if ("SUCCESS".equalsIgnoreCase(respCode)) {
                            //成功拿到订单状态请求的响应
                            hlsEbankCmbTransqry = finishTransaction(responseMap, hlsEbankCcbTransaction, hlsEbankCmbTransqry);
                            resultType = "7";

                        } else {
                            //ORDERID_INVALID 停止发起查询，调起关单
                            if ("ORDERID_INVALID".equalsIgnoreCase(responseMap.get("errCode"))) {
                                JSONObject closeResult = closeOrder(iRequest, params);
                                //订单关闭成功
                                if (tranSuccess.equalsIgnoreCase(closeResult.getString("respCode"))) {
                                    resultType = "1";
                                }
                                //订单关闭失败
                                else {
                                    resultType = "6";
                                }
                            } else {
                                //请求成功，但是响应结果为失败，传给前端失败原因就行
                                resultType = "2";
                            }
                        }
                    } else {
                        //返回码都失败
                        resultType = "3";
                    }
                }
                //数据验签失败
                else {
                    //直接返回前端验签失败信息，重发或者直接告诉前端发送失败
                    resultType = "4";
                }
            } catch (Exception e) {
                e.printStackTrace();
                logger.info("发送请求异常: {} ", e.getMessage());

                //处理接口日志
                hlsWsRequests.setReturnStatus("E");

                //请求批次事务表状态更新失败处理
                hlsEbankCmbTransqry.setRespMsg("发送请求异常,请查看日志");
                result.put(Constants.RESP_MSG, "发送请求异常，请查看日志！");

                resultType = "5";
            }

            //更新log日志表
            hlsWsRequests.setResponsedDate(new Date());
            hlsWsRequestsMapper.updateByPrimaryKeySelective(hlsWsRequests);

        } catch (Exception e) {
            e.printStackTrace();
            logger.info("组装请求报文信息失败: {} ", e.getMessage());

            //请求查询订单状态失败处理
            hlsEbankCmbTransqry.setRespMsg("组装请求报文信息失败，请查看日志");
            result.put(Constants.RESP_MSG, "组装请求报文信息失败，请查看日志！");

            resultType = "5";

        }

        //设置查询失败结果信息
        hlsEbankCmbTransqry = setEbankTransqry(hlsEbankCmbTransqry, responseMap, resultType);
        hlsEbankCmbTransqryMapper.updateByPrimaryKeySelective(hlsEbankCmbTransqry);

        //状态刷新
        transactionStatus.flush();
        //事务提交
        transactionManager.commit(transactionStatus);

        result = putResultQR(result, responseMap, resultType);

        if ("7".equalsIgnoreCase(resultType)) {
            JSONObject ld037Param = new JSONObject();
            ld037Param.put("transaction_id", hlsEbankCcbTransaction.getTransactionId());
            postWriteLd037(ld037Param);
        }

        return result;
    }

    //生成招行扫码交易业务批次数据
    private HlsEbankCmbTransqry createTransqry(Long transactionId, String queryCategory) {
        HlsEbankCmbTransqry cmbTransqry = new HlsEbankCmbTransqry();
        cmbTransqry.setMerId(pro.getProperty("cmb.mer.id"));
        cmbTransqry.setVersion(pro.getProperty("cmb.version"));
        cmbTransqry.setTransactionId(transactionId);
        cmbTransqry.setStatus(transNew);
        cmbTransqry.setCreatedBy(1L);
        cmbTransqry.setCreationDate(new Date());
        cmbTransqry.setLastUpdatedBy(1L);
        cmbTransqry.setQueryCategory(queryCategory);
        hlsEbankCmbTransqryMapper.insert(cmbTransqry);

        return hlsEbankCmbTransqryMapper.selectByPrimaryKey(cmbTransqry);
    }

    private String postWriteLd037(JSONObject params) {
        String sysName = "HCL_UPLOAD_FILE";
        String apiName = "writeOffLd037";
        try {

            //初始化接口信息
            HapInterfaceHeader headerAndLineDTO = headerService.getHeaderAndLine(sysName, apiName);
            if (headerAndLineDTO == null) {
                logger.info("headerAndLineDTO is null， apiName:{}, sysName:{}", apiName, sysName);
                return "N";
            }

            String url = headerAndLineDTO.getDomainUrl() + headerAndLineDTO.getIftUrl();

            Map<String, String> headInfo = new HashMap<String, String>();
            headInfo.put("Content-Type", "application/x-www-form-urlencoded");

            JSONObject requestData = new JSONObject();
            requestData.put("requestData", params.toString());

            //发送http请求
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.postString(url, requestData, headInfo, SignHclcUtils.APPLICATION_FORM_URLENCODED);

            //解析返回结果
            JSONObject jsonResult = JSONObject.parseObject(stringResult);
            if ("S".equalsIgnoreCase(jsonResult.getString("respCode"))) {
                return "Y";
            } else {
                return "N";
            }
        } catch (Exception e) {
            e.printStackTrace();
            return "N";
        }
    }

    //订单完成通用接口
    private HlsEbankCmbTransqry finishTransaction(Map<String, String> responseMap, HlsEbankCcbTransaction hlsEbankCcbTransaction, HlsEbankCmbTransqry hlsEbankCmbTransqry) {

        //更新交易事务表数据
        JSONObject bizContent = JSONObject.parseObject(responseMap.get("biz_content"));
        if (Objects.nonNull(bizContent.getString("tradeState"))) {
            if (!"P".equalsIgnoreCase(bizContent.getString("tradeState"))) {
                hlsEbankCcbTransaction.setStatus(tranSuccess);
                hlsEbankCcbTransaction.setSuccessDate(new Date());
            }
            if ("S".equalsIgnoreCase(bizContent.getString("tradeState"))) {
                hlsEbankCcbTransaction.setSuccessAmount(hlsEbankCcbTransaction.getAmount());
                hlsEbankCcbTransaction.setSuccessCount(hlsEbankCcbTransaction.getCount());
            }
        }
        hlsEbankCcbTransaction.setOrderStatus(bizContent.getString("tradeState"));
        hlsEbankCcbTransactionMapper.updateByPrimaryKeySelective(hlsEbankCcbTransaction);

        //更新查询表数据
        hlsEbankCmbTransqry.setReturnCode(responseMap.get("respCode"));
        hlsEbankCmbTransqry.setOrderId(bizContent.getString("orderId"));
        hlsEbankCmbTransqry.setCmbOrderId(bizContent.getString("cmbOrderId"));
        hlsEbankCmbTransqry.setRespCode(responseMap.get("respCode"));
        hlsEbankCmbTransqry.setTxnAmt(bizContent.getString("txnAmt"));
        hlsEbankCmbTransqry.setDscAmt(bizContent.getString("dscAmt"));
        hlsEbankCmbTransqry.setCurrencyCode(bizContent.getString("currencyCode"));
        hlsEbankCmbTransqry.setPayType(bizContent.getString("payType"));
        hlsEbankCmbTransqry.setOpenId(bizContent.getString("openId"));
        hlsEbankCmbTransqry.setPayBank(bizContent.getString("payBank"));
        hlsEbankCmbTransqry.setThirdOrderId(bizContent.getString("thirdOrderId"));
        hlsEbankCmbTransqry.setBuyerLogonId(bizContent.getString("buyerLogonId"));
        hlsEbankCmbTransqry.setTradeState(bizContent.getString("tradeState"));
        hlsEbankCmbTransqry.setTxnTime(bizContent.getString("txnTime"));
        hlsEbankCmbTransqry.setEndDate(bizContent.getString("endDate"));
        hlsEbankCmbTransqry.setEndTime(bizContent.getString("endTime"));
        hlsEbankCmbTransqry.setStatus("0000");

        return hlsEbankCmbTransqry;
    }

    /**
     * 封装请求参数，其中包含商户订单号，作为招行收到请求定位到对应订单的条件
     *
     * @param hlsEbankCcbTransaction
     * @return
     */
    private String getOrderQueryParameter(HlsEbankCcbTransaction hlsEbankCcbTransaction) {
        Map<String, String> requestPublicParams = new TreeMap<>();
        String requestStr = null;
        try {
            //公共请求参数
            requestPublicParams.put("version", pro.getProperty("cmb.version"));    //版本号，固定为0.0.1(必传字段)
            requestPublicParams.put("encoding", pro.getProperty("cmb.encoding"));   //编码方式，固定为UTF-8(必传)
            requestPublicParams.put("signMethod", pro.getProperty("cmb.signMethod"));    //签名方法，固定为02，表示签名方式为国密(必传)
            //业务要素
            Map<String, String> requestTransactionParams = new HashMap<>();
            requestTransactionParams.put("merId", hlsEbankCcbTransaction.getMerId());   //商户号(必传)
            requestTransactionParams.put("orderId", hlsEbankCcbTransaction.getTransactionNumber()); //商户订单号(必传)
            requestTransactionParams.put("cmbOrderId", hlsEbankCcbTransaction.getCmbOrderId()); //商户订单号(必传)
            requestTransactionParams.put("userId", hlsEbankCcbTransaction.getUserId());   //收银员

            ObjectMapper mapper = new ObjectMapper();
            requestPublicParams.put("biz_content", mapper.writeValueAsString(requestTransactionParams));

            logger.info("加签前的报文内容：" + mapper.writeValueAsString(requestPublicParams));

            //对待加签内容进行排序拼接
            String signContent = SignatureUtil.getSignContent(requestPublicParams);
            //加签
            requestPublicParams.put("sign", SM2Util.sm2Sign(signContent, pro.getProperty("cmb.privateKey")));

            requestStr = mapper.writeValueAsString(requestPublicParams);

            logger.info("加签后的报文内容：" + requestStr);

        } catch (Exception e) {
            logger.info("加签发生异常！" + e.getMessage());
            e.printStackTrace();
        }
        return requestStr;
    }


    /**
     * 封装交易表批次信息表
     *
     * @param hlsEbankCmbTransqry
     * @param response
     * @param type
     * @return
     */
    private HlsEbankCmbTransqry setEbankTransqry(HlsEbankCmbTransqry hlsEbankCmbTransqry, Map<String, String> response, String type) {
//        C - 订单已关闭
//        D - 交易已撤销
//        P - 交易在进行
//        F - 交易失败
//        S - 交易成功
//        R - 转入退款

        //接口返回成功，响应失败
        if ("1".equalsIgnoreCase(type) || "2".equalsIgnoreCase(type) || "6".equalsIgnoreCase(type)) {
            hlsEbankCmbTransqry.setReturnCode(response.get("returnCode"));
            hlsEbankCmbTransqry.setRespCode(response.get("respCode"));
            hlsEbankCmbTransqry.setErrCode(response.get("errCode"));
            hlsEbankCmbTransqry.setRespMsg(response.get("respMsg"));
            hlsEbankCmbTransqry.setErrDescription(response.get("errDescription"));
            hlsEbankCmbTransqry.setStatus("0000");
        }
        //接口返回失败
        else if ("3".equalsIgnoreCase(type)) {
            hlsEbankCmbTransqry.setReturnCode(response.get("returnCode"));
            hlsEbankCmbTransqry.setErrCode(response.get("errCode"));
            hlsEbankCmbTransqry.setRespMsg(response.get("respMsg"));
            hlsEbankCmbTransqry.setStatus("0000");
        }
        //验签失败
        else if ("4".equalsIgnoreCase(type)) {
            hlsEbankCmbTransqry.setReturnCode(transFail);
            hlsEbankCmbTransqry.setErrCode("SIGN_ERROR");
            hlsEbankCmbTransqry.setRespMsg("接口请求验签失败");
            hlsEbankCmbTransqry.setStatus("0003");
        }
        //组装请求报文信息失败
        else if ("5".equalsIgnoreCase(type)) {
            hlsEbankCmbTransqry.setReturnCode(transFail);
            hlsEbankCmbTransqry.setErrCode("SEND_ERROR");
            hlsEbankCmbTransqry.setStatus("0003");
        }

        return hlsEbankCmbTransqry;
    }

    /**
     * 封装给前端的返回结果
     *
     * @param result
     * @param response
     * @param type
     * @return
     */
    private JSONObject putResultQR(JSONObject result, Map<String, String> response, String type) {
        //接口请求成功
        if ("1".equalsIgnoreCase(type)) {
            result.put(Constants.RESP_CODE, tranSuccess);
            result.put(Constants.RESP_MSG, "订单已关闭");
            //给到前端订单的状态
            result.put("tradeState", orderCancel);
        }
        //接口返回成功，响应失败
        else if ("2".equalsIgnoreCase(type) || "3".equalsIgnoreCase(type) || "6".equalsIgnoreCase(type)) {
            result.put(Constants.RESP_CODE, response.get("errCode"));
            result.put(Constants.RESP_MSG, response.get("respMsg"));
        }
        //验签失败
        else if ("4".equalsIgnoreCase(type)) {
            result.put(Constants.RESP_CODE, transFail);
            result.put(Constants.RESP_MSG, "验签失败！");
        }
        //组装请求报文信息失败
        else if ("5".equalsIgnoreCase(type)) {
            result.put(Constants.RESP_CODE, transFail);
        } else if ("7".equalsIgnoreCase(type)) {
            result.put(Constants.RESP_CODE, tranSuccess);
            result.put(Constants.RESP_MSG, "查询成功");
            //给到前端订单的状态
            result.put("tradeState", JSONObject.parseObject(response.get("biz_content")).getString("tradeState"));
        }
        return result;
    }

    @Override
    public Map<String, String> orderNotify(IRequest iRequest, JSONObject params) {
        JSONObject result = new JSONObject();
        System.out.println(params);
        String requestBodyString = params.toJSONString();
        Map<String, String> respData = new HashMap<>();

        //设置响应数据
        respData.put("version", pro.getProperty("cmb.version"));//版本号，固定为0.0.1(必传)
        respData.put("encoding", pro.getProperty("cmb.encoding"));//编码方式，固定为UTF-8(必传)
        respData.put("signMethod", pro.getProperty("cmb.signMethod"));//签名方法，固定为02，国密
        try {
            respData.put("returnCode", "SUCCESS"); //SUCCESS表示商户接收通知成功并校验成功
            //非空校验
            if (requestBodyString == null || "".equals(requestBodyString.trim())) {
                respData.put("returnCode", "FAIL");
                return respData;
            }
            Map<String, String> requestBodyMap = str2Map(requestBodyString);
            Map<String, String> resultMap = requestBodyMap.entrySet().stream().collect(Collectors.toMap(e -> SignatureUtil.decode(e.getKey()), e -> SignatureUtil.decode(e.getValue())));
            if (resultMap == null) {
                respData.put("returnCode", "FAIL");
                return respData;
            }
            String sign = resultMap.remove("sign");
            //对待加签内容进行排序拼接
            String contentStr = SignatureUtil.getSignContent(resultMap);
            //验证签名-使用招行公钥进行验签
            boolean flag = SM2Util.sm2Check(contentStr, sign, pro.getProperty("cmb.publicKey"));
            if (!flag) {
                //验签失败
                System.out.println("验签失败");
                respData.put("returnCode", "FAIL");
                return respData;
            }
            System.out.println("验签成功");

            Long recamtId = params.getLong("mchReserved");
            Ld037 ld037 = new Ld037();
            ld037.setId(recamtId);
            ld037 = ld037Mapper.selectByPrimaryKey(ld037);

            /*对请求结果进行保存*/

            HlsEbankCcbTransaction hlsEbankCcbTransaction = hlsEbankCcbTransactionMapper.selectByPrimaryKey(ld037.getTransactionId());
            //创建订单查询记录
            HlsEbankCmbTransqry hlsEbankCmbTransqry = createTransqry(hlsEbankCcbTransaction.getTransactionId(), "POST");
            //生成单据编号 日期+id
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            String dateString = formatter.format(new Date());
            hlsEbankCmbTransqry.setTransqryNumber(dateString + String.format("%08d", hlsEbankCcbTransaction.getTransactionId()));
            hlsEbankCmbTransqry = finishTransaction(resultMap,hlsEbankCcbTransaction,hlsEbankCmbTransqry);
            hlsEbankCmbTransqryMapper.updateByPrimaryKey(hlsEbankCmbTransqry);
           hlsWsRequestsMapper.updateByPrimaryKey(logInterfaceRequest(queryQrState, pro.getProperty("cmb.server"), new ObjectMapper().writeValueAsString(respData), hlsEbankCcbTransaction.getTransactionId()));
            respData.put("respCode", "SUCCESS");//业务错误码，成功为SUCCESS，失败为FAIL
            /*如果处理自身业务逻辑发生错误，返回
            respData.put("respCode","FAIL");
            respData.put("respMsg","error_msg");
             */
            //对待加签内容进行排序拼接
            String signContent = SignatureUtil.getSignContent(respData);
            //加签-使用商户私钥加签
            respData.put("sign", SM2Util.sm2Sign(signContent, pro.getProperty("cmb.privateKey")));
            return respData;
        } catch (Exception e) {
            e.printStackTrace();
            respData.put("returnCode", "FAIL");
            return respData;
        }
    }

    @Override
    public JSONObject closeOrder(IRequest iRequest, JSONObject params) {
        JSONObject result = new JSONObject();
        if (Objects.isNull(params.get("recamt_id"))) {
            result.put(Constants.RESP_CODE, "E");
            result.put("respMsg", "请求必须参数recamt_id缺失，请检查！");
            return result;
        }

        //根据recamt_id查询ld037数据生成hls_ebank_ccb_transaction批次记录
        Long recamtId = params.getLong("recamt_id");
        Ld037 ld037 = new Ld037();
        ld037.setId(recamtId);
        ld037 = ld037Mapper.selectByPrimaryKey(ld037);
        HlsEbankCcbTransaction hlsEbankCcbTransaction = hlsEbankCcbTransactionMapper.selectByPrimaryKey(ld037.getTransactionId());
        /**
         * 支付成功的订单不允许关单，需要修改返回代码
         */
        if ("SUCCESS".equalsIgnoreCase(hlsEbankCcbTransaction.getStatus())) {
            result.put(Constants.RESP_CODE, "E");
            result.put("respMsg", "订单已经支付成功！");
            return result;
        }

        //开始封装请求部分
        String signResult = getOrderCloseParameter(hlsEbankCcbTransaction);
        ObjectMapper mapper = new ObjectMapper();

        Map<String, String> apiHeader = null;
        try {
            Map<String, String> signResultMap = mapper.readValue(signResult, Map.class);
            long currentTimeMills = System.currentTimeMillis() / 1000;

            // 组apiSign加密Map
            Map<String, String> apiSign = new TreeMap<>();
            apiSign.put("appid", pro.getProperty("cmb.appId"));
            apiSign.put("secret", pro.getProperty("cmb.privateKey"));
            apiSign.put("sign", signResultMap.get("sign"));
            apiSign.put("timestamp", "" + currentTimeMills);

            // MD5加密
            String MD5Content = SignatureUtil.getSignContent(apiSign);
            String apiSignString = MD5Utils.getMD5Content(MD5Content).toLowerCase();

            // 组request头部Map
            apiHeader = new HashMap<>();
            apiHeader.put("appid", pro.getProperty("cmb.appId"));
            apiHeader.put("timestamp", "" + currentTimeMills);
            apiHeader.put("apisign", apiSignString);

        } catch (IOException e) {
            /// resultType = "5";
            e.printStackTrace();
        }
        HlsWsRequests hlsWsRequests = null;
        try {
            hlsWsRequests = logInterfaceRequest(closeOrder, pro.getProperty("cmb.closeUrl"), mapper.writeValueAsString(apiHeader), hlsEbankCcbTransaction.getTransactionId());
            Map<String, String> responseMap = Utils.postForEntity(pro.getProperty("cmb.closeUrl"), signResult, apiHeader);
            //处理响应报文
            Boolean checkResponse = checkSign(mapper.writeValueAsString(responseMap));
            //数据验签成功
            if (checkResponse) {
                hlsWsRequests.setResponseClob(mapper.writeValueAsString(responseMap));
                hlsWsRequests.setReturnStatus("S");
                hlsWsRequests.setResponsedDate(new Date());
                //获取返回码,返回码不为SUCCESS表示报文内的字段不符合规范
                String returnCode = responseMap.get("returnCode");
                if ("SUCCESS".equalsIgnoreCase(returnCode)) {
                    //响应码
                    String respCode = responseMap.get("respCode");
                    if ("ORDER_PAID".equalsIgnoreCase(respCode)) {
                        //需要调用退款接口
                        result.put(Constants.RESP_CODE, "E");
                        result.put("respMsg", "需要调用退款接口！");
                        return result;
                    } else if ("SUCCESS".equalsIgnoreCase(respCode)) {
                        //订单关闭成功
                        if ("C".equalsIgnoreCase(responseMap.get("closeState"))) {
                            hlsEbankCcbTransaction.setStatus(transClose);
                            hlsEbankCcbTransaction.setOrderStatus("C");
                            result.put(Constants.RESP_CODE, responseMap.get("respCode"));
                            result.put(Constants.RESP_MSG, "请求成功");
                            result.put("cmborderid", responseMap.get("origOrderId"));
                            result.put("closeState", responseMap.get("closeState"));
                            result.put("txnTime", responseMap.get("txnTime"));
                        }
                        //关单失败处理
                        else {
                            hlsEbankCcbTransaction.setOrderStatus("F");
                            result.put(Constants.RESP_CODE, responseMap.get("respCode"));
                            result.put(Constants.RESP_MSG, "请求成功");
                            result.put("cmborderid", responseMap.get("origOrderId"));
                            result.put("closeState", responseMap.get("closeState"));
                            result.put("txnTime", responseMap.get("txnTime"));
                        }
                    } else if ("SYSTERM_ERROR".equalsIgnoreCase(respCode)) {
                        //请求成功，但是响应结果为失败，传给前端失败原因就行
                        result.put(Constants.RESP_CODE, "E");
                        result.put("respMsg", "需要重新调用查询接口！");
                    } else if ("FAIL".equalsIgnoreCase(respCode)) {
                        result.put("errCode", responseMap.get("errCode"));
                        result.put("respMsg", responseMap.get("respMsg"));
                    }
                } else {
                    //返回码都失败
                    result.put("errCode", responseMap.get("errCode"));
                    result.put("respMsg", responseMap.get("respMsg"));
                }
            }
        } catch (JsonProcessingException e) {
            result.put(Constants.RESP_CODE, "E");
            result.put("respMsg", "数据验签失败");
            hlsWsRequests.setReturnStatus("E");
            hlsWsRequests.setResponsedDate(new Date());
            e.printStackTrace();
        }
        hlsEbankCcbTransactionMapper.updateByPrimaryKey(hlsEbankCcbTransaction);
        return result;
    }

    private String getOrderCloseParameter(HlsEbankCcbTransaction hlsEbankCcbTransaction) {
        Map<String, String> requestPublicParams = new TreeMap<>();
        String requestStr = null;
        try {
            //公共请求参数
            requestPublicParams.put("version", pro.getProperty("cmb.version"));    //版本号，固定为0.0.1(必传字段)
            requestPublicParams.put("encoding", pro.getProperty("cmb.encoding"));   //编码方式，固定为UTF-8(必传)
            requestPublicParams.put("signMethod", pro.getProperty("cmb.signMethod"));    //签名方法，固定为02，表示签名方式为国密(必传)
            //业务要素
            Map<String, String> requestTransactionParams = new HashMap<>();
            requestTransactionParams.put("merId", hlsEbankCcbTransaction.getMerId());   //商户号(必传)
            requestTransactionParams.put("userId", hlsEbankCcbTransaction.getUserId());   //收银员
            ObjectMapper mapper = new ObjectMapper();
            requestPublicParams.put("biz_content", mapper.writeValueAsString(requestTransactionParams));
            requestTransactionParams.put("origOrderId", hlsEbankCcbTransaction.getTransactionNumber()); //商户订单号(必传)

            System.out.println("加签前的报文内容：" + mapper.writeValueAsString(requestPublicParams));

            //对待加签内容进行排序拼接
            String signContent = SignatureUtil.getSignContent(requestPublicParams);
            //加签
            requestPublicParams.put("sign", SM2Util.sm2Sign(signContent, pro.getProperty("cmb.privateKey")));

            requestStr = mapper.writeValueAsString(requestPublicParams);

            System.out.println("加签后的报文内容：" + requestStr);
            return requestStr;

        } catch (Exception e) {
            System.out.println("加签发生异常！");
            e.printStackTrace();
            return requestStr;
        }
    }


    private Map<String, String> str2Map(String str) {
        Map<String, String> result = new HashMap<>();
        String[] results = str.split("&");
        if (results != null && results.length > 0) {
            for (int var = 0; var < results.length; ++var) {
                String pair = results[var];
                String[] kv = pair.split("=", 2);
                if (kv != null && kv.length == 2) {
                    result.put(kv[0], kv[1]);
                }
            }
        }
        return result;
    }

    private Boolean checkSign(String string) {
        System.out.println("要验签的报文内容：" + string);
        try {
            //验签
            ObjectMapper objectMapper = new ObjectMapper();
            Map<String, String> responseBodyMap = objectMapper.readValue(string, Map.class);
            String sign = responseBodyMap.remove("sign");
            String contentStr = SignatureUtil.getSignContent(responseBodyMap);
            boolean result = SM2Util.sm2Check(contentStr, sign, pro.getProperty("cmb.publicKey"));

            if (result) {
                System.out.println("报文验签成功!");
            } else {
                System.out.println("报文验签失败!");
            }
            return result;
        } catch (Exception e) {
            System.out.println("验签发生异常！");
            e.printStackTrace();
            return false;
        }
    }

    public HlsWsRequests logInterfaceRequest(String functionName, String url, String request, Long pkValue) {

        HlsWsRequests hlsWsRequests = new HlsWsRequests();
        hlsWsRequests.setRequestDate(new Date());
        hlsWsRequests.setRequestWsdlUrl(url);
        hlsWsRequests.setFunctionName(functionName);

        String tableName = getTableName(functionName);
        hlsWsRequests.setTableName(tableName);
        hlsWsRequests.setStatusCode("1");
        hlsWsRequests.setStatusDate(new Date());
        hlsWsRequests.setPkValue(pkValue);
        hlsWsRequests.setRequestClob(request);
        hlsWsRequestsMapper.insertSelective(hlsWsRequests);

        return hlsWsRequests;
    }

    private String getTableName(String functionName) {
        String tableName = "";
        if ("GET_QR_CODE".equalsIgnoreCase(functionName)) {
            tableName = "HLS_EBANK_CCB_TRANSACTION";
        } else if ("QUERY_PAY_RESULT".equalsIgnoreCase(functionName)) {
            tableName = "HLS_EBANK_CMB_QUERY";
        }

        return tableName;

    }

}
