package com.hand.app.cmb.controllers;

import com.alibaba.fastjson.JSONObject;
import com.hand.app.cmb.service.HclcCmbPolyService;
import com.hand.app.esignHclc.service.ISignInfoHclcFaceService;
import com.hand.app.esignHclc.service.ISignInfoHclcService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: lsy
 * Date: 2020/2/25
 * Time: 21:32
 */
@Controller
public class HclcCmbPolyListenController extends BaseController {

    @Autowired
    private ISignInfoHclcFaceService iSignInfoHclcFaceService;
    @Autowired
    private ISignInfoHclcService iSignInfoHclcService;
    @Autowired
    private HclcCmbPolyService hclcCmbPolyService;


    /**
     * 暴露出去的回调地址，被动获取订单状态结果
     * @param request
     * @param params
     * @return
     */
    @ResponseBody
    @RequestMapping("core/api/public/cmb/get/qr/code/listen")
    public Map<String, String> orderStatusNotify(HttpServletRequest request,
                                                 @RequestBody(required = true) JSONObject params) {

        IRequest iRequest = createRequestContext(request);
        return hclcCmbPolyService.orderNotify(iRequest, params);
    }
}
