package com.hand.app.appManger.controllers;

import com.codahale.metrics.annotation.Timed;
import com.hand.app.appManger.dto.AppFunction;
import com.hand.app.appManger.service.IAppFunctionService;
import com.hand.app.appManger.service.IAppRoleFunctionService;
import com.hand.app.appManger.service.IRoleModuleService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * Created by Think-PC on 2018/3/14.
 */
@Controller
@RequestMapping(value = {"/r/api","/"})
public class AppFunctionController extends BaseController {
    @Autowired
    private IAppFunctionService appFunctionService;
    @Autowired
    private IAppRoleFunctionService appRoleFunctionService;
    @Autowired
    IRoleModuleService roleModuleService;

    @RequestMapping(value = "/app/addFunction", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public ResponseData addFunction(HttpServletRequest request, @RequestBody List<AppFunction> dto, BindingResult result) {
        getValidator().validate(dto, result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(getErrorMessage(result, request));
            return responseData;
        }
        IRequest requestCtx = createRequestContext(request);
        return  new ResponseData(appFunctionService.batchUpdate(requestCtx, dto));
        //return appFunctionService.insertSelective(createRequestContext(request), function);
    }

    @RequestMapping(value = "/app/deleteFunction", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public int deleteFunction(HttpServletRequest request, @RequestBody List<AppFunction> function) {
        return appFunctionService.batchDelete(function);
    }

    /**
     * 查询模块下的全部功能 包括未启用的
     * @param request
     * @return
     */
    @RequestMapping(value = "/app/query/moduleFunction", method = RequestMethod.GET)
    @ResponseBody
    @Timed
    public ResponseData queryModuleFunctionEnable(HttpServletRequest request, @RequestParam("moduleId") String moduleId) {
        return appRoleFunctionService.getModuleFunction(createRequestContext(request),moduleId);
    }

    /**
     * 查询模块下的全部功能
     * @param request
     * @return
     */
    @RequestMapping(value = "/app/queryModuleAllFunction", method = RequestMethod.GET)
    @ResponseBody
    @Timed
    public ResponseData queryModuleAllFunction(HttpServletRequest request, @RequestParam("moduleId") String moduleId) {
        return appRoleFunctionService.getModuleAllFunction(createRequestContext(request),moduleId);
    }
    /**
     * 查询角色的全部功能
     * @param request
     * @param roleCode
     * @return
     */
    @RequestMapping(value = "/app/queryFunction", method = RequestMethod.GET)
    @ResponseBody
    @Timed
    public ResponseData queryFunction(HttpServletRequest request, @RequestParam("roleCode") String roleCode,@RequestParam("appCode") String appCode) {
        return appRoleFunctionService.getFunctionAll(createRequestContext(request),roleCode,appCode);
    }

    /**
     * 查询角色下的模块
     * @param request
     * @param roleCode
     * @return
     */
    @RequestMapping(value = "/app/queryRoleModule", method = RequestMethod.GET)
    @ResponseBody
    @Timed
    public ResponseData queryRoleModule(HttpServletRequest request, @RequestParam("roleCode") String roleCode,@RequestParam("appCode") String appCode) {
        return roleModuleService.getRoleModule(createRequestContext(request), roleCode,appCode);
    }

    /**
     * 查询角色对应模块包含功能
     * @param request
     * @param roleCode
     * @return
     */
    @RequestMapping(value = "/app/queryModuleFunction", method = RequestMethod.GET)
    @ResponseBody
    @Timed
    public ResponseData queryModuleFunction(HttpServletRequest request, @RequestParam("roleCode") String roleCode,@RequestParam("appCode") String appCode) {
        return appFunctionService.getModuleFunction(createRequestContext(request),roleCode,appCode);
    }

    /**
     * 查询单个模块对应的功能
     * @param request
     * @param moduleId
     * @param roleCode
     * @return
     */
    @RequestMapping(value = "/app/querySingModuleFunction", method = RequestMethod.GET)
    @ResponseBody
    @Timed
    public ResponseData querySingModuleFunction(HttpServletRequest request, @RequestParam("moduleId") String moduleId, @RequestParam("roleCode") String roleCode,@RequestParam("appCode") String appCode) {
        return appRoleFunctionService.getSingModuleFunction(createRequestContext(request),moduleId,roleCode,appCode);
    }

}
