package com.hand.app.appManger.controllers;

import com.alibaba.fastjson.JSONObject;
import com.codahale.metrics.annotation.Timed;
import com.github.pagehelper.StringUtil;
import com.hand.app.appManger.bean.SmsInfo;
import com.hand.app.appManger.service.ICaptchaCodeService;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.service.IHapApiService;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import com.hand.hap.system.controllers.BaseController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/r/api"})
public class AppCaptchaController extends BaseController {
    private final Logger logger;

    @Autowired
    ICaptchaCodeService captchaCodeService;

    @Resource(name = "restBean")
    IHapApiService restService;

    @Autowired
    IHapInterfaceHeaderService headerService;

    public AppCaptchaController() {
        this.logger = LoggerFactory.getLogger(AppCaptchaController.class);
    }

    @ResponseBody
    @Timed
    @RequestMapping(value = "/aliyun/sms", method = RequestMethod.POST)

    public JSONObject sentAliyunMsm(HttpServletRequest request, @RequestBody SmsInfo smsInfo) {
        JSONObject json = new JSONObject();
        try {
            json = captchaCodeService.sendAliyunSms(createRequestContext(request), smsInfo);
        } catch (Exception e) {
            logger.error("something error!", e);
            json.put("result", "E");
            json.put("message", "短信发送失败");
        }
        return json;
    }

    @ResponseBody
    @Timed
    @RequestMapping(value = "/captcha/do", method = RequestMethod.POST)
    public JSONObject captchaDo(HttpServletRequest request, @RequestBody(required = false) JSONObject params)
            throws Exception {
        JSONObject json = new JSONObject();
        String captchaCode = request.getParameter("captchaCode");
        String captchaKey = request.getParameter("captchaKey");
        if ((StringUtils.isEmpty(captchaCode)) || (StringUtil.isEmpty(captchaKey)) || (!(this.captchaCodeService.checkCaptcha(captchaKey, captchaCode).booleanValue()))) {
            json.put("result", "E");
            json.put("message", "验证码错误");
        } else {
            String sysName = request.getParameter("sysName");
            String apiName = request.getParameter("apiName");
            this.logger.info("sysName:{}  apiName:{} ", sysName, apiName);
            this.logger.info("requestBody:{}", params);
            HapInterfaceHeader hapInterfaceHeader = this.headerService.getHeaderAndLine(sysName, apiName);
            this.logger.info("return HmsInterfaceHeader:{}", hapInterfaceHeader);
            if (hapInterfaceHeader.getInterfaceType().equals("REST")) {
                json = this.restService.invoke(hapInterfaceHeader, params);
            }
        }
        return json;
    }
}