/**
 * 项目名称(中文)
 * 项目名称(英文)
 * Copyright (c) 2016 ChinaPay Ltd. All Rights Reserved.
 */
package com.chinapay.util;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.chinapay.comm.Constants;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHeaders;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;

import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author hrtc .
 */
public class HttpUtils {

    /**
     * 超时时间 .
     */
    private static int SOCKET_TIMEOUT = 60000;
    /**
     * 连接超时时间 .
     */
    private static int CONNECT_TIMEOUT = 60000;

    private static Logger logger = LoggerFactory.getLogger(HttpUtils.class);

    /**
     * 发送http,注意如果调用频繁请自行改造成http连接池.
     *
     * @param url     请求地址
     * @param dataMap 请求map
     * @return 返回字符串
     */
    public static String send(String url, Map<String, String> dataMap) {
        CloseableHttpClient client = null;
        CloseableHttpResponse resp = null;
        try {
            client = HttpClients.custom().build();
            RequestConfig config = RequestConfig.custom()
                    .setSocketTimeout(SOCKET_TIMEOUT)
                    .setConnectTimeout(CONNECT_TIMEOUT)
                    .setAuthenticationEnabled(false).build();

            HttpPost post = new HttpPost(url);
            post.setProtocolVersion(org.apache.http.HttpVersion.HTTP_1_1);
            post.setConfig(config);

            HttpEntity entity = null;
            List<NameValuePair> formpair = new ArrayList<NameValuePair>();
            {
                for (String str : dataMap.keySet().toArray(
                        new String[dataMap.size()])) {
                    formpair.add(new BasicNameValuePair(str, dataMap.get(str)
                            .toString()));
                }
            }

            entity = new UrlEncodedFormEntity(formpair, Constants.ENCODING);
            if (entity != null) {
                post.setEntity(entity);
            }
            resp = client.execute(post);
            if (resp.getStatusLine().getStatusCode() == 200) {
                InputStream is = null;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    byte[] buffer = new byte[1024];
                    is = resp.getEntity().getContent();
                    int count = is.read(buffer);
                    while (count != -1) {
                        baos.write(buffer, 0, count);
                        count = is.read(buffer);
                    }
                    return baos.toString(Constants.ENCODING);
                } finally {
                    if (is != null) {
                        try {
                            is.close();
                        } finally {
                            // ignore
                        }
                    }
                    if (baos != null) {
                        try {
                            baos.close();
                        } finally {
                            // ignore
                        }
                    }
                }
            } else {
                throw new RuntimeException(String.format(
                        "发送请求失败,statusCode=%s", resp.getStatusLine()
                                .getStatusCode()));
            }

        } catch (ClientProtocolException e) {
            throw new RuntimeException(e.getMessage(), e);
        } catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        } finally {
            if (resp != null) {
                try {
                    resp.close();
                } catch (Exception e) {
                    // ignore
                }
            }
            if (client != null) {
                try {
                    client.close();
                } catch (Exception e) {
                    // ignore
                }
            }
        }
    }

    public static String sendJson(String url, JSONObject params, String charset) throws Exception {
        String result = "";
        // 字符集编码
        if (StringUtils.isBlank(charset)) {
            charset = Constants.ENCODING;
        }

        // 创建http POST请求
        CloseableHttpClient httpclient = null;
        HttpPost httpPost = new HttpPost(url);

        CloseableHttpResponse response = null;

        try {
            httpPost.setHeader(HttpHeaders.CONTENT_ENCODING, charset);
            httpPost.setHeader(HttpHeaders.CONTENT_TYPE, "application/x-www-form-urlencoded;charset=" + charset);

            List<NameValuePair> nameValuePairList = new ArrayList<NameValuePair>();
            for (String key : params.keySet()) {
                nameValuePairList.add(new BasicNameValuePair(key, params.get(key).toString()));
            }
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(nameValuePairList, "utf-8");
            formEntity.setContentType("application/x-www-form-urlencoded; charset=UTF-8");
            httpPost.setEntity(formEntity);

            // 设置参数
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            customReqConf.setSocketTimeout(SOCKET_TIMEOUT);
            customReqConf.setConnectTimeout(CONNECT_TIMEOUT);
            if (url.startsWith("https")) {
                SSLContext context = buildSSLContext();
                // 执行Https请求
                httpclient = HttpClientBuilder.create().setDefaultRequestConfig(customReqConf.build())
                        .setHostnameVerifier(new AllowAllHostnameVerifier())
                        .setSslcontext(context).build();
            } else {
                httpclient = HttpClientBuilder.create().setDefaultRequestConfig(customReqConf.build()).build();
            }

            response = httpclient.execute(httpPost);

            if (response != null) {
                logger.info("返回状态码:" + response.getStatusLine().getStatusCode());
                // 判断返回状态是否为200
                if (response.getStatusLine().getStatusCode() == 200) {
//                    logger.info("返回结果:" + EntityUtils.toString(response.getEntity(), charset));
                    result = getJsonStrByQueryUrl(EntityUtils.toString(response.getEntity(), charset));
                }
            } else {
                logger.info("发送无结果");
            }

        } catch (Exception e) {
            logger.error("发送失败", e);
            throw e;
        } finally {
            if (response != null) {
                try {
                    response.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }

            if (httpclient != null) {
                httpclient.close();
            }
        }

        return result;
    }

    public static String getJsonStrByQueryUrl(String paramStr) throws UnsupportedEncodingException {
        String[] params = paramStr.split("&");
        JSONObject obj = new JSONObject();
        for (int i = 0; i < params.length; i++) {
            String[] param = params[i].split("=");
            if (param.length >= 2) {
                String key = param[0];
                String value = URLDecoder.decode(param[1], "utf-8");
                for (int j = 2; j < param.length; j++) {
                    value += "=" + param[j];
                }
                try {
                    obj.put(key, value);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        return obj.toString();
    }


    /**
     * 构建SSL上下文.
     *
     * @return SSLContext
     * @author cp
     */
    private static SSLContext buildSSLContext() {
        try {
            SSLContext sslc = SSLContext.getInstance("TLS");
            sslc.init(null, createNonValidateTrustmanager(), null);

            return sslc;
        } catch (Exception ex) {
            logger.error("SSL上下文创建失败，请联系管理员.", ex);
        }
        return null;
    }

    /**
     * 信任一切证书.
     *
     * @return TrustManager[]
     * @author cp
     */
    private static TrustManager[] createNonValidateTrustmanager() {
        TrustManager[] trustAllCerts = new TrustManager[]{
                new X509TrustManager() {
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
        return trustAllCerts;
    }
}
