/**
 * Copyright (C), 2018-2021
 * FileName: HclcChinaPayController
 * Author:   lsy
 * Date:     2021/12/8 14:40
 * Description:
 * History:
 * <author>          <time>          <version>          <desc>
 * lishuangyi        修改时间           版本号              描述
 */
package com.chinapay.controllers;

import com.alibaba.fastjson.JSONObject;
import com.chinapay.service.IHclcChinaPayService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
/*
 * 〈〉
 *
 * @author 27214
 * @create 2021/12/8
 * @since 1.0.0
 */
@Controller
@RequestMapping(value = {"/r/api", "/"})
public class HclcChinaPayController extends BaseController {

    @Autowired
    IHclcChinaPayService hclcChinaPayService;

    /**
     * 4.4签约短信接口
     *
     * @param request
     * @param params  4.4签约短信接口
     * @return Map
     */
    @ResponseBody
    @RequestMapping("/china/pay/send/sign/message")
    public JSONObject sendSignMessage(HttpServletRequest request,
                                      @RequestBody(required = true) JSONObject params) {
        JSONObject jsonResult = new JSONObject();
        IRequest iRequest = createRequestContext(request);
        jsonResult = hclcChinaPayService.sendSignMessage(iRequest, params);
        return jsonResult;
    }


    /**
     * 4.5签约接口
     *
     * @param request
     * @param params  4.5签约接口
     * @return Map
     */
    @ResponseBody
    @RequestMapping("/china/pay/send/sign")
    public JSONObject sendSign(HttpServletRequest request,
                                      @RequestBody(required = true) JSONObject params) {
        JSONObject jsonResult = new JSONObject();
        IRequest iRequest = createRequestContext(request);
        jsonResult = hclcChinaPayService.sendSign(iRequest, params);
        return jsonResult;
    }

    /**
     * 4.9 批量交易文件上传接口
     *
     * @param request
     * @param params  4.9 批量交易文件上传接口
     * @return Map
     */
    @ResponseBody
    @RequestMapping("/china/pay/upload/batch")
    public JSONObject uploadBatch(HttpServletRequest request,
                               @RequestBody(required = true) JSONObject params) {
        JSONObject jsonResult = new JSONObject();
        IRequest iRequest = createRequestContext(request);
        jsonResult = hclcChinaPayService.uploadBatch(iRequest, params);
        return jsonResult;
    }

    /**
     * 4.11 批量交易回盘文件内容下载接口
     *
     * @param request
     * @param params  4.11 批量交易回盘文件内容下载接口
     * @return Map
     */
    @ResponseBody
    @RequestMapping("/china/pay/download/batch")
    public JSONObject downloadBatch(HttpServletRequest request,
                                  @RequestBody(required = true) JSONObject params) {
        JSONObject jsonResult = new JSONObject();
        IRequest iRequest = createRequestContext(request);
        jsonResult = hclcChinaPayService.downloadBatch(iRequest, params);
        return jsonResult;
    }

    /**
     * 4.12 批量交易文件查询接口
     *
     * @param request
     * @param params  4.12 批量交易文件查询接口
     * @return Map
     */
    @ResponseBody
    @RequestMapping("/china/pay/query/batch")
    public JSONObject queryBatch(HttpServletRequest request,
                                  @RequestBody(required = true) JSONObject params) {
        JSONObject jsonResult = new JSONObject();
        IRequest iRequest = createRequestContext(request);
        jsonResult = hclcChinaPayService.queryBatch(iRequest, params);
        return jsonResult;
    }
}