package com.chinapay.util;

import java.io.*;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.chinapay.comm.Constants;
import com.chinapay.secss.SecssConstants;
import com.chinapay.secss.SecssUtil;
import com.hand.hap.system.dto.BaseDTO;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.time.DateUtils;
import org.apache.http.HttpResponse;

/**
 * 字符串工具.
 *
 * @author hrtc
 * .
 */
public class StringUtil {
    /**
     * 判断字符串为空.
     *
     * @param str 字符串
     * @return 是否为空
     */
    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0 ? true : false;
    }

    /**
     * 判断字符串不为空.
     *
     * @param str 字符串
     * @return 是否不为空
     */
    public static boolean isNotEmpty(String str) {
        return !isEmpty(str);
    }

    /**
     * 获取传入时间所对应的年月日时间  .
     *
     * @param date 当前时间 .
     * @return 返回字符串格式 yyyyMMdd .
     */
    public static String getRelevantDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        String dateString = formatter.format(date);
        return dateString;
    }

    /**
     * 获取传入时间所对应的时分秒时间 .
     *
     * @param date 当前时间 .
     * @return 返回字符串格式 HHmmss .
     */
    public static String getRelevantTime(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("HHmmss");
        String dateString = formatter.format(date);
        return dateString;
    }

    /**
     * 获取传入时间所对应的时分秒时间 .
     *
     * @param date 当前时间 .
     * @return 返回字符串格式 yyyymmddhhmmss .
     */
    public static String getEntrstStrDtT(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateString = formatter.format(date);
        return dateString;
    }

    public static void main(String[] args) throws IOException {
//        String path = String.format("%s%s.properties", "F:\\work\\workspace\\IdeaProjects\\hls-support-rlwx\\key\\", "000092112092486");
//        SecssUtil secssUtil = new SecssUtil(true);
//        secssUtil.init(path);
//        Map<String, String> sendMap=new HashMap<String, String>();
//        sendMap.put("TranType","0101");
//        sendMap.put("AcqDate","20211222");
//        sendMap.put("AcqSeqId","202112220003958");
//        sendMap.put("BusiType","0001");
//        sendMap.put("Version","20140728");
////        sendMap.put("CardTranData","cVhbUCg8yizfv4CvpKsGbqfXpT08VpVF+31IU1eWkP5RIhLddaoOZ7ZSbdo01AVufwILglZQQZBbCTzKvwCdLM4NGSWXIW6sbIXvU24TLC6oETFM1/SAD8vaZW5+AwaD6O/khtC9H5zG2xGMCJ9sX2j+/0xNZ/WLsEi6ZAljwplU38LtY1DMJAieGqoNVPk370lwpCXa196v83H5eiD3XlYe3Hr/Qw5JQOwPj1WV/uHcCgS0wMeinLQ1yniOlTdMQWMeDy/6OubTFLhEXVIAk76SKH4uQsZP8Q3PnuIksxEqpf63RXBLaZp5E4Fuy35BkTgVke3ad437I++ZtO0h7w==");
////        sendMap.put("MerOrderNo","7F93B4C920A64B88A60B10E82D9712BE");
//        sendMap.put("MerBatchId","000001");
//        sendMap.put("OrderStatus","1015");
//        sendMap.put("MerId","000092112092486");
//        sendMap.put("respMsg","查询成功");
//        sendMap.put("TotalAmt","00000000000000000200");
//        sendMap.put("MerBatchDate","20211222");
//        sendMap.put("respCode","0000");
//
//        sendMap.put("Signature","d9sL1jRijMaaxchY 9AvYahuSNmO5QbcD/WAgMgqOzTxAwslITrDVW1lfEj9VealeJ4wmaOKttc ZaoxbfSqcDYX4DvvaTxqQ4BSO4EtgG5GrKQr8SxOx6QOat7J l7KNtbW3l4EkVsQJ0y0wF3ClBSaFkAaXdgLFIrNJ8QGtto1nbSYyEJBD06WXfpAtnsiqT3K95ETaUV6DivQYfV CoCfzlNfR1oZNfL6p zxALnwHLLyBTltcVAl pccxynFHVKlW1cS1wBbUxz9TCJr5YO1Q6kFI5dmxRtoXHckIooS7u9rSLWfRmEShm8yXLVDWRllo159uSGLPLaB2iSucA");
//        secssUtil.verify(sendMap);
//        System.out.println(secssUtil.getErrCode());
//        HttpUtils.getJsonStrByQueryUrl("BusiType=0001&TranType=0610&AcqCode=000000000000014&TranDate=20211222&Version=20140728&MerOrderNo=5F03D054A6ED4C9B90382CC11D555FC1&Signature=iVNHtphvHqGVxgwpNgEGGG5cmCjTlooDLveLlu%2FrTZH0gJbZ0xRbaFhxYd1NUSvyv7dLLL2v43FcnUnpPSJb8WXNPEVyXzZGvy1W1bYhyvksMFDIfn8Fmgg%2F6782efGfGanpWCs%2Bdcy2fvngNlN47aAwM8YkdlD8Q0hgLaOVhBehsf9ex1jAySCaHSu3mOp2fL%2B3kSlXQ7l3A5BT8iI4fydvXl9c0djeOMhk%2Bk5A2eVBYcTlMmvf7KaColVTKF5mbrMFYB8%2Bbl4qDxi77KYNnwb7g0GMU95xsgfGW03VxFdRiJvMfnNbjv7sVf35Uq9Eu8YBS%2B7fgUiQXOVLq7K7uA%3D%3D&MerId=000092112092486&respMsg=%E6%88%90%E5%8A%9F&TranTime=105332&AccessType=0&respCode=0000");
//        File file = new File("F:\\work\\workspace\\HCLC_Leasing\\运维\\运维报告\\日立建机新开项目2021\\银联代扣\\测试环境\\000092112092486_20211222_000001_Q.txt");
//        FileInputStream fi = new FileInputStream(file);
//        InputStreamReader reader = new InputStreamReader(fi, "UTF-8"); //最后的"GBK"根据文件属性而定，如果不行，改成"UTF-8"试试
//        BufferedReader br = new BufferedReader(reader);
//        String result = "";
//        String line;
//        while ((line = br.readLine()) != null) {
//            result+=line;
//            result+="\n";
//        }
//        br.close();
//        reader.close();
//
//        if (result.startsWith("\uFEFF")) {
//            result = result.substring(1);
//        }
//
//        String path = String.format("%s%s.properties", "F:\\work\\workspace\\IdeaProjects\\hls-support-rlwx\\key\\", "000092112092486");
//        SecssUtil secssUtil = new SecssUtil(true);
//        secssUtil.init(path);
//        String contentStr = secssUtil.encodeEnvelope(result.getBytes("UTF-8"));
//        Map<String, String> sendMap = new HashMap<String, String>();
//        sendMap.put("BusiType", "0001");
//        sendMap.put("Version", "20140728");
//        sendMap.put("MerId", "000092112092486");
//        sendMap.put("FileName", "000092112092486_20211222_000001_Q.txt");
//        sendMap.put("FileContent", contentStr);
//
//        secssUtil.sign(sendMap);
//        if (SecssConstants.SUCCESS.equals(secssUtil.getErrCode())) {
//            sendMap.put(Constants.SIGNATURE, secssUtil.getSign());
//        }
//        System.out.println(contentStr);

//        String fileData = "6226 0912 1056 2371";
//        fileData.trim();
//        String strCardTranData = null;
//        String path = String.format("%s%s.properties", "F:\\work\\workspace\\IdeaProjects\\hls-support-rlwx\\key\\", "000092112092486");
//        SecssUtil secssUtil = new SecssUtil(true);
//        secssUtil.init(path);

//        strCardTranData = "{\"AccName\":\"张博\",\"MobileNo\":\"18653352435\",\"CardNo\":\"6215686000014576697\",\"EntrstAuthNo\":\"370321199004060610\",\"EntrstAmtLmt\":\"50000000\",\"CertType\":\"01\",\"EntrstDtStp\":\"9999\",\"EntrstEndDtTm\":\"20320118202019\",\"CertNo\":\"370321199004060610\",\"EntrstStrDtTm\":\"20220118202019\",\"EntrstDtUnt\":\"07\"}";
//        // 加密
//        strCardTranData = Base64.encodeBase64String(strCardTranData.getBytes(Constants.ENCODING));
//        secssUtil.encryptData(strCardTranData);
//        Map<String, String> sendMap=new HashMap<String, String>();
//        sendMap.put("TranType","0608");
//        sendMap.put("BusiType","0001");
//        sendMap.put("Version","20140728");
//        sendMap.put("TranDate","20220119");
//        sendMap.put("CardTranData","i4T9Hpt/Qmkhh/xSzULM39qft9MS4KhMi+MQ3dvxJtbihUTlrk/xR1U8DhIAxvzsTVjINd14GbxYuXdG/N8cFZ15bHhDp89gkk6hvK9A+7l0WWNDnVlJWcLag0ERgA0v0FhXgfheqrMWuWnr9zrVp7yN+9SOs6XzTEUpN/ejhLd/nDkRBEyzJcPtxEWDB+M2KWOWLEjZf4L0NO3UN93ir7IvzoZmwzmwvpEW3Y4+sW9X9VMP8riaGnYV5VtoUvzUr55uBR6mIeuoqrZApvs0Pj8mJ687AvOz/yeyhlPvm1WMzjsrjPeztx1C3hstwwAEk9i6K3VjNkD2KaFwgFK1jcdTzqE5IqvXh5jRVlmBHaVnRzmfhBaZiFVvSkqbGdY90icPfDFhPR843ZsQOvO6Xul1fKfl5oH8UfASwqkCmYRKSnVwmK1oAN/QrOgNmTLBRuKY6F2qKLvX4ZJ784aqRimWVYLVdIknAj224MHoSG4bWRDIvu7kw2+tI9+wne1ng4t6KZtEreAL8BpDpvIVUhApKapf5l4T9qWS7BC8EFMIGSl5qyxi686C+EFRXSp9J9m6H3cia1Pad5URvkFItvSIhwyulL8pcUEnr0uIJdohJUHbuevCRVQEJffA1MSY0MEbYSRaMBzPfqqsORfRjGI+XO1Qwtq2rQw+ShXirlc=");
//        sendMap.put("MerOrderNo","F38CE3A782984D21AD8584238D40C890");
//        sendMap.put("MerId","739412105210001");
//        sendMap.put("TranTime","224028");
//        sendMap.put("AccessType","0");
//
//        secssUtil.sign(sendMap);
//        sendMap.put("Signature",secssUtil.getSign());
//
////        sendMap.put("Signature","zJ0CnwrHFzSL8OcAXI1YudMCHXLkB98P78JSBcCTmV4zhJIcgpGcgiKkrIdI4PXi5NUtJsxZ8S5bYbNE8XkWGQocfgDqwvzFGuU64adxxW6yNMNPg0Ug7TX6GOZatmGenLPL9YyyRxsIpUhPN2nDBYc4jCpAtMKYE/mCZLIvXdXyUnUgRD7D5KiXTN5Ka0QClmNQcmbiG22lMYb63i9fCJtcXeIK8FW0XiCbN1dv9ZSeMUgeXQzQWNQSRb5R8+GpWTpaTO4vHv+MEne9fW3p7ud33jhfwo/Cap5CdFyLU9r5kvk1sBx6XdOjDHuN84rK1nvaVaxqm9EdSEeck64rXw==");
//        secssUtil.verify(sendMap);
//        System.out.println(secssUtil.getErrCode());
//        System.out.println(secssUtil.getErrCode());
//        System.out.println(secssUtil.getEncValue());
            Double amount=106.02D;
            BigDecimal a1 = new BigDecimal(Double.toString(amount));
            BigDecimal b1 = new BigDecimal(Double.toString(100));
            System.out.println(a1.multiply(b1).longValue());
    }

    /**
     * 日期相加减
     *
     * @param time 时间字符串 yyyy-MM-dd HH:mm:ss
     * @param num  加的数，-num就是减去
     * @return 减去相应的数量的年的日期
     */
    public static String yearAddNum(Date time, Integer num) {
        //SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        //Date date = format.parse(time);

        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        calendar.add(Calendar.YEAR, num);
        Date newTime = calendar.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateString = formatter.format(newTime);
        return dateString;
    }

    /**
     * 字符串补位.
     *
     * @param val   字符串 .
     * @param type  r右补位l左补位 .
     * @param size  补足长度 .
     * @param delim 补位用字符串 .
     * @return String .
     */
    public static String pad(String val, String type, int size, String delim) {
        if (isEmpty(val)) return val;
        if ("r".equals(type)) {
            if (val.length() >= size) {
                return val.substring(0, size);
            } else {
                return val + repeat('r', delim, size - val.length());
            }
        } else {
            if (val.length() >= size) {
                return val.substring(val.length() - size);
            } else {
                return repeat('l', delim, size - val.length()) + val;
            }
        }
    }

    /**
     * 重复字符串 .
     *
     * @param type r右补位l左补位 .
     * @param val  字符串 .
     * @param len  长度 .
     * @return .
     */
    public static String repeat(char type, String val, int len) {
        if (isEmpty(val)) return val;
        StringBuffer tBuffer = new StringBuffer();
        while (tBuffer.length() < len) {
            tBuffer.append(val);
        }

        if ('r' == type) {
            return tBuffer.substring(0, len);
        } else {
            return tBuffer.substring(tBuffer.length() - len);
        }

    }

    /**
     * 解析map到str .
     *
     * @param dataMap map
     * @return 字符串
     */
    public static String paserMaptoStr(Map<String, Object> dataMap) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
            sb.append("&").append(entry.getKey()).append("=").append(entry.getValue());
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    /**
     * 解析响应字符串 .
     *
     * @param httpResonse http响应
     * @return 字符串
     * @throws IOException .
     */
    public static String parseResponseToStr(HttpResponse httpResonse) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(httpResonse.getEntity().getContent(), "utf-8"));
        StringBuffer sb = new StringBuffer();
        String str = null;
        while ((str = br.readLine()) != null) {
            sb.append(str);
        }
        return sb.toString();
    }

    /**
     * 将字符串转成map.
     *
     * @param respStr 字符串
     * @return map
     */
    public static Map<String, String> paserStrToMap(String respStr) {
        Map<String, String> data = new HashMap<String, String>();
        if (isNotEmpty(respStr)) {
            String[] strs = respStr.split("&");
            for (String str : strs) {
                if (isEmpty(str)) {
                    continue;
                }
                int index = str.indexOf("=");
//				if (entryStrs.length > 1) {
//					data.put(entryStrs[0], entryStrs[1]);
//				}
                data.put(str.substring(0, index), str.substring(index + 1));
            }
        }
        return data;
    }

    /**
     * 拼接在某属性的 set方法
     *
     * @param fieldName
     * @return String
     */
    public static String parSetName(String fieldName) {
        if (null == fieldName || "".equals(fieldName)) {
            return null;
        }
        int startIndex = 0;
        if (fieldName.charAt(0) == '_')
            startIndex = 1;
        return "set"
                + fieldName.substring(startIndex, startIndex + 1).toUpperCase()
                + fieldName.substring(startIndex + 1);
    }

    /**
     * 判断是否存在某属性的 set方法
     *
     * @param methods
     * @param fieldSetMet
     * @return boolean
     */
    public static boolean checkSetMet(Method[] methods, String fieldSetMet) {
        for (Method met : methods) {
            if (fieldSetMet.equals(met.getName())) {
                return true;
            }
        }
        return false;
    }

    //驼峰型转下划线
    public static String camel2Underline(String line) {
        if (line == null || "".equals(line)) {
            return "";
        }
        line = String.valueOf(line.charAt(0)).toUpperCase().concat(line.substring(1));
        StringBuffer sb = new StringBuffer();
        Pattern pattern = Pattern.compile("[A-Z]([a-z\\d]+)?");
        Matcher matcher = pattern.matcher(line);
        while (matcher.find()) {
            String word = matcher.group();
            sb.append(word.toUpperCase());
            sb.append(matcher.end() == line.length() ? "" : "_");
        }
        return sb.toString();
    }

    /**
     * 格式化string为Date
     *
     * @param datestr
     * @return date
     */
    public static Date parseDate(String datestr) {
        if (null == datestr || "".equals(datestr)) {
            return null;
        }
        try {
            String fmtstr = null;
            if (datestr.indexOf(':') > 0) {
                fmtstr = "yyyy-MM-dd HH:mm:ss";
            } else {
                fmtstr = "yyyy-MM-dd";
            }
            SimpleDateFormat sdf = new SimpleDateFormat(fmtstr, Locale.UK);
            return sdf.parse(datestr);
        } catch (Exception e) {
            //如果全是数字则为天数，通过天数转化日期
            Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
            if (pattern.matcher(datestr).matches()) {
                Calendar c = new GregorianCalendar(1900, 0, -1);

                Date d = c.getTime();
                Date _d = DateUtils.addDays(d, Integer.parseInt(datestr));  //42605是距离1900年1月1日的天数
                return _d;
            } else {
                return null;
            }

        }
    }

    /**
     * set属性的值到Bean,数值不做小数处理
     *
     * @param bean
     * @param valMap
     */
    public static void setFieldValue4Bean(Object bean, Map<String, String> valMap) {
        Class<?> cls = bean.getClass();
        for (; cls.getSuperclass() != null; cls = cls.getSuperclass()) {
            if (cls == BaseDTO.class) {
                break;
            }
            for (Field field : cls.getDeclaredFields()) {
                try {
                    String fieldSetName = parSetName(field.getName());
                    if (!checkSetMet(cls.getDeclaredMethods(), fieldSetName)) {
                        continue;
                    }
                    Method fieldSetMet = cls.getMethod(fieldSetName, field.getType());
                    String fieldKeyName = field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);

                    //不是统一用驼峰发命名的，因此在这里做格式化
                    if (Objects.nonNull(valMap.get(fieldKeyName))) {
                        String value = String.valueOf(valMap.get(fieldKeyName));
                        if (null != value && !"".equals(value)) {
                            String fieldType = field.getType().getSimpleName();
                            if ("String".equals(fieldType)) {
                                fieldSetMet.invoke(bean, value);
                            } else if ("Date".equals(fieldType)) {
                                Date temp = parseDate(value);
                                fieldSetMet.invoke(bean, temp);
                            } else if ("Integer".equals(fieldType)
                                    || "int".equals(fieldType)) {
                                Integer intval = Integer.parseInt(value);
                                fieldSetMet.invoke(bean, intval);
                            } else if ("Long".equalsIgnoreCase(fieldType)) {
                                Long temp = Long.parseLong(value);
                                fieldSetMet.invoke(bean, temp);
                            } else if ("Double".equalsIgnoreCase(fieldType)) {
                                Double temp = Double.parseDouble(value);
                                fieldSetMet.invoke(bean, temp);
                            } else if ("BigDecimal".equalsIgnoreCase(fieldType)) {
                                BigDecimal bigDecimal = new BigDecimal(value);
                                fieldSetMet.invoke(bean, bigDecimal);
                            } else if ("Boolean".equalsIgnoreCase(fieldType)) {
                                Boolean temp = Boolean.parseBoolean(value);
                                fieldSetMet.invoke(bean, temp);
                            } else {
                                System.out.println("not supper type" + fieldType);
                            }
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
    }
}
