-- Create table
DROP TABLE IF EXISTS NOTIFICATION_TEMPLATE;
create table NOTIFICATION_TEMPLATE
(
  TEMPLATE_ID  bigint(20) NOT NULL AUTO_INCREMENT COMMENT '数据库自增唯一id',
  CONTENT   text not null COMMENT '模板内容',
  TEMPLATE_NAME  VARCHAR(255) not null COMMENT '模板名称',
  TEMPLATE_CODE   VARCHAR(255) default null comment '模板代号',
  KEY_NAME       VARCHAR(255) default NULL comment '关键字',
  APP_ID         bigint(38) default null comment '微信应用的account_id',
  TAG_IDS varchar(255) DEFAULT '',
  TEMPLATE_KEY varchar(255) DEFAULT NULL comment '微信方的模板id',
  OBJECT_VERSION_NUMBER int(38) default 1,
  REQUEST_ID            int(38) default -1,
  PROGRAM_ID            int(38) default -1,
  CREATED_BY            int(38) default -1,
  CREATION_DATE         datetime default CURRENT_TIMESTAMP,
  LAST_UPDATED_BY       int(38) default -1,
  LAST_UPDATE_DATE      datetime default CURRENT_TIMESTAMP,
  LAST_UPDATE_LOGIN     int(38) default -1,
  PRIMARY KEY (TEMPLATE_ID)
) COMMENT = '微信模板消息模板';
