-- Create table
create table SIGN_INFO_HCLC
(
  OPEN_ID               VARCHAR2(30) not null,
  ID_NO                 VARCHAR2(30) not null,
  NAME                  VARCHAR2(200) not null,
  MOBILE                VARCHAR2(30) not null,
  EMAIL                 VARCHAR2(30),
  ORIGIN_ID             VARCHAR2(30),
  TITLE                 VARCHAR2(200),
  ADDRESS               VARCHAR2(300),
  ACCOUNT_ID            VARCHAR2(30),
  FACEAUTH_STATUS       VARCHAR2(30),
  CTITYPE               NUMBER,
  AGENT_TYPE            NUMBER,
  AGENT_ID_NO           VARCHAR2(30),
  AGENT_NAME            VARCHAR2(30),
  LEGAL_ID_NO           VARCHAR2(30),
  LEGAL_NAME            VARCHAR2(30),
  OBJECT_VERSION_NUMBER NUMBER(38) default 1,
  REQUEST_ID            NUMBER(38) default -1,
  PROGRAM_ID            NUMBER(38) default -1,
  CREATED_BY            NUMBER(38) default -1,
  CREATION_DATE         TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATED_BY       NUMBER(38) default -1,
  LAST_UPDATE_DATE      TIMESTAMP(6) default CURRENT_TIMESTAMP,
  LAST_UPDATE_LOGIN     NUMBER(38) default -1
);
-- Add comments to the columns 
comment on column SIGN_INFO_HCLC.OPEN_ID
  is '΢openid';
comment on column SIGN_INFO_HCLC.ID_NO
  is '֤ţ֯ţ';
comment on column SIGN_INFO_HCLC.NAME
  is 'ûƣ֯ƣ';
comment on column SIGN_INFO_HCLC.MOBILE
  is 'ֻ';
comment on column SIGN_INFO_HCLC.EMAIL
  is 'ʼ';
comment on column SIGN_INFO_HCLC.ORIGIN_ID
  is 'ԭʼûid';
comment on column SIGN_INFO_HCLC.CTITYPE
  is 'û(1-ˣ2-)';
comment on column SIGN_INFO_HCLC.AGENT_TYPE
  is '(1-֯Ա2-)';
comment on column SIGN_INFO_HCLC.AGENT_ID_NO
  is '֤';
comment on column SIGN_INFO_HCLC.AGENT_NAME
  is '';
comment on column SIGN_INFO_HCLC.LEGAL_ID_NO
  is '֤';
comment on column SIGN_INFO_HCLC.LEGAL_NAME
  is '';
-- Create/Recreate primary, unique and foreign key constraints 
alter table SIGN_INFO_HCLC
  add constraint SIGN_INFO_HCLC_PK primary key (OPEN_ID)
  using index;
-- Create/Recreate indexes 
create index SIGN_INFO_HCLC_N1 on SIGN_INFO_HCLC (ID_NO, OPEN_ID);
