package com.hand.hap.core.web.view.ui;

import com.hand.hap.core.web.view.ScreenBuilder;
import com.hand.hap.core.web.view.UITag;
import com.hand.hap.core.web.view.ViewContext;
import com.hand.hap.core.web.view.XMap;

import java.util.List;

@UITag
public class HlsRadioGroup extends Component implements HlsComponent {
    public static final String PROPERTITY_HLSRADIOGROUP = "hlsRadioGroup";
    public static final String PROPERTITY_WIDTH = "width";
    public static final String PROPERTITY_HEIGHT = "height";
    public static final String PROPERTITY_GROUPBODY = "groupBody";
    public static final String PROPERTITY_HLSCLASSNAME = "hlsClassName";

    public static HlsRadioGroup createInstance() {
        XMap view = new XMap(DEFAULT_TAG_PREFIX, DEFAULT_NAME_SPACE,
                PROPERTITY_HLSRADIOGROUP);
        HlsRadioGroup hlsRadioGroup = new HlsRadioGroup();
        hlsRadioGroup.initPrototype(view);
        return hlsRadioGroup;
    }

    public void setHlsClassName(String HlsClassName) {
        setPropertity(PROPERTITY_HLSCLASSNAME, HlsClassName);
    }

    @Override
    public void hlsSetPropertity(Object key, Object value) {
        super.setPropertity(key,value);
    }

    public String getHlsClassName() {
        return getPrototype().getString(PROPERTITY_HLSCLASSNAME);
    }

    public void setHeight(String height) {
        setPropertity(PROPERTITY_HEIGHT, height);
    }

    public String getHeight() {
        return getPrototype().getString(PROPERTITY_HEIGHT);
    }

    public void setWidth(String width) {
        setPropertity(PROPERTITY_WIDTH, width);
    }

    public String getWidth() {
        String width = getPrototype().getString(PROPERTITY_WIDTH);
        if (width == null) {
            width = "100%";
        }
        return width;
    }

    public void setBind(String bind){
        setPropertity(PROPERTITY_BIND, bind);
    }

    public String getBind(){
        return getPrototype().getString(PROPERTITY_BIND);
    }

    public String getGroupBody(ViewContext context) throws Exception {
        StringBuffer sb = new StringBuffer();
        List<XMap> list = getPrototype().getChildren();
        for (XMap map : list) {
            sb.append(ScreenBuilder.build(map, context));
        }
        return sb.toString();
    }


    public void init(XMap view, ViewContext context) throws Exception {
        super.init(view, context);
        context.put(PROPERTITY_HEIGHT, getHeight());
        context.put(PROPERTITY_WIDTH, getWidth());
        context.put(PROPERTITY_HLSCLASSNAME, getHlsClassName());
        context.put(PROPERTITY_GROUPBODY, getGroupBody(context));
        context.put(PROPERTITY_BINDMODEL, getHlsBindModel());
        context.put(PROPERTITY_BIND, getBind());
    }
}
