package com.hand.app.zhongDengWang.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.hand.app.zhongDengWang.service.IZdwWsRequestsService;
import com.hand.app.zhongDengWang.dto.ZdwLoginTokenInterface;
import com.hand.app.zhongDengWang.dto.FndZhongDengLines;
import com.hand.app.zhongDengWang.dto.FndZhongDengBatch;
import com.hand.app.zhongDengWang.dto.HlsWsRequests;
import com.hand.app.zhongDengWang.service.IZdwWsRequestsService;
import com.hand.app.zhongDengWang.service.IFndZhongDengLinesService;
import com.hand.app.zhongDengWang.mapper.ZdwLoginTokenInterfaceMapper;
import com.hand.app.zhongDengWang.mapper.FndZhongDengLinesMapper;
import com.hand.app.zhongDengWang.mapper.FndZhongDengBatchMapper;
import com.hand.app.zhongDengWang.utils.ClientUtils;
import com.hand.app.zhongDengWang.ws.init.WSInitRegisterService;
import com.hand.app.zhongDengWang.ws.init.WSInitRegisterServiceService;
import com.hand.app.zhongDengWang.ws.login.WSLoginService;
import com.hand.app.zhongDengWang.ws.login.WSLoginServiceService;
import com.hand.app.zhongDengWang.dto.FndAtmAttachmentDto;
import com.hand.app.zhongDengWang.mapper.FndAtmAttachmentMapper;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.DTOStatus;
import com.rfp.sm.utils.SM2Utils;
import org.json.XML;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@Service
public class ZdwWsRequestsServiceImpl implements IZdwWsRequestsService {

    @Autowired
    ZdwLoginTokenInterfaceMapper zdwLoginTokenInterfaceMapper;
    @Autowired
    FndZhongDengLinesMapper fndZhongDengLinesMapper;
    @Autowired
    IFndZhongDengLinesService fndZhongDengLinesService;
    @Autowired
    IZdwWsRequestsService zdwWsRequestsService;
    @Autowired
    FndAtmAttachmentMapper fndAtmAttachmentMapper;
    @Autowired
    FndZhongDengBatchMapper fndZhongDengBatchMapper;


    @Value("${zdw.login.clientKey}")
    private String clientKey;
    @Value("${zdw.login.userName}")
    private String userName;
    @Value("${zdw.login.password}")
    private String userPassword;
    @Value("${zdw.login.authCode}")
    private String platformAuthCode;

    private String loginToken;

    /**
     * 加密公钥 String clientKey
     * 用户名 String userName
     * 密码  String userPassword
     * 平台授权码 String platformAuthCode
     **/
    public static String clintLogin(String clientKey, String userName, String userPassword, String platformAuthCode) {
        String returnMsg = "";

        try {
            /*SM2算法加密*/
            userName = SM2Utils.encryptByKeyStr(userName, clientKey);
            userPassword = SM2Utils.encryptByKeyStr(userPassword, clientKey);
            platformAuthCode = SM2Utils.encryptByKeyStr(platformAuthCode, clientKey);
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        WSLoginServiceService service = new WSLoginServiceService();
        WSLoginService login = service.getWSLoginServicePort();
        try {
            byte[] returns = login.login(userName.getBytes(), userPassword.getBytes(), platformAuthCode.getBytes());
            returnMsg = new String(returns);
        } catch (Exception e) {
            e.printStackTrace();
            returnMsg = "LoginError";
        }
        System.out.println("token=" + returnMsg);
        return returnMsg;
    }

    private String getRegisterToken() {

        //获取token，后台设置每25分钟重置一次token
        ZdwLoginTokenInterface zdwLoginTokenInterface = new ZdwLoginTokenInterface();
        zdwLoginTokenInterface.setEnableFlag("Y");
        zdwLoginTokenInterface = zdwLoginTokenInterfaceMapper.selectOne(zdwLoginTokenInterface);

        String assesstoken = "";

        if (Objects.isNull(zdwLoginTokenInterface)) {
//            assesstoken = clintLogin(clientKey, userName, userPassword, platformAuthCode);
            assesstoken = "cs11111111";
            if (!assesstoken.contains("Error")) {
                zdwLoginTokenInterfaceMapper.updateToken(assesstoken);
            }
        } else {
            assesstoken = zdwLoginTokenInterface.getToken();
        }

        return assesstoken;
    }


    private HlsWsRequests createRequestLog(String wsdlUrl, String requestClob, Long pkValue) {
        HlsWsRequests hlsWsRequests = new HlsWsRequests();
        hlsWsRequests.setRequestDate(new Date());
        hlsWsRequests.setRequestWsdlUrl(wsdlUrl);
        hlsWsRequests.setFunctionName("INIT_REGISTER");
        hlsWsRequests.setReturnStatus("1");
        hlsWsRequests.setRequestClob(requestClob);
        hlsWsRequests.setStatusDate(new Date());
        hlsWsRequests.setParameterType("XML");
        hlsWsRequests.setPkValue(pkValue);

        return hlsWsRequests;
    }

    /***
     * 初始登记;
     * @param request
     * @param batchId
     ***/
    public JSONObject initRegisterService(IRequest request, Long batchId) {
        JSONObject resultJson = new JSONObject();

        /*根据批次ID获取所有上报请求id*/
        List<FndZhongDengBatch> fndZhongDengBatches = new ArrayList<>();
        FndZhongDengBatch fndZhongDengBatch = new FndZhongDengBatch();
        fndZhongDengBatch.setBatchId(batchId);
        fndZhongDengBatches = fndZhongDengBatchMapper.select(fndZhongDengBatch);


        if (fndZhongDengBatches.size() == 0) {
            resultJson.put("code", "000");
            resultJson.put("info", "000");
            return resultJson;
        }

        /*获取中登网登录loginToken*/
        loginToken = getRegisterToken();
        /*返回结果loginToken解析，如果返回异常退出当前请求*/
        if (loginToken.contains("Error")) {
            String errorCode = "-1";
            String errorInfo = "-1";
            if (errorCode.contains(":")) {
                errorCode = loginToken.split(":")[1];
                if (errorCode.contains("_")) {
                    errorCode = loginToken.split("_")[0];
                    errorInfo = loginToken.split("_")[1];
                }
            }

            resultJson.put("code", errorCode);
            resultJson.put("info", errorInfo);
        } else {

            List<FndZhongDengLines> fndZhongDengLinesList = new ArrayList<>();
            /*根据传入ids循环上报中登网*/
            for (FndZhongDengBatch batch : fndZhongDengBatches) {

                FndZhongDengLines fndZhongDengLines = new FndZhongDengLines();
                fndZhongDengLines.setLineId(batch.getLineId());
                fndZhongDengLines = fndZhongDengLinesMapper.selectByPrimaryKey(fndZhongDengLines);

                if (Objects.nonNull(fndZhongDengLines)) {
                    String xmlFileContent = "";
                    String encryXmlFileContent = "";
                    String attachmentZipPath = "";
                    try {
                        String registerResult = "";
                        String registerNumber = "";
                        String authorizationCode = "";
                        String error = "";
                        org.json.JSONObject returnJson;

                        FndAtmAttachmentDto fndAtmAttachmentDto = new FndAtmAttachmentDto();
                        fndAtmAttachmentDto.setAttachmentId(fndZhongDengLines.getAttachmentXmlId());
                        fndAtmAttachmentDto = fndAtmAttachmentMapper.selectByPrimaryKey(fndAtmAttachmentDto);

                        /*解析xml文件内容*/
                        xmlFileContent = new String(ClientUtils.getxmlFileContent(fndAtmAttachmentDto.getFilePath()));

                        /*SM2算法加密*/
                        loginToken = SM2Utils.encryptByKeyStr(loginToken, clientKey);
                        encryXmlFileContent = SM2Utils.encryptByKeyStr(xmlFileContent, clientKey);
                        platformAuthCode = SM2Utils.encryptByKeyStr(platformAuthCode, clientKey);

//                        WSInitRegisterServiceService service = new WSInitRegisterServiceService();
//                        WSInitRegisterService reg = service.getWSInitRegisterServicePort();

                        /*插入接口日志表*/
                        HlsWsRequests hlsWsRequests = createRequestLog("https://ws.zhongdengwang.org.cn/mfrs_ws_test/services/InitRegisterService?wsdl", xmlFileContent, batch.getLineId());
//                        byte[] returns = reg.initRegister(fndZhongDengLines.getTypebz().getBytes(), platformAuthCode.getBytes(), loginToken.getBytes(), "lr".getBytes(), encryXmlFileContent.getBytes(), ClientUtils.getAttachmentZip(attachmentZipPath));
                        byte[] returns = "<feedback>\n<registertype>LR</registertype>\n<registerresult>001</registerresult>\n<registernumber>I0000001</registernumber>\n<authorizationcode>A0000001</authorizationcode>\n<errors>\n<error>RegInfoError:100_001</error>\n</errors>\n</feedback>\n".getBytes();
                        hlsWsRequests.setResponseClob(new String(returns));

                        /*解析接口返回结果*/
                        returnJson = XML.toJSONObject(new String(returns));
                        registerResult = returnJson.getJSONObject("feedback").getString("registerresult");
                        registerNumber = returnJson.getJSONObject("feedback").getString("registernumber");
                        authorizationCode = returnJson.getJSONObject("feedback").getString("authorizationcode");

                        /*成功*/
                        if (Objects.nonNull(registerResult) && "001".equalsIgnoreCase(registerResult)) {
                            fndZhongDengLines.setRegisterNumber(registerNumber);
                            fndZhongDengLines.setAuthorizationCode(authorizationCode);
                            fndZhongDengLines.setUpStatus("SUCCESS");
                            fndZhongDengLines.setReturnMsg("上报成功");
                            hlsWsRequests.setReturnStatus("SUCCESS");
                            /*失败*/
                        } else {
                            error = returnJson.getJSONObject("feedback").getString("errors");
                            fndZhongDengLines.setUpStatus("FAIL");
                            fndZhongDengLines.setReturnMsg(error);
                            hlsWsRequests.setReturnStatus("FAIL");
                        }
                        hlsWsRequests.setResponsedDate(new Date());

                        fndZhongDengLines.setUpDate(new Date());
                        fndZhongDengLines.set__status(DTOStatus.UPDATE);

                        System.out.println("dddd" + new String(returns));
                    } catch (Exception e) {
                        // TODO Auto-generated catch block
                        e.printStackTrace();
                        fndZhongDengLines.setUpStatus("FAIL");
                        fndZhongDengLines.setReturnMsg(e.getMessage());
                    }

                    fndZhongDengLinesList.add(fndZhongDengLines);
                }


            }

            if (fndZhongDengLinesList.size() > 0) {
                fndZhongDengLinesService.batchUpdate(request, fndZhongDengLinesList);
            }

            resultJson.put("code", "000");
            resultJson.put("info", "000");
        }
        return resultJson;
    }
}