/**
 * Copyright (C), 2018-2021
 * FileName: ZdwWsRequestsController
 * Author:   lsy
 * Date:     2021/8/3 16:37
 * Description:
 * History:
 * <author>          <time>          <version>          <desc>
 * lishuangyi        修改时间           版本号              描述
 */
package com.hand.app.zhongDengWang.controllers;

import com.alibaba.fastjson.JSONObject;
import com.hand.app.zhongDengWang.service.IZdwWsRequestsService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/*
 * 〈〉
 *
 * @author 27214
 * @create 2021/8/3
 * @since 1.0.0
 */
@Controller
@RequestMapping(value = {"/r/api", "/"})
public class ZdwWsRequestsController extends BaseController {

    @Autowired
    private IZdwWsRequestsService service;


    /**
     * 初始登记
     **/
    @RequestMapping(value = "/zdw/service/register/init")
    @ResponseBody
    public JSONObject initRegister(HttpServletRequest request, @RequestBody Long batchId) {
        IRequest requestContext = createRequestContext(request);
        JSONObject resultJson = new JSONObject();
        resultJson = service.initRegisterService(requestContext, batchId);
        return resultJson;
    }

}