package com.hand.app.hms.service.impl;


import com.hand.app.hms.service.IWxService;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.DefaultValueProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

@Service
public class WxServiceImpl implements IWxService {

    private Logger logger = LoggerFactory.getLogger(WxServiceImpl.class);

    // 公用post方法
    @Override
    public JSONObject post(String body, String https_url) {
        // TODO Auto-generated method stub
        String retMsg;
        JSONObject json = null;
        OutputStream os = null;

        InputStream sendStatus = null;
        HttpURLConnection conn = null;
        try {
            URL url = new URL(https_url);
            conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-type", "application/json");
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(5000);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.connect();

            os = conn.getOutputStream();
            os.write(body.getBytes("UTF-8"));
            os.flush();

            sendStatus = conn.getInputStream();
            int size = sendStatus.available();
            byte[] jsonBytes = new byte[size];
            sendStatus.read(jsonBytes);
            retMsg = new String(jsonBytes, "UTF-8");
        } catch (Exception e) {
            logger.error("推送失败:" + body);
            e.printStackTrace();
            return null;
        } finally {
            try {
                sendStatus.close();
                os.close();
                conn.disconnect();
            } catch (IOException e) {
                logger.error("推送失败:" + body);
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.registerDefaultValueProcessor(String.class, new DefaultValueProcessor() {
            public Object getDefaultValue(Class type) {
                return JSONNull.getInstance();
            }
        });
        json = JSONObject.fromObject(retMsg, jsonConfig);
        return json;
    }
    @Override
    public JSONObject get(String https_url) {
        String resultData = "";
        JSONObject json = null;
        try {
            URL ServiceURL = new URL(https_url);
            HttpURLConnection httpURLConnection = (HttpURLConnection) ServiceURL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("Content-Type", "application/json");
            //httpURLConnection.setRequestProperty("Accept", headerAndLineDTO.getRequestAccept());
            httpURLConnection.connect();

            if (httpURLConnection.getResponseCode() != 200) {
                throw new RuntimeException("HTTP GET Request Failed with Error code : " + httpURLConnection.getResponseCode());
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "utf-8"));
            StringBuilder results = new StringBuilder();
            String line;
            while ((line = reader.readLine()) != null) {
                results.append(line);
            }
            reader.close();
            resultData = results.toString();

            httpURLConnection.disconnect();


        } catch (MalformedURLException e) {
            e.printStackTrace();
            logger.error(e.getMessage());

        } catch (IOException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
        logger.info("responseData:{}", resultData);

        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.registerDefaultValueProcessor(String.class, new DefaultValueProcessor() {
            public Object getDefaultValue(Class type) {
                return JSONNull.getInstance();
            }
        });
        json = JSONObject.fromObject(resultData, jsonConfig);
        return json;
    }

}
