package com.hand.app.hms.service.impl;

import com.hand.app.hms.service.IHanvonService;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

@Service
public class HanvonServiceImpl implements IHanvonService {
    private Logger logger = LoggerFactory.getLogger(HanvonServiceImpl.class);

    @Override
    public JSONObject post(String body, String https_url) {
        String resultData = "";
        String charset = "UTF-8";
        try {
            URL myURL = new URL(https_url);
            HttpURLConnection connection = (HttpURLConnection) myURL.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoInput(true);
            if (!body.isEmpty()) {
                connection.setDoOutput(true);
            }
            connection.setRequestProperty("Content-Type", "application/octet-stream");
            charset = "UTF-8";
            connection.connect();
            if (!body.isEmpty()) {
                OutputStream outputStream = connection.getOutputStream();
                outputStream.write(body.getBytes(charset));
                outputStream.flush();
                outputStream.close();
            }
            if (connection.getResponseCode() != 200) {
                throw new RuntimeException("HTTP GET Request Failed with Error code : " + connection.getResponseCode());
            }

            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"));
            StringBuilder results = new StringBuilder();
            String line;
            while ((line = reader.readLine()) != null) {
                results.append(line);
            }
            reader.close();
            connection.disconnect();
            resultData = results.toString();
        } catch (MalformedURLException e) {
            e.printStackTrace();
            logger.info("MalformedURLException", e.getMessage());

        } catch (IOException e) {
            e.printStackTrace();
            logger.info("IOException", e.getMessage());
        }
        //System.out.println(resultData);
        resultData = resultData.toString().replaceAll("null", "\"\"");

        return JSONObject.parseObject(resultData);
    }


    @Override
    public JSONObject get(String https_url) {
        return null;
    }
}
