package com.hand.app.electronicSignature.demo;

import constant.APIToolKitException;
import request.Tx1011Request;
import request.bean.KeyWordInfo;
import request.bean.LocationInfo;
import request.bean.SignInfo;
import request.bean.Signatory;
import service.SignAPI;
import util.Base64;
import util.FileHelper;
import util.StringUtil;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import java.util.LinkedList;

public class Test1011 {
    public static void main(String[] args) throws IOException {
        try {
            SignAPI.initAPI("./APIConfig");
            Tx1011Request tx1011Request = new Tx1011Request();
            tx1011Request.setContractType("ZL");
            tx1011Request.setPlatformSignatory(true);
            //tx1011Request.setSealId("82C3B5E88B79D9F5E0501FAC58A75B6D");
            tx1011Request.setSerialNumber("7ADBDD5ED80D743FE050007F010009X");
            tx1011Request.setContractName("123");
            tx1011Request.setContractFile(FileHelper.readFile("./file/1.pdf"));
            //企业盖章设置该项即可
            tx1011Request.setPlatformSignInfo(getSignInfoKeyWord("甲方"));


           // tx1011Request.setSignatories(getSignatores());
            String response = SignAPI.sendMessageAndGetResult(tx1011Request);
            String [] arg = {StringUtil.getNodeText(response,"contractId")};
            Test1019.main(arg);
            System.out.println(response);
        } catch (APIToolKitException e) {
            e.printStackTrace();
        }
    }


    public static SignInfo getSignInfoKeyWord(String keyWord){
        SignInfo signInfo = new SignInfo();
        KeyWordInfo keyWordInfo =new KeyWordInfo();
        keyWordInfo.setKeyWord(keyWord);
        keyWordInfo.setOffsetX(0);
        keyWordInfo.setOffsetY(20);
        keyWordInfo.setSealHeight(200);
        keyWordInfo.setSealWith(200);
        signInfo.setKeyWordInfo(keyWordInfo);
        return signInfo;
    }

    public static SignInfo getSignInfoLocation(){
        SignInfo signInfo = new SignInfo();
        LinkedList<LocationInfo> locationInfos = new LinkedList<LocationInfo>();
        LocationInfo locationInfo = new LocationInfo();
        locationInfo.setPage(1);
        locationInfo.setSealLBX(10);
        locationInfo.setSealLBY(10);
        locationInfo.setSealRUX(140);
        locationInfo.setSealRUY(130);
        locationInfos.add(locationInfo);
        signInfo.setLocationInfos(locationInfos);
        return signInfo;
    }


    public static LinkedList<Signatory> getSignatores(){
        LinkedList<Signatory> signatories = new LinkedList<Signatory>();
        Signatory signatory0 = new Signatory();
        signatory0.setUserId("8353661E9A67E9E1E0501FAC58A7035A");
        signatory0.setLocation("192.168.123.66");
        signatory0.setSignInfo(getSignInfoKeyWord("甲方："));
        signatory0.setAuthorizationTime("20190114095509");
        //signatory0.setSealId("7F678F3F76DDEFBFE0501FAC58A77205");
        signatories.add(signatory0);

        Signatory signatory1 = new Signatory();
        signatory1.setUserId("7DC312A2EB74A631E0501FAC58A75817");
        signatory1.setLocation("beijing");
        signatory1.setSignInfo(getSignInfoLocation());
        signatory1.setAuthorizationTime("20181121095509");
        signatories.add(signatory1);
        return signatories;
    }
}
