package com.hand.app.appManger.controllers;

import com.codahale.metrics.annotation.Timed;
import com.hand.app.appManger.dto.HlsAppVersion;
import com.hand.app.appManger.service.IHlsAppVersionService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * Created by Think-PC on 2018/10/8.
 */
@Controller
@RequestMapping(value = {"/r/api", "/"})
public class HlsAppVersionController extends BaseController {

    @Autowired
    private IHlsAppVersionService appVersionService;

    @RequestMapping(value = "/app/add/appVersion", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public ResponseData addAppVersion(HttpServletRequest request, @RequestBody List<HlsAppVersion> dto, BindingResult result) {
        getValidator().validate(dto, result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(getErrorMessage(result, request));
            return responseData;
        }
        IRequest requestCtx = createRequestContext(request);
        return new ResponseData(appVersionService.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value = "/app/delete/appVersion", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public int deleteAppVersion(HttpServletRequest request, @RequestBody List<HlsAppVersion> appVersion) {
        return appVersionService.batchDelete(appVersion);
    }

    /**
     * 查询全部
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/app/query/appVersionAll", method = RequestMethod.GET)
    @ResponseBody
    @Timed
    public ResponseData queryAllVersion(HlsAppVersion dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                                        @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(appVersionService.select(requestContext, dto, page, pageSize));
    }

    /**
     * 查询全部
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/app/query/appVersionByCode", method = RequestMethod.GET)
    @ResponseBody
    @Timed
    public ResponseData queryAppVersionByCode(HttpServletRequest request, @RequestParam("appCode") String appCode) {
        IRequest requestContext = createRequestContext(request);
        return appVersionService.queryAppVersion(requestContext, appCode);
    }
}
