package com.hand.app.appManger.controllers;

import com.codahale.metrics.annotation.Timed;
import com.hand.app.appManger.dto.AppHomePicture;
import com.hand.app.appManger.service.IAppHomePictureService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * Created by Think-PC on 2018/3/14.
 */
@Controller
@RequestMapping(value = {"/r/api","/"})
public class AppHomePictureController extends BaseController {
    @Autowired
    private IAppHomePictureService appHomeService;


    @RequestMapping(value = "/app/addHomePicture", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public ResponseData addPicture(HttpServletRequest request, @RequestBody List<AppHomePicture> dto, BindingResult result) {
        getValidator().validate(dto, result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(getErrorMessage(result, request));
            return responseData;
        }
        IRequest requestCtx = createRequestContext(request);
        return  new ResponseData(appHomeService.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value = "/app/deleteHomePicture", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public int deletePicture(HttpServletRequest request, @RequestBody List<AppHomePicture> picture) {
        return appHomeService.batchDelete(picture);
    }
    /**
     * 查询
     * @param request
     * @return
     */
    @RequestMapping(value = "/app/queryAll", method = RequestMethod.GET)
    @ResponseBody
    @Timed
    public ResponseData queryAllPicture(AppHomePicture dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                                        @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return  new ResponseData(appHomeService.select(requestContext, dto, page, pageSize));
    }

    /**
     * 查询
     * @param request
     * @return
     */
    @RequestMapping(value = "/app/queryHomePicture", method = RequestMethod.GET)
    @ResponseBody
    @Timed
    public ResponseData queryHomePicture(HttpServletRequest request,@RequestParam("appCode") String appCode) {
        return appHomeService.getHomePicture(createRequestContext(request),appCode);
    }

}
