package hls.support.core.db


import com.hand.hap.liquibase.MigrationHelper

def mhi = MigrationHelper.getInstance()

databaseChangeLog(logicalFilePath:"hls/support/core/db/2018-10-08-init-table-migration.groovy"){

    changeSet(author: "jingchao", id: "20181008-hls-app-version") {

        if(mhi.isDbType('oracle')){
            createSequence(sequenceName: 'hls_app_version_s')
        }
        createTable(tableName: "hls_app_version",remarks: 'APP版本信息') {
            column(autoIncrement: "true", name: "version_id", type: "BIGINT",remarks: '主键') {
                constraints(nullable: "false", primaryKey: "true")
            }
            column(name: "app_code", type:"VARCHAR(255)",remarks: 'APP代码')
            column(name: "version_num", type:"VARCHAR(255)",remarks: '版本号')
            column(name: "version_url", type:"VARCHAR(255)",remarks: '更新地址')
            column(name: "update_content", type:"VARCHAR(255)",remarks: '更新内容')
            column(name: "small_version", type:"VARCHAR(4)",defaultValue : "Y",remarks: '小版本更新')
            column(name: "big_version", type:"VARCHAR(4)",defaultValue : "N",remarks: '大版本更新')
            column(name: "platform", type:"VARCHAR(10)",defaultValue : "IOS",remarks: '平台')
            column(name: "enable_flag", type:"VARCHAR(4)",defaultValue : "Y",remarks: '启用标志')

            column(name: "object_version_number", type: "BIGINT", defaultValue : "1")
            column(name: "request_id", type: "BIGINT", defaultValue : "-1")
            column(name: "program_id", type: "BIGINT", defaultValue : "-1")
            column(name: "created_by", type: "BIGINT", defaultValue : "-1")
            column(name: "creation_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_updated_by", type: "BIGINT", defaultValue : "-1")
            column(name: "last_update_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_update_login", type: "BIGINT", defaultValue : "-1")
        }
    }
}
