package hls.support.core.db


import com.hand.hap.liquibase.MigrationHelper

def mhi = MigrationHelper.getInstance()

databaseChangeLog(logicalFilePath:"hls/support/core/db/2018-06-08-init-table-migration.groovy"){
    changeSet(author: "jingchao", id: "20180608-hms_thirdparty_app") {

        if(mhi.isDbType('oracle')){
            createSequence(sequenceName: 'hms_thirdparty_app_s')
        }
        createTable(tableName: "hms_thirdparty_app",remarks: '第三方应用表') {
            column(autoIncrement: "true", name: "ID", type: "BIGINT",remarks: '主键') {
                constraints(nullable: "false", primaryKey: "true")
            }
            column(name: "app_name", type:"VARCHAR(255)",remarks: '应用名')
            column(name: "app_desc", type:"VARCHAR(255)",remarks: '应用描述')
            column(name: "app_code", type:"VARCHAR(255)",remarks: '应用代码')
            column(name: "app_icon", type:"VARCHAR(255)",remarks: '应用图标')
            column(name: "app_key", type:"VARCHAR(255)",remarks: 'key')
            column(name: "app_secret", type:"VARCHAR(255)",remarks: 'SECRET')
            column(name: "free_flag", type :"VARCHAR(2)", remarks: 'FREE_FLAG')
            column(name: "expired_date", type:"DATETIME", remarks: '失效时间')
            column(name: "enable_flag" ,type:"VARCHAR(2)", remarks: '启用标志')
            column(name: "app_home_page",type: "VARCHAR(255)", remarks: '首页标志')
            column(name: "object_version_number", type: "BIGINT", defaultValue : "1")
            column(name: "request_id", type: "BIGINT", defaultValue : "-1")
            column(name: "program_id", type: "BIGINT", defaultValue : "-1")
            column(name: "created_by", type: "BIGINT", defaultValue : "-1")
            column(name: "creation_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_updated_by", type: "BIGINT", defaultValue : "-1")
            column(name: "last_update_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_update_login", type: "BIGINT", defaultValue : "-1")

            column(name: "ATTRIBUTE_CATEGORY",type:"varchar(30)")
            column(name: "ATTRIBUTE1",type:"varchar(240)")
            column(name: "ATTRIBUTE2",type:"varchar(240)")
            column(name: "ATTRIBUTE3",type:"varchar(240)")
            column(name: "ATTRIBUTE4",type:"varchar(240)")
            column(name: "ATTRIBUTE5",type:"varchar(240)")
            column(name: "ATTRIBUTE6",type:"varchar(240)")
            column(name: "ATTRIBUTE7",type:"varchar(240)")
            column(name: "ATTRIBUTE8",type:"varchar(240)")
            column(name: "ATTRIBUTE9",type:"varchar(240)")
            column(name: "ATTRIBUTE10",type:"varchar(240)")
            column(name: "ATTRIBUTE11",type:"varchar(240)")
            column(name: "ATTRIBUTE12",type:"varchar(240)")
            column(name: "ATTRIBUTE13",type:"varchar(240)")
            column(name: "ATTRIBUTE14",type:"varchar(240)")
            column(name: "ATTRIBUTE15",type:"varchar(240)")
        }
    }

    changeSet(author: "jingchao", id: "20180608-app-robot-message") {

        if(mhi.isDbType('oracle')){
            createSequence(sequenceName: 'app_robot_message_s')
        }
        createTable(tableName: "app_robot_message",remarks: '机器人聊天历史记录') {
            column(autoIncrement: "true", name: "message_id", type: "BIGINT",remarks: '主键') {
                constraints(nullable: "false", primaryKey: "true")
            }
            column(name: "channel", type:"VARCHAR(255)",remarks: '访客的来源渠道')
            column(name: "user_id", type:"VARCHAR(255)",remarks: '聊天对象')
            column(name: "session_id", type:"VARCHAR(255)",remarks: '会话的唯一标识')
            column(name: "question", type:"VARCHAR(255)",remarks: '问题')
            column(name: "chat_id", type:"VARCHAR(255)",remarks: '唯一标识当前问答记录')
            column(name: "answer", type:"VARCHAR(255)",remarks: '答案')
            column(name: "respond", type:"VARCHAR(255)",remarks: '响应')

            column(name: "object_version_number", type: "BIGINT", defaultValue : "1")
            column(name: "request_id", type: "BIGINT", defaultValue : "-1")
            column(name: "program_id", type: "BIGINT", defaultValue : "-1")
            column(name: "created_by", type: "BIGINT", defaultValue : "-1")
            column(name: "creation_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_updated_by", type: "BIGINT", defaultValue : "-1")
            column(name: "last_update_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_update_login", type: "BIGINT", defaultValue : "-1")
        }
    }

    changeSet(author: "jingchao", id: "20180608-app-time") {

        if(mhi.isDbType('oracle')){
            createSequence(sequenceName: 'app_time_s')
        }
        createTable(tableName: "app_time",remarks: '时间选项卡') {
            column(autoIncrement: "true", name: "time_id", type: "BIGINT",remarks: '主键') {
                constraints(nullable: "false", primaryKey: "true")
            }
            column(name: "time_title", type:"VARCHAR(255)",remarks: '主题')
            column(name: "time_start", type:"DATETIME",remarks: '开始时间')
            column(name: "time_end", type:"DATETIME",remarks: '结束时间')
            column(name: "time_description", type:"VARCHAR(255)",remarks: '备注')
            column(name: "time_color", type:"VARCHAR(255)",remarks: '主题颜色')
            column(name: "time_type", type:"VARCHAR(255)",remarks: '类型')
            column(name: "user_id", type:"BIGINT",remarks: '员工ID')

            column(name: "object_version_number", type: "BIGINT", defaultValue : "1")
            column(name: "request_id", type: "BIGINT", defaultValue : "-1")
            column(name: "program_id", type: "BIGINT", defaultValue : "-1")
            column(name: "created_by", type: "BIGINT", defaultValue : "-1")
            column(name: "creation_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_updated_by", type: "BIGINT", defaultValue : "-1")
            column(name: "last_update_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_update_login", type: "BIGINT", defaultValue : "-1")
        }
    }
}
