package hls.support.core.db


import com.hand.hap.liquibase.MigrationHelper

def mhi = MigrationHelper.getInstance()

databaseChangeLog(logicalFilePath:"hls/support/core/db/2018-12-29-init-table-migration.groovy"){

    changeSet(author: "jingchao", id: "20181229-sign-history") {

        if(mhi.isDbType('oracle')){
            createSequence(sequenceName: 'sign_history_s')
        }
        createTable(tableName: "sign_history",remarks: '签名历史表') {
            column(autoIncrement: "true", name: "sign_history_id", type: "BIGINT",remarks: '主键') {
                constraints(nullable: "false", primaryKey: "true")
            }
            column(name: "attachment_id", type:"VARCHAR(255)",remarks: '附件ID')
            column(name: "sign_service_id", type:"VARCHAR(255)")
            column(name: "sign_detail_url", type:"VARCHAR(255)"){
                constraints(nullable: "false")
            }
            column(name: "sign_type", type:"VARCHAR(10)")
            column(name: "sign_page", type:"VARCHAR(10)")
            column(name: "x", type:"VARCHAR(10)")
            column(name: "y", type:"VARCHAR(10)")

            column(name: "object_version_number", type: "BIGINT", defaultValue : "1")
            column(name: "request_id", type: "BIGINT", defaultValue : "-1")
            column(name: "program_id", type: "BIGINT", defaultValue : "-1")
            column(name: "created_by", type: "BIGINT", defaultValue : "-1")
            column(name: "creation_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_updated_by", type: "BIGINT", defaultValue : "-1")
            column(name: "last_update_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_update_login", type: "BIGINT", defaultValue : "-1")
        }
    }

    changeSet(author: "jingchao", id: "20181229-sign-info") {

        if(mhi.isDbType('oracle')){
            createSequence(sequenceName: 'sign_info_s')
        }
        createTable(tableName: "sign_info") {
            column(name: "id_no", type: "VARCHAR(32)",remarks: '身份证号') {
                constraints(nullable: "false", primaryKey: "true")
            }
            column(name: "name", type:"VARCHAR(255)",remarks: '姓名')
            column(name: "mobile", type:"VARCHAR(255)",remarks: '手机号')
            column(name: "email", type:"VARCHAR(255)",remarks: '邮箱')
            column(name: "organ", type:"VARCHAR(255)")
            column(name: "title", type:"VARCHAR(255)")
            column(name: "address", type:"VARCHAR(255)")
            column(name: "person_area", type:"BIGINT")
            column(name: "seal_data", type:"BLOB")
            column(name: "account_id", type:"VARCHAR(255)")

            column(name: "object_version_number", type: "BIGINT", defaultValue : "1")
            column(name: "request_id", type: "BIGINT", defaultValue : "-1")
            column(name: "program_id", type: "BIGINT", defaultValue : "-1")
            column(name: "created_by", type: "BIGINT", defaultValue : "-1")
            column(name: "creation_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_updated_by", type: "BIGINT", defaultValue : "-1")
            column(name: "last_update_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_update_login", type: "BIGINT", defaultValue : "-1")
        }
    }

    changeSet(author: "jingchao", id: "20181229-organize-sign-info") {

        if(mhi.isDbType('oracle')){
            createSequence(sequenceName: 'organize_sign_info_s')
        }
        createTable(tableName: "organize_sign_info") {
            column(name: "organ_code", type: "VARCHAR(255)") {
                constraints(nullable: "false", primaryKey: "true")
            }
            column(name: "name", type:"VARCHAR(255)")
            column(name: "organ_type", type:"VARCHAR(255)")
            column(name: "reg_type", type:"VARCHAR(255)")
            column(name: "user_type", type:"BIGINT")
            column(name: "agent_name", type:"VARCHAR(255)")
            column(name: "agent_id_no", type:"VARCHAR(255)")
            column(name: "legal_name", type:"VARCHAR(255)")
            column(name: "legal_area", type:"BIGINT")
            column(name: "legal_id_no", type:"VARCHAR(255)")
            column(name: "scope", type:"VARCHAR(255)")
            column(name: "mobile", type:"VARCHAR(255)")
            column(name: "email", type:"VARCHAR(255)")
            column(name: "address", type:"VARCHAR(255)")
            column(name: "seal_data", type:"BLOB")
            column(name: "account_id", type:"VARCHAR(255)")

            column(name: "object_version_number", type: "BIGINT", defaultValue : "1")
            column(name: "request_id", type: "BIGINT", defaultValue : "-1")
            column(name: "program_id", type: "BIGINT", defaultValue : "-1")
            column(name: "created_by", type: "BIGINT", defaultValue : "-1")
            column(name: "creation_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_updated_by", type: "BIGINT", defaultValue : "-1")
            column(name: "last_update_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_update_login", type: "BIGINT", defaultValue : "-1")
        }
    }

    changeSet(author: "jingchao", id: "20181229-person-data") {

        if(mhi.isDbType('oracle')){
            createSequence(sequenceName: 'person_data_s')
        }
        createTable(tableName: "person_data") {
            column(name: "account_id", type: "VARCHAR(255)") {
                constraints(nullable: "false", primaryKey: "true")
            }
            column(name: "seal_data", type:"BLOB")
            column(name: "template_type", type:"VARCHAR(255)")
            column(name: "color", type:"VARCHAR(255)")
            column(name: "htext", type:"VARCHAR(255)")
            column(name: "qtext", type:"VARCHAR(255)")

            column(name: "object_version_number", type: "BIGINT", defaultValue : "1")
            column(name: "request_id", type: "BIGINT", defaultValue : "-1")
            column(name: "program_id", type: "BIGINT", defaultValue : "-1")
            column(name: "created_by", type: "BIGINT", defaultValue : "-1")
            column(name: "creation_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_updated_by", type: "BIGINT", defaultValue : "-1")
            column(name: "last_update_date", type: "DATETIME", defaultValueComputed : "CURRENT_TIMESTAMP")
            column(name: "last_update_login", type: "BIGINT", defaultValue : "-1")
        }
    }
}
