/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatTokenUtils {
    public static final String Type_CORP_ID = "corp";
    public static final String TYPE_APP_ID = "app";
    public static final int CODE_UNRECOGNIZED_TOKEN_TYPE = -11;
    public static final int CODE_REQUEST_FAILED = -12;
    private static final String CORP_TOKEN_URL = "https://qyapi.weixin.qq.com/cgi-bin/gettoken";
    private static final String APP_TOKEN_URL = "https://api.weixin.qq.com/cgi-bin/token";
    private static Logger logger = LoggerFactory.getLogger(WechatTokenUtils.class);

    public static JSONObject getToken(String id, String secret, String type) {
        switch (type) {
            case "app": {
                if (logger.isTraceEnabled()) {
                    logger.trace("tokenType:{}", (Object)type);
                }
                return WechatTokenUtils.getAppToken(id, secret);
            }
            case "corp": {
                return WechatTokenUtils.getCorpToken(id, secret);
            }
        }
        logger.error("unrecognized TokenType: {}", (Object)type);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("errcode", (Object)-11);
        jsonObject.put("errmsg", (Object)"unrecognized TokenType");
        return jsonObject;
    }

    private static JSONObject getCorpToken(String id, String secret) {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=" + id + "&corpsecret=" + secret;
        return WechatTokenUtils.getRequest(url);
    }

    private static JSONObject getRequest(String url) {
        HttpGet get = new HttpGet(url);
        JSONObject jsonObject = new JSONObject();
        CloseableHttpClient client = HttpClients.createDefault();
        CloseableHttpResponse execute = null;
        try {
            execute = client.execute((HttpUriRequest)get);
        }
        catch (IOException e) {
            jsonObject.put("errcode", (Object)-12);
            jsonObject.put("errmsg", (Object)e.getMessage());
            logger.error("client execute failed: ", (Throwable)e);
        }
        if (execute != null) {
            HttpEntity entity = execute.getEntity();
            try {
                String s = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
                jsonObject = JSON.parseObject((String)s);
            }
            catch (IOException e) {
                logger.error("entity parse failed: ", (Throwable)e);
            }
        }
        return jsonObject;
    }

    private static JSONObject getAppToken(String id, String secret) {
        String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + id + "&secret=" + secret;
        return WechatTokenUtils.getRequest(url);
    }

    public static JSONObject getOpenId(String id, String secret, String code) {
        String openIdUrl = "https://api.weixin.qq.com/sns/jscode2session?appid=" + id + "&secret=" + secret + "&js_code=" + code + "&grant_type=authorization_code";
        return WechatTokenUtils.getRequest(openIdUrl);
    }
}

