/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.utils;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatFileUtil {
    private static Logger logger = LoggerFactory.getLogger(WechatFileUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downloadSftpFile(String host, String port, String username, String password, String filePath, String savePath) {
        InputStream inputStream;
        ChannelSftp sftp;
        Session session;
        block17: {
            block16: {
                JSch jsch = new JSch();
                session = null;
                try {
                    session = jsch.getSession(username, host, Integer.parseInt(port));
                }
                catch (JSchException e) {
                    if (!logger.isDebugEnabled()) break block16;
                    logger.debug("jsch get session failed: {}", (Throwable)e);
                }
            }
            if (session == null) {
                return false;
            }
            session.setPassword(password);
            Properties sshConfig = new Properties();
            sshConfig.put("StrictHostKeyChecking", "no");
            session.setConfig(sshConfig);
            sftp = null;
            inputStream = null;
            try {
                session.connect();
                Channel channel = session.openChannel("sftp");
                channel.connect();
                sftp = (ChannelSftp)channel;
                inputStream = sftp.get(filePath);
            }
            catch (JSchException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("jsch connect failed: {}", (Throwable)e);
                }
                session.disconnect();
                if (sftp != null) {
                    sftp.exit();
                }
            }
            catch (SftpException e) {
                if (!logger.isDebugEnabled()) break block17;
                logger.debug("sftp get file failed: {}", (Throwable)e);
            }
        }
        if (inputStream == null) {
            return false;
        }
        try {
            FileUtils.copyInputStreamToFile(inputStream, (File)new File(savePath));
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("file download failed: {}", (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            session.disconnect();
            if (sftp != null) {
                sftp.exit();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean uploadBySftp(String host, String port, String username, String password, String savePath, String fileName, InputStream in) {
        ChannelSftp sftp;
        block18: {
            Session session;
            block17: {
                JSch jsch = new JSch();
                session = null;
                try {
                    session = jsch.getSession(username, host, Integer.parseInt(port));
                }
                catch (JSchException e) {
                    if (!logger.isDebugEnabled()) break block17;
                    logger.debug("jsch get session failed: {}", (Throwable)e);
                }
            }
            if (session == null) {
                return false;
            }
            session.setPassword(password);
            Properties sshConfig = new Properties();
            sshConfig.put("StrictHostKeyChecking", "no");
            session.setConfig(sshConfig);
            sftp = null;
            try {
                session.connect();
                Channel channel = session.openChannel("sftp");
                channel.connect();
                sftp = (ChannelSftp)channel;
            }
            catch (JSchException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("jsch connect failed: {}", (Throwable)e);
                }
                session.disconnect();
                if (sftp == null) break block18;
                sftp.exit();
            }
        }
        if (fileName == null || fileName.trim().length() < 1) {
            fileName = UUID.randomUUID().toString().replaceAll("-", "");
        }
        if (sftp == null) {
            return false;
        }
        try {
            sftp.cd(savePath);
        }
        catch (Exception e) {
            try {
                sftp.mkdir(savePath);
                sftp.cd(savePath);
            }
            catch (SftpException e1) {
                logger.error("to server path({}) error:{}", (Object)savePath, (Object)e1);
            }
        }
        try {
            sftp.put(in, fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sftp.exit();
        }
        return false;
    }

    public static boolean saveFile(byte[] content, String filePath) throws IOException {
        File file = new File(filePath);
        if (file.exists() || file.isDirectory()) {
            throw new IOException("file exists or is a directory");
        }
        file.mkdir();
        FileOutputStream out = new FileOutputStream(file);
        out.write(content);
        out.flush();
        out.close();
        return true;
    }

    public static boolean saveFile(InputStream in, String filePath) throws IOException {
        File file = new File(filePath);
        if (file.exists() || file.isDirectory()) {
            throw new IOException("file exists or is a directory");
        }
        file.mkdir();
        FileUtils.copyInputStreamToFile((InputStream)in, (File)file);
        return true;
    }

    public static String getRandomFileName() {
        return StringUtils.removeAll((String)UUID.randomUUID().toString(), (String)"-");
    }

    public static String getRandomFileName(String prefix) {
        return prefix + (prefix.charAt(prefix.length() - 1) == File.separatorChar ? "" : Character.valueOf(File.pathSeparatorChar)) + WechatFileUtil.getRandomFileName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void downloadFile(String filePath, String fileName, HttpServletResponse response) {
        File file = new File(filePath);
        if (!file.exists()) {
            logger.error("target file does not exists.");
            response.setStatus(204);
            return;
        }
        response.setContentType("application/octet-stream");
        response.addHeader("Content-Disposition", "attachment;fileName=" + fileName);
        response.setContentLength((int)FileUtils.sizeOf((File)file));
        FileInputStream is = null;
        ServletOutputStream os = null;
        try {
            is = new FileInputStream(file);
            os = response.getOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (Exception e) {
            try {
                logger.error("io transformation failed when download file.", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(os);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((OutputStream)os);
            return;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
        return;
    }
}

