/*
 * Decompiled with CFR 0.152.
 */
package hls.support.core.wechat.utils;

import hls.support.core.wechat.dto.wechat.enums.EnumMethod;
import hls.support.core.wechat.utils.WechatMyX509TrustManager;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import net.sf.json.JSONObject;

public class HttpRequestUtil {
    public static JSONObject httpRequest(String requestUrl, String requestMethod, String outputStr) {
        System.err.println("HttpRequestUtil:" + requestMethod + "\toutputStr=" + outputStr);
        JSONObject jsonObject = null;
        StringBuffer buffer = new StringBuffer();
        try {
            TrustManager[] tm = new TrustManager[]{new WechatMyX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, tm, new SecureRandom());
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            URL url = new URL(requestUrl);
            HttpsURLConnection httpUrlConn = (HttpsURLConnection)url.openConnection();
            httpUrlConn.setSSLSocketFactory(ssf);
            httpUrlConn.setDoOutput(true);
            httpUrlConn.setDoInput(true);
            httpUrlConn.setUseCaches(false);
            httpUrlConn.setRequestMethod(requestMethod);
            if ("GET".equalsIgnoreCase(requestMethod)) {
                httpUrlConn.connect();
            }
            if (null != outputStr) {
                OutputStream outputStream = httpUrlConn.getOutputStream();
                outputStream.write(outputStr.getBytes("UTF-8"));
                outputStream.close();
            }
            InputStream inputStream = httpUrlConn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
            inputStream = null;
            httpUrlConn.disconnect();
            jsonObject = JSONObject.fromObject((Object)buffer.toString());
        }
        catch (ConnectException ce) {
            ce.printStackTrace();
            System.out.println("\u7f51\u7edc\u94fe\u63a5\u5931\u8d25\uff01");
        }
        catch (UnknownHostException uhe) {
            uhe.printStackTrace();
            System.out.println("\u5fae\u4fe1API\u65e0\u6cd5\u8bbf\u95ee...\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    public static byte[] httpRequest_byte(String requestUrl, String requestMethod, byte[] data) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int len;
            URL url;
            HttpURLConnection httpUrlConn;
            if (requestMethod == EnumMethod.GET.name() && data != null && data.length > 0) {
                requestUrl = requestUrl.indexOf(63) > 0 ? requestUrl + '&' : requestUrl + '?';
                requestUrl = requestUrl + new String(data);
            }
            if ((httpUrlConn = (HttpURLConnection)(url = new URL(requestUrl)).openConnection()) instanceof HttpsURLConnection) {
                TrustManager[] tm = new TrustManager[]{new WechatMyX509TrustManager()};
                SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
                sslContext.init(null, tm, new SecureRandom());
                SSLSocketFactory ssf = sslContext.getSocketFactory();
                ((HttpsURLConnection)httpUrlConn).setSSLSocketFactory(ssf);
            }
            boolean truePost = requestMethod == EnumMethod.POST.name() && data != null && data.length > 0;
            httpUrlConn.setDoOutput(truePost);
            httpUrlConn.setDoInput(true);
            httpUrlConn.setUseCaches(false);
            httpUrlConn.setRequestMethod(requestMethod);
            if (requestMethod == EnumMethod.GET.name()) {
                httpUrlConn.connect();
            } else if (truePost) {
                OutputStream outputStream = httpUrlConn.getOutputStream();
                outputStream.write(data);
                outputStream.close();
            }
            InputStream inputStream = httpUrlConn.getInputStream();
            byte[] buf = new byte[2048];
            while ((len = inputStream.read(buf)) != -1) {
                out.write(buf, 0, len);
            }
            out.close();
            inputStream.close();
            inputStream = null;
            httpUrlConn.disconnect();
        }
        catch (ConnectException connectException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out.toByteArray();
    }
}

